/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcasterFuture<E>
implements Future {
    private static final Logger logger = LoggerFactory.getLogger(BroadcasterFuture.class);
    private final CountDownLatch latch;
    private boolean isCancelled = false;
    private boolean isDone = false;
    private final E msg;
    private final Future<?> innerFuture;
    private final CopyOnWriteArrayList<BroadcasterListener> listeners;
    private final Broadcaster broadcaster;
    private final AtomicBoolean notified = new AtomicBoolean();

    public BroadcasterFuture(E msg, CopyOnWriteArrayList<BroadcasterListener> listeners, Broadcaster b) {
        this(null, msg, listeners, b);
    }

    public BroadcasterFuture(Future<?> innerFuture, E msg, CopyOnWriteArrayList<BroadcasterListener> listeners, Broadcaster b) {
        this(innerFuture, msg, 1, listeners, b);
    }

    public BroadcasterFuture(E msg, int latchCount, CopyOnWriteArrayList<BroadcasterListener> listeners, Broadcaster b) {
        this(null, msg, latchCount, listeners, b);
    }

    public BroadcasterFuture(Future<?> innerFuture, E msg, int latchCount, CopyOnWriteArrayList<BroadcasterListener> listeners, Broadcaster b) {
        this.msg = msg;
        this.innerFuture = innerFuture;
        this.broadcaster = b;
        this.latch = innerFuture == null ? new CountDownLatch(latchCount) : null;
        this.listeners = listeners;
    }

    @Override
    public boolean cancel(boolean b) {
        if (this.innerFuture != null) {
            return this.innerFuture.cancel(b);
        }
        this.isCancelled = true;
        this.notifyListener();
        while (this.latch.getCount() > 0L) {
            this.latch.countDown();
        }
        return this.isCancelled;
    }

    @Override
    public boolean isCancelled() {
        if (this.innerFuture != null) {
            return this.innerFuture.isCancelled();
        }
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        if (this.innerFuture != null) {
            return this.innerFuture.isDone();
        }
        this.isDone = true;
        return this.isDone;
    }

    public BroadcasterFuture<E> done() {
        this.isDone = true;
        if (this.latch != null) {
            if (this.latch.getCount() - 1L <= 0L) {
                this.notifyListener();
            }
            this.latch.countDown();
        }
        return this;
    }

    public E get() throws InterruptedException, ExecutionException {
        if (this.innerFuture != null) {
            return (E)this.innerFuture.get();
        }
        this.latch.await();
        this.notifyListener();
        return this.msg;
    }

    void notifyListener() {
        if (!this.notified.getAndSet(true)) {
            for (BroadcasterListener b : this.listeners) {
                try {
                    b.onComplete(this.broadcaster);
                }
                catch (Exception ex) {
                    logger.warn("", (Throwable)ex);
                }
            }
        }
    }

    public E get(long l, TimeUnit tu) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.innerFuture != null) {
            return (E)this.innerFuture.get();
        }
        this.latch.await(l, tu);
        this.notifyListener();
        return this.msg;
    }
}

