/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.atmosphere.cache.UUIDBroadcasterCache;
import org.atmosphere.config.ApplicationConfiguration;
import org.atmosphere.config.AtmosphereHandlerConfig;
import org.atmosphere.config.AtmosphereHandlerProperty;
import org.atmosphere.config.FrameworkConfiguration;
import org.atmosphere.container.BlockingIOCometSupport;
import org.atmosphere.container.Tomcat7BIOSupportWithWebSocket;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AnnotationProcessor;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsyncSupportListener;
import org.atmosphere.cpr.AsyncSupportListenerAdapter;
import org.atmosphere.cpr.AsyncSupportResolver;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.cpr.DefaultAsyncSupportResolver;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.DefaultBroadcasterFactory;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.SessionSupport;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.di.InjectorProvider;
import org.atmosphere.di.ServletContextHolder;
import org.atmosphere.di.ServletContextProvider;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.interceptor.AndroidAtmosphereInterceptor;
import org.atmosphere.interceptor.JSONPAtmosphereInterceptor;
import org.atmosphere.interceptor.JavaScriptProtocol;
import org.atmosphere.interceptor.OnDisconnectInterceptor;
import org.atmosphere.interceptor.SSEAtmosphereInterceptor;
import org.atmosphere.util.AtmosphereConfigReader;
import org.atmosphere.util.IntrospectionUtils;
import org.atmosphere.util.ServletProxyFactory;
import org.atmosphere.util.Version;
import org.atmosphere.util.analytics.FocusPoint;
import org.atmosphere.util.analytics.JGoogleAnalyticsTracker;
import org.atmosphere.util.analytics.ModuleDetection;
import org.atmosphere.websocket.DefaultWebSocketProcessor;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProtocol;
import org.atmosphere.websocket.protocol.SimpleHttpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereFramework
implements ServletContextProvider {
    public static final String DEFAULT_ATMOSPHERE_CONFIG_PATH = "/META-INF/atmosphere.xml";
    public static final String DEFAULT_LIB_PATH = "/WEB-INF/lib/";
    public static final String MAPPING_REGEX = "[a-zA-Z0-9-&.*=@~;\\?]+";
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereFramework.class);
    protected final List<String> broadcasterFilters = new ArrayList<String>();
    protected final List<AsyncSupportListener> asyncSupportListeners = new ArrayList<AsyncSupportListener>();
    protected final ArrayList<String> possibleComponentsCandidate = new ArrayList();
    protected final HashMap<String, String> initParams = new HashMap();
    protected final AtmosphereConfig config;
    protected final AtomicBoolean isCometSupportConfigured = new AtomicBoolean(false);
    protected final boolean isFilter;
    protected final Map<String, AtmosphereHandlerWrapper> atmosphereHandlers = new ConcurrentHashMap<String, AtmosphereHandlerWrapper>();
    protected final ConcurrentLinkedQueue<String> broadcasterTypes = new ConcurrentLinkedQueue();
    protected boolean useNativeImplementation = false;
    protected boolean useBlockingImplementation = false;
    protected boolean useStreamForFlushingComments = false;
    protected AsyncSupport asyncSupport;
    protected String broadcasterClassName = DefaultBroadcaster.class.getName();
    protected boolean isCometSupportSpecified = false;
    protected boolean isBroadcasterSpecified = false;
    protected boolean isSessionSupportSpecified = false;
    protected BroadcasterFactory broadcasterFactory;
    protected String broadcasterFactoryClassName;
    protected String broadcasterCacheClassName;
    protected boolean webSocketEnabled = true;
    protected String broadcasterLifeCyclePolicy = "NEVER";
    protected String webSocketProtocolClassName = SimpleHttpProtocol.class.getName();
    protected WebSocketProtocol webSocketProtocol;
    protected String handlersPath = "/WEB-INF/classes/";
    protected ServletConfig servletConfig;
    protected boolean autoDetectHandlers = true;
    private boolean hasNewWebSocketProtocol = false;
    protected String atmosphereDotXmlPath = "/META-INF/atmosphere.xml";
    protected final LinkedList<AtmosphereInterceptor> interceptors = new LinkedList();
    protected boolean scanDone = false;
    protected String annotationProcessorClassName = "org.atmosphere.cpr.DefaultAnnotationProcessor";
    protected final List<BroadcasterListener> broadcasterListeners = new ArrayList<BroadcasterListener>();
    protected String webSocketProcessorClassName = DefaultWebSocketProcessor.class.getName();
    protected String libPath = "/WEB-INF/lib/";
    protected boolean isInit;
    protected boolean sharedThreadPools = true;
    protected final List<String> packages = new ArrayList<String>();

    public AtmosphereFramework() {
        this(false, true);
    }

    public AtmosphereFramework(ServletConfig sc) throws ServletException {
        this(false, true);
        this.init(sc);
    }

    public AtmosphereFramework(boolean isFilter, boolean autoDetectHandlers) {
        this.isFilter = isFilter;
        this.autoDetectHandlers = autoDetectHandlers;
        this.readSystemProperties();
        this.populateBroadcasterType();
        this.config = new AtmosphereConfig(this);
    }

    private void populateBroadcasterType() {
        this.broadcasterTypes.add("org.atmosphere.plugin.hazelcast.HazelcastBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.xmpp.XMPPBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.redis.RedisBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.jgroups.JGroupsBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.jms.JMSBroadcaster");
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, List<AtmosphereInterceptor> l) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(this.broadcasterFactory, h, mapping);
        w.interceptors = l;
        this.addMapping(mapping, w);
        logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)h.getClass().getName(), (Object)mapping);
        if (l.size() > 0) {
            logger.info("Installed AtmosphereInterceptor {} mapped to AtmosphereHandler {}", l, (Object)h.getClass().getName());
        }
        return this;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h) {
        this.addAtmosphereHandler(mapping, h, Collections.<AtmosphereInterceptor>emptyList());
        return this;
    }

    private AtmosphereFramework addMapping(String path, AtmosphereHandlerWrapper w) {
        if (path.contains("*")) {
            path = path.replace("*", MAPPING_REGEX);
        }
        if (path.endsWith("/")) {
            path = path + MAPPING_REGEX;
        }
        InjectorProvider.getInjector().inject(w.atmosphereHandler);
        this.atmosphereHandlers.put(path, w);
        return this;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, String broadcasterId, List<AtmosphereInterceptor> l) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(this.broadcasterFactory, h, mapping);
        w.broadcaster.setID(broadcasterId);
        w.interceptors = l;
        this.addMapping(mapping, w);
        logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)h.getClass().getName(), (Object)mapping);
        if (l.size() > 0) {
            logger.info("Installed AtmosphereInterceptor {} mapped to AtmosphereHandler {}", l, (Object)h.getClass().getName());
        }
        return this;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, String broadcasterId) {
        this.addAtmosphereHandler(mapping, h, broadcasterId, Collections.<AtmosphereInterceptor>emptyList());
        return this;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, Broadcaster broadcaster, List<AtmosphereInterceptor> l) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h, broadcaster);
        w.interceptors = l;
        this.addMapping(mapping, w);
        logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)h.getClass().getName(), (Object)mapping);
        if (l.size() > 0) {
            logger.info("Installed AtmosphereInterceptor {} mapped to AtmosphereHandler {}", l, (Object)h.getClass().getName());
        }
        return this;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, Broadcaster broadcaster) {
        this.addAtmosphereHandler(mapping, h, broadcaster, Collections.<AtmosphereInterceptor>emptyList());
        return this;
    }

    public AtmosphereFramework removeAtmosphereHandler(String mapping) {
        if (mapping.endsWith("/")) {
            mapping = mapping + MAPPING_REGEX;
        }
        this.atmosphereHandlers.remove(mapping);
        return this;
    }

    public AtmosphereFramework removeAllAtmosphereHandler() {
        this.atmosphereHandlers.clear();
        return this;
    }

    public AtmosphereFramework removeAllInitParams() {
        this.initParams.clear();
        return this;
    }

    public AtmosphereFramework addInitParameter(String name, String value) {
        this.initParams.put(name, value);
        return this;
    }

    protected void readSystemProperties() {
        if (System.getProperty("org.atmosphere.useNative") != null) {
            this.useNativeImplementation = Boolean.parseBoolean(System.getProperty("org.atmosphere.useNative"));
            this.isCometSupportSpecified = true;
        }
        if (System.getProperty("org.atmosphere.useBlocking") != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(System.getProperty("org.atmosphere.useBlocking"));
            this.isCometSupportSpecified = true;
        }
        this.atmosphereDotXmlPath = System.getProperty("org.atmosphere.atmosphereDotXml", this.atmosphereDotXmlPath);
        if (System.getProperty("org.atmosphere.disableOnStateEvent") != null) {
            this.initParams.put("org.atmosphere.disableOnStateEvent", System.getProperty("org.atmosphere.disableOnStateEvent"));
        }
    }

    public void patchContainer() {
        System.setProperty("org.apache.catalina.STRICT_SERVLET_COMPLIANCE", "false");
    }

    public AtmosphereFramework init() {
        try {
            this.init(new ServletConfig(){

                public String getServletName() {
                    return "AtmosphereFramework";
                }

                public ServletContext getServletContext() {
                    return (ServletContext)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ServletContext.class}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            return ServletProxyFactory.getDefault().proxy(proxy, method, args);
                        }
                    });
                }

                public String getInitParameter(String name) {
                    return AtmosphereFramework.this.initParams.get(name);
                }

                public Enumeration<String> getInitParameterNames() {
                    return Collections.enumeration(AtmosphereFramework.this.initParams.values());
                }
            });
        }
        catch (ServletException e) {
            logger.error("", (Throwable)e);
        }
        return this;
    }

    public AtmosphereFramework init(final ServletConfig sc) throws ServletException {
        if (this.isInit) {
            return this;
        }
        try {
            ServletConfig scFacade;
            ServletContextHolder.register(this);
            this.servletConfig = scFacade = new ServletConfig(){

                public String getServletName() {
                    return sc.getServletName();
                }

                public ServletContext getServletContext() {
                    return sc.getServletContext();
                }

                public String getInitParameter(String name) {
                    String param = AtmosphereFramework.this.initParams.get(name);
                    if (param == null) {
                        return sc.getInitParameter(name);
                    }
                    return param;
                }

                public Enumeration<String> getInitParameterNames() {
                    Enumeration en = sc.getInitParameterNames();
                    while (en.hasMoreElements()) {
                        String name = (String)en.nextElement();
                        if (AtmosphereFramework.this.initParams.containsKey(name)) continue;
                        AtmosphereFramework.this.initParams.put(name, sc.getInitParameter(name));
                    }
                    return Collections.enumeration(AtmosphereFramework.this.initParams.keySet());
                }
            };
            this.doInitParams(scFacade);
            this.doInitParamsForWebSocket(scFacade);
            this.asyncSupportListener(new AsyncSupportListenerAdapter());
            this.configureBroadcasterFactory();
            this.configureScanningPackage(sc);
            this.autoConfigureService(scFacade.getServletContext());
            this.configureBroadcasterFactory();
            this.patchContainer();
            this.configureBroadcaster();
            this.loadConfiguration(scFacade);
            this.initWebSocket();
            this.autoDetectContainer();
            this.configureWebDotXmlAtmosphereHandler(sc);
            this.asyncSupport.init(scFacade);
            this.initAtmosphereHandler(scFacade);
            this.configureAtmosphereInterceptor(sc);
            this.analytics();
            if (this.broadcasterCacheClassName == null) {
                logger.warn("No BroadcasterCache configured. Broadcasted message between client reconnection will be LOST. It is recommended to configure the {}", (Object)UUIDBroadcasterCache.class.getName());
            } else {
                logger.info("Using BroadcasterCache: {}", (Object)this.broadcasterCacheClassName);
            }
            if (sc.getServletContext() != null) {
                sc.getServletContext().setAttribute(BroadcasterFactory.class.getName(), (Object)this.broadcasterFactory);
            }
            for (String i : this.broadcasterFilters) {
                logger.info("Using BroadcastFilter: {}", (Object)i);
            }
            String s = this.config.getInitParameter(ApplicationConfig.BROADCASTER_SHARABLE_THREAD_POOLS);
            if (s != null) {
                this.sharedThreadPools = Boolean.parseBoolean(s);
            }
            logger.info("Shared ExecutorService supported: {}", (Object)this.sharedThreadPools);
            logger.info("HttpSession supported: {}", (Object)this.config.isSupportSession());
            logger.info("Using BroadcasterFactory: {}", (Object)this.broadcasterFactory.getClass().getName());
            logger.info("Using WebSocketProcessor: {}", (Object)this.webSocketProcessorClassName);
            logger.info("Using Broadcaster: {}", (Object)this.broadcasterClassName);
            logger.info("Atmosphere Framework {} started.", (Object)Version.getRawVersion());
            logger.info("\n\n\tFor Atmosphere Framework Commercial Support, visit \n\t{} or send an email to {}\n", (Object)"http://www.async-io.org/", (Object)"support@async-io.org");
        }
        catch (Throwable t) {
            logger.error("Failed to initialize Atmosphere Framework", t);
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
        this.isInit = true;
        return this;
    }

    protected void analytics() {
        final String container = this.getServletContext().getServerInfo();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HttpURLConnection urlConnection = (HttpURLConnection)URI.create("http://async-io.org/version.html").toURL().openConnection();
                    urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0");
                    urlConnection.setRequestProperty("Connection", "keep-alive");
                    urlConnection.setRequestProperty("Cache-Control", "max-age=0");
                    urlConnection.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
                    urlConnection.setRequestProperty("Accept-Language", "en-US,en;q=0.8");
                    urlConnection.setRequestProperty("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.3");
                    urlConnection.setRequestProperty("If-Modified-Since", "ISO-8859-1,utf-8;q=0.7,*;q=0.3");
                    urlConnection.setInstanceFollowRedirects(true);
                    BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                    String newVersion = Version.getRawVersion();
                    try {
                        String inputLine;
                        while ((inputLine = in.readLine().trim()) != null) {
                            if (!inputLine.startsWith("ATMO_VERSION=")) continue;
                            newVersion = inputLine.substring("ATMO_VERSION=".length());
                            break;
                        }
                    }
                    finally {
                        if (newVersion.compareTo(Version.getRawVersion()) != 0) {
                            logger.info("\n\n\tCurrent version of Atmosphere {} \n\tNewest version of Atmosphere available {}\n\n", (Object)Version.getRawVersion(), (Object)newVersion);
                        }
                        try {
                            in.close();
                        }
                        catch (IOException ex) {}
                        urlConnection.disconnect();
                    }
                    JGoogleAnalyticsTracker tracker = new JGoogleAnalyticsTracker(ModuleDetection.detect(), Version.getRawVersion(), "UA-31990725-1");
                    tracker.trackSynchronously(new FocusPoint(container, new FocusPoint("AtmosphereFramework")));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected void configureAtmosphereInterceptor(ServletConfig sc) {
        String s = sc.getInitParameter(ApplicationConfig.ATMOSPHERE_INTERCEPTORS);
        if (s != null) {
            String[] list;
            for (String a : list = s.split(",")) {
                try {
                    AtmosphereInterceptor ai = (AtmosphereInterceptor)Thread.currentThread().getContextClassLoader().loadClass(a.trim()).newInstance();
                    ai.configure(this.config);
                    this.interceptor(ai);
                }
                catch (InstantiationException e) {
                    logger.warn("", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    logger.warn("", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    logger.warn("", (Throwable)e);
                }
            }
        }
        if ((s = sc.getInitParameter(ApplicationConfig.DISABLE_ATMOSPHEREINTERCEPTOR)) == null) {
            this.interceptors.addFirst(this.newAInterceptor(OnDisconnectInterceptor.class));
            this.interceptors.addFirst(this.newAInterceptor(JavaScriptProtocol.class));
            this.interceptors.addFirst(this.newAInterceptor(JSONPAtmosphereInterceptor.class));
            this.interceptors.addFirst(this.newAInterceptor(SSEAtmosphereInterceptor.class));
            this.interceptors.addFirst(this.newAInterceptor(AndroidAtmosphereInterceptor.class));
            logger.info("Installed Default AtmosphereInterceptor {}. Set org.atmosphere.cpr.AtmosphereInterceptor.disableDefaults in your xml to disable them.", this.interceptors);
        }
    }

    protected AtmosphereInterceptor newAInterceptor(Class<? extends AtmosphereInterceptor> a) {
        AtmosphereInterceptor ai = null;
        try {
            ai = (AtmosphereInterceptor)this.getClass().getClassLoader().loadClass(a.getName()).newInstance();
            ai.configure(this.config);
        }
        catch (Exception ex) {
            logger.warn("", (Throwable)ex);
        }
        return ai;
    }

    protected void configureWebDotXmlAtmosphereHandler(ServletConfig sc) {
        String s = sc.getInitParameter(ApplicationConfig.ATMOSPHERE_HANDLER);
        if (s != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                String mapping = sc.getInitParameter(ApplicationConfig.ATMOSPHERE_HANDLER_MAPPING);
                if (mapping == null) {
                    mapping = "/*";
                }
                this.addAtmosphereHandler(mapping, (AtmosphereHandler)cl.loadClass(s).newInstance());
            }
            catch (Exception ex) {
                logger.warn("Unable to load WebSocketHandle instance", (Throwable)ex);
            }
        }
    }

    protected void configureScanningPackage(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.cpr.packages");
        if (s != null) {
            String[] list;
            for (String a : list = s.split(",")) {
                this.packages.add(a);
            }
        }
    }

    protected void configureBroadcasterFactory() {
        try {
            if (!this.isBroadcasterSpecified) {
                this.broadcasterClassName = this.lookupDefaultBroadcasterType(this.broadcasterClassName);
            }
            if (this.broadcasterFactoryClassName != null) {
                this.broadcasterFactory = (BroadcasterFactory)Thread.currentThread().getContextClassLoader().loadClass(this.broadcasterFactoryClassName).newInstance();
            }
            if (this.broadcasterFactory == null) {
                Class<?> bc = Thread.currentThread().getContextClassLoader().loadClass(this.broadcasterClassName);
                this.broadcasterFactory = new DefaultBroadcasterFactory(bc, this.broadcasterLifeCyclePolicy, this.config);
            }
            for (BroadcasterListener b : this.broadcasterListeners) {
                this.broadcasterFactory.addBroadcasterListener(b);
            }
            BroadcasterFactory.setBroadcasterFactory(this.broadcasterFactory, this.config);
            InjectorProvider.getInjector().inject(this.broadcasterFactory);
        }
        catch (Exception ex) {
            logger.error("Unable to configure Broadcaster/Factory/Cache", (Throwable)ex);
        }
    }

    protected void configureBroadcaster() {
        try {
            for (Map.Entry<String, AtmosphereHandlerWrapper> e : this.atmosphereHandlers.entrySet()) {
                AtmosphereHandlerWrapper w = e.getValue();
                if (w.broadcaster == null) {
                    w.broadcaster = this.broadcasterFactory.get(w.mapping);
                    continue;
                }
                if (this.broadcasterCacheClassName == null) continue;
                BroadcasterCache cache = (BroadcasterCache)Thread.currentThread().getContextClassLoader().loadClass(this.broadcasterCacheClassName).newInstance();
                InjectorProvider.getInjector().inject(cache);
                w.broadcaster.getBroadcasterConfig().setBroadcasterCache(cache);
            }
        }
        catch (Exception ex) {
            logger.error("Unable to configure Broadcaster/Factory/Cache", (Throwable)ex);
        }
    }

    protected void doInitParamsForWebSocket(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.useWebSocket");
        if (s != null) {
            this.webSocketEnabled = Boolean.parseBoolean(s);
            this.sessionSupport(false);
        }
        if ((s = sc.getInitParameter(ApplicationConfig.WEBSOCKET_PROTOCOL)) != null) {
            this.webSocketProtocolClassName = s;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.WEBSOCKET_PROCESSOR)) != null) {
            this.webSocketProcessorClassName = s;
        }
    }

    protected void doInitParams(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.useNative");
        if (s != null) {
            this.useNativeImplementation = Boolean.parseBoolean(s);
            if (this.useNativeImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter("org.atmosphere.useBlocking")) != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(s);
            if (this.useBlockingImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter("org.atmosphere.useStream")) != null) {
            this.useStreamForFlushingComments = Boolean.parseBoolean(s);
        }
        if ((s = sc.getInitParameter(ApplicationConfig.PROPERTY_COMET_SUPPORT)) != null) {
            this.asyncSupport = new DefaultAsyncSupportResolver(this.config).newCometSupport(s);
            this.isCometSupportSpecified = true;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCASTER_CLASS)) != null) {
            this.broadcasterClassName = s;
            this.isBroadcasterSpecified = true;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCASTER_CACHE)) != null) {
            this.broadcasterCacheClassName = s;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.PROPERTY_SESSION_SUPPORT)) != null) {
            this.config.setSupportSession(Boolean.valueOf(s));
            if (sc.getServletContext().getMajorVersion() >= 3) {
                try {
                    sc.getServletContext().addListener(SessionSupport.class);
                }
                catch (Throwable t) {
                    logger.error("SessionSupport error", t);
                    logger.debug("Make sure you define {} as a listener in web.xml", (Object)SessionSupport.class.getName());
                }
            } else {
                logger.debug("Make sure you define {} as a listener in web.xml", (Object)SessionSupport.class.getName());
            }
            this.isSessionSupportSpecified = true;
        }
        if ((s = sc.getInitParameter("org.atmosphere.disableOnStateEvent")) != null) {
            this.initParams.put("org.atmosphere.disableOnStateEvent", s);
        } else {
            this.initParams.put("org.atmosphere.disableOnStateEvent", "false");
        }
        s = sc.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive");
        if (s != null) {
            this.initParams.put("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive", s);
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCAST_FILTER_CLASSES)) != null) {
            this.broadcasterFilters.addAll(Arrays.asList(s.split(",")));
            logger.info("Installing BroadcastFilter class(es) {}", (Object)s);
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCASTER_LIFECYCLE_POLICY)) != null) {
            this.broadcasterLifeCyclePolicy = s;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCASTER_FACTORY)) != null) {
            this.broadcasterFactoryClassName = s;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.ATMOSPHERE_HANDLER_PATH)) != null) {
            this.handlersPath = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.atmosphereDotXml")) != null) {
            this.atmosphereDotXmlPath = s;
        }
    }

    public void loadConfiguration(ServletConfig sc) throws ServletException {
        if (!this.autoDetectHandlers) {
            return;
        }
        try {
            URL url = sc.getServletContext().getResource(this.handlersPath);
            URLClassLoader urlC = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            this.loadAtmosphereDotXml(sc.getServletContext().getResourceAsStream(this.atmosphereDotXmlPath), urlC);
            if (this.atmosphereHandlers.size() == 0) {
                this.autoDetectAtmosphereHandlers(sc.getServletContext(), urlC);
                if (this.atmosphereHandlers.size() == 0) {
                    this.detectSupportedFramework(sc);
                }
            }
            this.autoDetectWebSocketHandler(sc.getServletContext(), urlC);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    protected boolean detectSupportedFramework(ServletConfig sc) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Broadcaster b;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String broadcasterClassNameTmp = null;
        try {
            cl.loadClass("com.sun.jersey.spi.container.servlet.ServletContainer");
            if (!this.isBroadcasterSpecified) {
                broadcasterClassNameTmp = this.lookupDefaultBroadcasterType("org.atmosphere.jersey.JerseyBroadcaster");
                cl.loadClass(broadcasterClassNameTmp);
            }
            this.useStreamForFlushingComments = true;
            StringBuffer packagesInit = new StringBuffer();
            for (String s : this.packages) {
                packagesInit.append(s).append(",");
            }
            if (this.packages.size() > 0) {
                this.initParams.put("com.sun.jersey.config.property.packages", packagesInit.toString());
            }
        }
        catch (Throwable t) {
            logger.trace("", t);
            return false;
        }
        logger.warn("Missing META-INF/atmosphere.xml but found the Jersey runtime. Starting Jersey");
        this.initParams.put(FrameworkConfig.WRITE_HEADERS, "false");
        ReflectorServletProcessor rsp = new ReflectorServletProcessor();
        if (broadcasterClassNameTmp != null) {
            this.broadcasterClassName = broadcasterClassNameTmp;
        }
        rsp.setServletClassName("com.sun.jersey.spi.container.servlet.ServletContainer");
        this.sessionSupport(false);
        this.initParams.put("org.atmosphere.disableOnStateEvent", "true");
        String mapping = sc.getInitParameter("org.atmosphere.jersey.servlet-mapping");
        if (mapping == null) {
            mapping = "/*";
        }
        Class<?> bc = cl.loadClass(this.broadcasterClassName);
        if (this.broadcasterFactory != null) {
            this.broadcasterFactory.destroy();
        }
        this.broadcasterFactory = new DefaultBroadcasterFactory(bc, this.broadcasterLifeCyclePolicy, this.config);
        BroadcasterFactory.setBroadcasterFactory(this.broadcasterFactory, this.config);
        for (BroadcasterListener b2 : this.broadcasterListeners) {
            this.broadcasterFactory.addBroadcasterListener(b2);
        }
        try {
            b = this.broadcasterFactory.get(bc, mapping);
        }
        catch (IllegalStateException ex) {
            logger.warn("Two Broadcaster's named {}. Renaming the second one to {}", (Object)mapping, (Object)(sc.getServletName() + mapping));
            b = this.broadcasterFactory.get(bc, sc.getServletName() + mapping);
        }
        this.addAtmosphereHandler(mapping, (AtmosphereHandler)rsp, b);
        return true;
    }

    protected String lookupDefaultBroadcasterType(String defaultB) {
        for (String b : this.broadcasterTypes) {
            try {
                Class.forName(b);
                return b;
            }
            catch (ClassNotFoundException e) {
            }
        }
        return defaultB;
    }

    protected void sessionSupport(boolean sessionSupport) {
        if (!this.isSessionSupportSpecified) {
            this.config.setSupportSession(sessionSupport);
        } else if (!this.config.isSupportSession()) {
            this.config.setSupportSession(sessionSupport);
        }
    }

    public void initAtmosphereHandler(ServletConfig sc) throws ServletException {
        for (Map.Entry<String, AtmosphereHandlerWrapper> h : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper w = h.getValue();
            AtmosphereHandler a = w.atmosphereHandler;
            if (!(a instanceof AtmosphereServletProcessor)) continue;
            ((AtmosphereServletProcessor)a).init(sc);
        }
        if (this.atmosphereHandlers.size() == 0 && !SimpleHttpProtocol.class.isAssignableFrom(this.webSocketProtocol.getClass())) {
            logger.debug("Adding a void AtmosphereHandler mapped to /* to allow WebSocket application only");
            this.addAtmosphereHandler("/*", new AbstractReflectorAtmosphereHandler(){

                @Override
                public void onRequest(AtmosphereResource r) throws IOException {
                    logger.debug("No AtmosphereHandler defined.");
                    if (!r.transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET)) {
                        r.getResponse().sendError(501, "X-Atmosphere-error");
                    }
                }

                @Override
                public void destroy() {
                }
            });
        }
    }

    protected void initWebSocket() {
        if (this.webSocketProtocol == null) {
            try {
                this.webSocketProtocol = (WebSocketProtocol)Thread.currentThread().getContextClassLoader().loadClass(this.webSocketProtocolClassName).newInstance();
                logger.info("Installed WebSocketProtocol {} ", (Object)this.webSocketProtocolClassName);
            }
            catch (Exception ex) {
                try {
                    this.webSocketProtocol = (WebSocketProtocol)AtmosphereFramework.class.getClassLoader().loadClass(this.webSocketProtocolClassName).newInstance();
                    logger.info("Installed WebSocketProtocol {} ", (Object)this.webSocketProtocolClassName);
                }
                catch (Exception ex2) {
                    logger.error("Cannot load the WebSocketProtocol {}", (Object)this.getWebSocketProtocolClassName(), (Object)ex);
                    this.webSocketProtocol = new SimpleHttpProtocol();
                }
            }
        }
        this.webSocketProtocol.configure(this.config);
    }

    public AtmosphereFramework destroy() {
        if (this.asyncSupport != null && AsynchronousProcessor.class.isAssignableFrom(this.asyncSupport.getClass())) {
            ((AsynchronousProcessor)this.asyncSupport).shutdown();
        }
        for (Map.Entry<String, AtmosphereHandlerWrapper> entry : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper handlerWrapper = entry.getValue();
            handlerWrapper.atmosphereHandler.destroy();
        }
        BroadcasterFactory factory = this.broadcasterFactory;
        if (factory != null) {
            factory.destroy();
            BroadcasterFactory.factory = null;
        }
        WebSocketProcessorFactory.getDefault().destroy();
        return this;
    }

    protected void loadAtmosphereDotXml(InputStream stream, URLClassLoader c) throws IOException, ServletException {
        if (stream == null) {
            return;
        }
        AtmosphereConfigReader.getInstance().parse(this.config, stream);
        for (AtmosphereHandlerConfig atmoHandler : this.config.getAtmosphereHandlerConfig()) {
            try {
                Object bc;
                AtmosphereHandler handler = !ReflectorServletProcessor.class.getName().equals(atmoHandler.getClassName()) ? (AtmosphereHandler)c.loadClass(atmoHandler.getClassName()).newInstance() : new ReflectorServletProcessor();
                logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)handler, (Object)atmoHandler.getContextRoot());
                for (ApplicationConfiguration applicationConfiguration : atmoHandler.getApplicationConfig()) {
                    this.initParams.put(applicationConfiguration.getParamName(), applicationConfiguration.getParamValue());
                }
                for (FrameworkConfiguration frameworkConfiguration : atmoHandler.getFrameworkConfig()) {
                    this.initParams.put(frameworkConfiguration.getParamName(), frameworkConfiguration.getParamValue());
                }
                for (AtmosphereHandlerProperty atmosphereHandlerProperty : atmoHandler.getProperties()) {
                    if (atmosphereHandlerProperty.getValue() != null && atmosphereHandlerProperty.getValue().indexOf("jersey") != -1) {
                        this.initParams.put("org.atmosphere.disableOnStateEvent", "true");
                        this.useStreamForFlushingComments = true;
                        this.broadcasterClassName = this.lookupDefaultBroadcasterType("org.atmosphere.jersey.JerseyBroadcaster");
                        this.broadcasterFactory.destroy();
                        this.broadcasterFactory = null;
                        this.configureBroadcasterFactory();
                        this.configureBroadcaster();
                    }
                    IntrospectionUtils.setProperty(handler, atmosphereHandlerProperty.getName(), atmosphereHandlerProperty.getValue());
                    IntrospectionUtils.addProperty(handler, atmosphereHandlerProperty.getName(), atmosphereHandlerProperty.getValue());
                }
                this.sessionSupport(Boolean.valueOf(atmoHandler.getSupportSession()));
                String broadcasterClass = atmoHandler.getBroadcaster();
                if (broadcasterClass != null) {
                    this.broadcasterClassName = broadcasterClass;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    bc = cl.loadClass(this.broadcasterClassName);
                    this.broadcasterFactory = new DefaultBroadcasterFactory((Class<? extends Broadcaster>)bc, this.broadcasterLifeCyclePolicy, this.config);
                    BroadcasterFactory.setBroadcasterFactory(this.broadcasterFactory, this.config);
                }
                Broadcaster broadcaster = this.broadcasterFactory.lookup(atmoHandler.getContextRoot(), true);
                AtmosphereHandlerWrapper wrapper = new AtmosphereHandlerWrapper(handler, broadcaster);
                this.addMapping(atmoHandler.getContextRoot(), wrapper);
                bc = atmoHandler.getBroadcasterCache();
                if (bc != null) {
                    this.broadcasterCacheClassName = bc;
                }
                if (atmoHandler.getCometSupport() != null) {
                    this.asyncSupport = (AsyncSupport)c.loadClass(atmoHandler.getCometSupport()).getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
                }
                if (atmoHandler.getBroadcastFilterClasses() != null) {
                    this.broadcasterFilters.addAll(atmoHandler.getBroadcastFilterClasses());
                }
                ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
                if (atmoHandler.getAtmosphereInterceptorClasses() != null) {
                    for (String a : atmoHandler.getAtmosphereInterceptorClasses()) {
                        try {
                            AtmosphereInterceptor ai = (AtmosphereInterceptor)c.loadClass(a).newInstance();
                            ai.configure(this.config);
                            l.add(ai);
                        }
                        catch (Throwable e) {
                            logger.warn("", e);
                        }
                    }
                }
                wrapper.interceptors = l;
                if (l.size() <= 0) continue;
                logger.info("Installed AtmosphereInterceptor {} mapped to AtmosphereHandler {}", l, (Object)atmoHandler.getClassName());
            }
            catch (Throwable t) {
                logger.warn("Unable to load AtmosphereHandler class: " + atmoHandler.getClassName(), t);
                throw new ServletException(t);
            }
        }
    }

    public AtmosphereFramework setAsyncSupport(AsyncSupport asyncSupport) {
        this.asyncSupport = asyncSupport;
        return this;
    }

    public AtmosphereFramework setCometSupport(AsyncSupport asyncSupport) {
        return this.setAsyncSupport(asyncSupport);
    }

    public AsyncSupport getAsyncSupport() {
        return this.asyncSupport;
    }

    public AsyncSupport getCometSupport() {
        return this.asyncSupport;
    }

    protected AsyncSupportResolver createAsyncSupportResolver() {
        return new DefaultAsyncSupportResolver(this.config);
    }

    protected void autoDetectContainer() {
        if (this.getAsyncSupport() == null) {
            this.setAsyncSupport(this.createAsyncSupportResolver().resolve(this.useNativeImplementation, this.useBlockingImplementation, this.webSocketEnabled));
        }
        logger.info("Atmosphere is using async support: {} running under container: {}", (Object)this.getAsyncSupport().getClass().getName(), (Object)this.asyncSupport.getContainerName());
    }

    public void autoDetectAtmosphereHandlers(ServletContext servletContext, URLClassLoader classloader) throws MalformedURLException, URISyntaxException {
        if (this.atmosphereHandlers.size() > 0) {
            return;
        }
        logger.info("Auto detecting atmosphere handlers {}", (Object)this.handlersPath);
        String realPath = servletContext.getRealPath(this.handlersPath);
        if (realPath == null) {
            URL u = servletContext.getResource(this.handlersPath);
            if (u == null) {
                return;
            }
            realPath = u.getPath();
        }
        this.loadAtmosphereHandlersFromPath(classloader, realPath);
    }

    public void loadAtmosphereHandlersFromPath(URLClassLoader classloader, String realPath) {
        File file = new File(realPath);
        if (file.isDirectory()) {
            this.getFiles(file);
            this.scanDone = true;
            for (String className : this.possibleComponentsCandidate) {
                try {
                    className = className.replace('\\', '/');
                    Class<?> clazz = classloader.loadClass(className = className.replaceFirst("^.*/(WEB-INF|target)(?:/scala-[^/]+)?/(test-)?classes/(.*)\\.class", "$3").replace("/", "."));
                    if (!AtmosphereHandler.class.isAssignableFrom(clazz)) continue;
                    AtmosphereHandler handler = (AtmosphereHandler)clazz.newInstance();
                    InjectorProvider.getInjector().inject(handler);
                    this.addMapping("/" + handler.getClass().getSimpleName(), new AtmosphereHandlerWrapper(this.broadcasterFactory, handler, "/" + handler.getClass().getSimpleName()));
                    logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)handler, (Object)handler.getClass().getName());
                }
                catch (Throwable t) {
                    logger.trace("failed to load class as an AtmosphereHandler: " + className, t);
                }
            }
        }
    }

    protected void autoDetectWebSocketHandler(ServletContext servletContext, URLClassLoader classloader) throws MalformedURLException, URISyntaxException {
        if (this.hasNewWebSocketProtocol) {
            return;
        }
        logger.info("Auto detecting WebSocketHandler in {}", (Object)this.handlersPath);
        String realPath = servletContext.getRealPath(this.handlersPath);
        if (realPath == null) {
            URL u = servletContext.getResource(this.handlersPath);
            if (u == null) {
                return;
            }
            realPath = u.getPath();
        }
        this.loadWebSocketFromPath(classloader, realPath);
    }

    protected void loadWebSocketFromPath(URLClassLoader classloader, String realPath) {
        File file = new File(realPath);
        if (file.isDirectory()) {
            this.getFiles(file);
            this.scanDone = true;
            for (String className : this.possibleComponentsCandidate) {
                try {
                    className = className.replace('\\', '/');
                    Class<?> clazz = classloader.loadClass(className = className.replaceFirst("^.*/(WEB-INF|target)(?:/scala-[^/]+)?/(test-)?classes/(.*)\\.class", "$3").replace("/", "."));
                    if (!WebSocketProtocol.class.isAssignableFrom(clazz)) continue;
                    this.webSocketProtocol = (WebSocketProtocol)clazz.newInstance();
                    InjectorProvider.getInjector().inject(this.webSocketProtocol);
                    logger.info("Installed WebSocketProtocol {}", (Object)this.webSocketProtocol);
                }
                catch (Throwable t) {
                    logger.trace("failed to load class as an WebSocketProtocol: " + className, t);
                }
            }
        }
    }

    private void getFiles(File f) {
        File[] files;
        if (this.scanDone) {
            return;
        }
        for (File test : files = f.listFiles()) {
            if (test.isDirectory()) {
                this.getFiles(test);
                continue;
            }
            String clazz = test.getAbsolutePath();
            if (!clazz.endsWith(".class")) continue;
            this.possibleComponentsCandidate.add(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action doCometSupport(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action a;
        block21: {
            req.setAttribute(ApplicationConfig.BROADCASTER_FACTORY, this.broadcasterFactory);
            req.setAttribute("org.atmosphere.useStream", this.useStreamForFlushingComments);
            req.setAttribute(ApplicationConfig.BROADCASTER_CLASS, this.broadcasterClassName);
            req.setAttribute(FrameworkConfig.ATMOSPHERE_CONFIG, this.config);
            a = null;
            try {
                String unique;
                boolean skip = true;
                String s = this.config.getInitParameter(ApplicationConfig.ALLOW_QUERYSTRING_AS_REQUEST);
                if (s != null) {
                    skip = Boolean.valueOf(s);
                }
                if (!skip || req.getAttribute(WebSocket.WEBSOCKET_SUSPEND) == null) {
                    Map<String, String> headers = this.configureQueryStringAsRequest(req);
                    String body = headers.remove("X-Atmosphere-Post-Body");
                    if (body != null && body.isEmpty()) {
                        body = null;
                    }
                    req.headers(headers).method(body != null && req.getMethod().equalsIgnoreCase("GET") ? "POST" : req.getMethod());
                    if (body != null) {
                        req.body(body);
                    }
                }
                if (((s = req.getHeader("X-Atmosphere-tracking-id")) == null || s.equals("0")) && (unique = this.config.getInitParameter(ApplicationConfig.UNIQUE_UUID_WEBSOCKET)) != null && Boolean.valueOf(unique).booleanValue()) {
                    s = (String)req.getAttribute(ApplicationConfig.SUSPENDED_ATMOSPHERE_RESOURCE_UUID);
                }
                if (s == null || s.equals("0")) {
                    s = UUID.randomUUID().toString();
                    res.setHeader("X-Atmosphere-tracking-id", s);
                } else if (req.resource() == null) {
                    res.setHeader("X-Atmosphere-tracking-id", s);
                } else if (req.getAttribute(WebSocket.WEBSOCKET_INITIATED) == null) {
                    res.setHeader("X-Atmosphere-tracking-id", s);
                }
                if (req.getAttribute(ApplicationConfig.SUSPENDED_ATMOSPHERE_RESOURCE_UUID) == null) {
                    req.setAttribute(ApplicationConfig.SUSPENDED_ATMOSPHERE_RESOURCE_UUID, s);
                }
                a = this.asyncSupport.service(req, res);
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage() != null && (ex.getMessage().startsWith("Tomcat failed") || ex.getMessage().startsWith("JBoss failed"))) {
                    if (!this.isFilter) {
                        logger.warn("Failed using comet support: {}, error: {} Is the Nio or Apr Connector enabled?", (Object)this.asyncSupport.getClass().getName(), (Object)ex.getMessage());
                    }
                    logger.trace(ex.getMessage(), (Throwable)ex);
                    AsyncSupport current = this.asyncSupport;
                    AsyncSupport<AtmosphereResourceImpl> asyncSupport = this.asyncSupport = this.asyncSupport.supportWebSocket() ? new Tomcat7BIOSupportWithWebSocket(this.config) : new BlockingIOCometSupport(this.config);
                    if (current instanceof AsynchronousProcessor) {
                        ((AsynchronousProcessor)current).shutdown();
                    }
                    this.asyncSupport.init(this.config.getServletConfig());
                    logger.warn("Using " + this.asyncSupport.getClass().getName());
                    a = this.asyncSupport.service(req, res);
                    break block21;
                }
                logger.error("AtmosphereFramework exception", (Throwable)ex);
                throw ex;
            }
            finally {
                if (a != null) {
                    this.notify(a.type(), req, res);
                }
                if (req != null && a != null && a.type() != Action.TYPE.SUSPEND) {
                    req.destroy();
                    res.destroy();
                    this.notify(Action.TYPE.DESTROYED, req, res);
                }
            }
        }
        return a;
    }

    public String getDefaultBroadcasterClassName() {
        return this.broadcasterClassName;
    }

    public AtmosphereFramework setDefaultBroadcasterClassName(String bccn) {
        this.broadcasterClassName = bccn;
        this.broadcasterFactory = null;
        this.configureBroadcasterFactory();
        for (AtmosphereHandlerWrapper w : this.atmosphereHandlers.values()) {
            w.broadcaster = this.broadcasterFactory.lookup(w.broadcaster.getID(), true);
        }
        return this;
    }

    public boolean isUseStreamForFlushingComments() {
        return this.useStreamForFlushingComments;
    }

    public AtmosphereFramework setUseStreamForFlushingComments(boolean useStreamForFlushingComments) {
        this.useStreamForFlushingComments = useStreamForFlushingComments;
        return this;
    }

    public BroadcasterFactory getBroadcasterFactory() {
        return this.broadcasterFactory;
    }

    public AtmosphereFramework setBroadcasterFactory(BroadcasterFactory broadcasterFactory) {
        this.broadcasterFactory = broadcasterFactory;
        this.configureBroadcaster();
        return this;
    }

    public String getBroadcasterCacheClassName() {
        return this.broadcasterCacheClassName;
    }

    public void setBroadcasterCacheClassName(String broadcasterCacheClassName) {
        this.broadcasterCacheClassName = broadcasterCacheClassName;
        this.configureBroadcaster();
    }

    public AtmosphereFramework addBroadcasterType(String broadcasterTypeString) {
        this.broadcasterTypes.add(broadcasterTypeString);
        return this;
    }

    public String getWebSocketProtocolClassName() {
        return this.webSocketProtocolClassName;
    }

    public AtmosphereFramework setWebSocketProtocolClassName(String webSocketProtocolClassName) {
        this.hasNewWebSocketProtocol = true;
        this.webSocketProtocolClassName = webSocketProtocolClassName;
        return this;
    }

    public Map<String, AtmosphereHandlerWrapper> getAtmosphereHandlers() {
        return this.atmosphereHandlers;
    }

    protected Map<String, String> configureQueryStringAsRequest(AtmosphereRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration<String> e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            if (s.equalsIgnoreCase("Content-Type") && (request.getContentType() == null || !request.getContentType().equalsIgnoreCase(request.getParameter(s)))) {
                request.contentType(request.getParameter(s));
            }
            headers.put(s, request.getParameter(s));
        }
        logger.trace("Query String translated to headers {}", headers);
        return headers;
    }

    protected boolean isIECandidate(AtmosphereRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            return false;
        }
        if (userAgent.contains("MSIE") || userAgent.contains(".NET")) {
            String transport = request.getHeader("X-Atmosphere-Transport");
            return transport == null;
        }
        return false;
    }

    public WebSocketProtocol getWebSocketProtocol() {
        this.initWebSocket();
        return this.webSocketProtocol;
    }

    public boolean isUseNativeImplementation() {
        return this.useNativeImplementation;
    }

    public AtmosphereFramework setUseNativeImplementation(boolean useNativeImplementation) {
        this.useNativeImplementation = useNativeImplementation;
        return this;
    }

    public boolean isUseBlockingImplementation() {
        return this.useBlockingImplementation;
    }

    public AtmosphereFramework setUseBlockingImplementation(boolean useBlockingImplementation) {
        this.useBlockingImplementation = useBlockingImplementation;
        return this;
    }

    public String getAtmosphereDotXmlPath() {
        return this.atmosphereDotXmlPath;
    }

    public AtmosphereFramework setAtmosphereDotXmlPath(String atmosphereDotXmlPath) {
        this.atmosphereDotXmlPath = atmosphereDotXmlPath;
        return this;
    }

    public String getHandlersPath() {
        return this.handlersPath;
    }

    public AtmosphereFramework setHandlersPath(String handlersPath) {
        this.handlersPath = handlersPath;
        return this;
    }

    public String getLibPath() {
        return this.libPath;
    }

    public AtmosphereFramework setLibPath(String libPath) {
        this.libPath = libPath;
        return this;
    }

    public String getWebSocketProcessorClassName() {
        return this.webSocketProcessorClassName;
    }

    public AtmosphereFramework setWebsocketProcessorClassName(String webSocketProcessorClassName) {
        this.webSocketProcessorClassName = webSocketProcessorClassName;
        return this;
    }

    public AtmosphereFramework interceptor(AtmosphereInterceptor c) {
        boolean found = false;
        for (AtmosphereInterceptor interceptor : this.interceptors) {
            if (!interceptor.getClass().equals(c.getClass())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.interceptors.addLast(c);
            logger.info("Installed AtmosphereInterceptor {}. ", (Object)c);
        }
        return this;
    }

    public LinkedList<AtmosphereInterceptor> interceptors() {
        return this.interceptors;
    }

    public AtmosphereFramework annotationProcessorClassName(String annotationProcessorClassName) {
        this.annotationProcessorClassName = annotationProcessorClassName;
        return this;
    }

    public AtmosphereFramework asyncSupportListener(AsyncSupportListener asyncSupportListener) {
        this.asyncSupportListeners.add(asyncSupportListener);
        return this;
    }

    public List<AsyncSupportListener> asyncSupportListeners() {
        return this.asyncSupportListeners;
    }

    public AtmosphereFramework addBroadcasterListener(BroadcasterListener b) {
        this.broadcasterFactory.addBroadcasterListener(b);
        this.broadcasterListeners.add(b);
        return this;
    }

    public AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletConfig.getServletContext();
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public List<String> broadcasterFilters() {
        return this.broadcasterFilters;
    }

    public boolean isShareExecutorServices() {
        return this.sharedThreadPools;
    }

    public AtmosphereFramework shareExecutorServices(boolean sharedThreadPools) {
        this.sharedThreadPools = sharedThreadPools;
        return this;
    }

    protected void autoConfigureService(ServletContext sc) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String path = this.libPath != DEFAULT_LIB_PATH ? this.libPath : sc.getRealPath(this.handlersPath);
        try {
            AnnotationProcessor p = (AnnotationProcessor)cl.loadClass(this.annotationProcessorClassName).newInstance();
            logger.info("Atmosphere is using {} for processing annotation", (Object)this.annotationProcessorClassName);
            p.configure(this);
            if (this.packages.size() > 0) {
                for (String s : this.packages) {
                    p.scan(s);
                }
            } else {
                String pathLibs;
                if (path != null) {
                    p.scan(new File(path));
                }
                if ((pathLibs = sc.getRealPath(DEFAULT_LIB_PATH)) != null) {
                    File[] jars;
                    File libFolder = new File(pathLibs);
                    for (File file : jars = libFolder.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File arg0, String arg1) {
                            return arg1.endsWith(".jar");
                        }
                    })) {
                        p.scan(file);
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.debug("Atmosphere's Service Annotation Not Supported. Please add https://github.com/rmuller/infomas-asl as dependencies or your own AnnotationProcessor to support @Service");
            logger.trace("", e);
            return;
        }
    }

    public AtmosphereFramework addAnnotationPackage(Class<?> clazz) {
        this.packages.add(clazz.getPackage().getName());
        return this;
    }

    protected void notify(Action.TYPE type, AtmosphereRequest request, AtmosphereResponse response) {
        for (AsyncSupportListener l : this.asyncSupportListeners()) {
            try {
                switch (type) {
                    case TIMEOUT: {
                        l.onTimeout(request, response);
                        break;
                    }
                    case CANCELLED: {
                        l.onClose(request, response);
                        break;
                    }
                    case SUSPEND: {
                        l.onSuspend(request, response);
                        break;
                    }
                    case RESUME: {
                        l.onResume(request, response);
                        break;
                    }
                    case DESTROYED: {
                        l.onDestroyed(request, response);
                    }
                }
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
    }

    public static final class AtmosphereHandlerWrapper {
        public final AtmosphereHandler atmosphereHandler;
        public Broadcaster broadcaster;
        public String mapping;
        public List<AtmosphereInterceptor> interceptors = Collections.emptyList();

        public AtmosphereHandlerWrapper(BroadcasterFactory broadcasterFactory, AtmosphereHandler atmosphereHandler, String mapping) {
            this.atmosphereHandler = atmosphereHandler;
            try {
                if (broadcasterFactory != null) {
                    this.broadcaster = broadcasterFactory.lookup(mapping, true);
                } else {
                    this.mapping = mapping;
                }
            }
            catch (Exception t) {
                throw new RuntimeException(t);
            }
        }

        public AtmosphereHandlerWrapper(AtmosphereHandler atmosphereHandler, Broadcaster broadcaster) {
            this.atmosphereHandler = atmosphereHandler;
            this.broadcaster = broadcaster;
        }

        public String toString() {
            return "AtmosphereHandlerWrapper{ atmosphereHandler=" + this.atmosphereHandler + ", broadcaster=" + this.broadcaster + " }";
        }
    }
}

