/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.util.ArrayList;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.managed.MeteorServiceInterceptor;
import org.atmosphere.config.service.MeteorService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(value=MeteorService.class)
public class MeteorServiceProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(MeteorServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<?> annotatedClass) {
        try {
            Class<? extends AtmosphereInterceptor>[] interceptors;
            ReflectorServletProcessor r = new ReflectorServletProcessor();
            r.setServletClassName(annotatedClass.getName());
            ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
            Class<?> s = annotatedClass;
            MeteorService m = s.getAnnotation(MeteorService.class);
            String mapping = m.path();
            AnnotationUtil.atmosphereConfig(m.atmosphereConfig(), framework);
            AnnotationUtil.filters(m.broadcastFilters(), framework);
            AtmosphereInterceptor aa = AnnotationUtil.listeners(m.listeners(), framework);
            if (aa != null) {
                l.add(aa);
            }
            for (Class<? extends AtmosphereInterceptor> i : interceptors = m.interceptors()) {
                try {
                    AtmosphereInterceptor ai = framework.newClassInstance(i);
                    l.add(ai);
                }
                catch (Throwable e) {
                    logger.warn("", e);
                }
            }
            if (m.path().contains("{")) {
                framework.interceptors().add(new MeteorServiceInterceptor());
            }
            framework.addAtmosphereHandler(mapping, (AtmosphereHandler)r, AnnotationUtil.broadcaster(framework, m.broadcaster(), m.path()), l);
            framework.setBroadcasterCacheClassName(m.broadcasterCache().getName());
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

