/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.container.Grizzly2CometSupport;
import org.atmosphere.container.version.Grizzly2WebSocket;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.util.Utils;
import org.atmosphere.websocket.WebSocketProcessor;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grizzly2WebSocketSupport
extends Grizzly2CometSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(Grizzly2WebSocketSupport.class);
    private Grizzly2WebSocketApplication application;

    public Grizzly2WebSocketSupport(AtmosphereConfig config) {
        super(config);
        this.application = new Grizzly2WebSocketApplication(config);
        WebSocketEngine.getEngine().register((WebSocketApplication)this.application);
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        if (Utils.webSocketEnabled((HttpServletRequest)req)) {
            return this.suspended(req, res);
        }
        return super.service(req, res);
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    @Override
    public void shutdown() {
        WebSocketEngine.getEngine().unregister((WebSocketApplication)this.application);
        super.shutdown();
    }

    private static final class Grizzly2WebSocketApplication
    extends WebSocketApplication {
        private AtmosphereConfig config;
        private final String contextPath;
        private final WebSocketProcessor webSocketProcessor;

        public Grizzly2WebSocketApplication(AtmosphereConfig config) {
            this.config = config;
            this.contextPath = config.getServletContext().getContextPath();
            this.webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(config.framework());
        }

        protected void handshake(HandShake handshake) throws HandshakeException {
            if (!this.webSocketProcessor.handshake(null)) {
                throw new HandshakeException("WebSocket not accepted");
            }
        }

        public boolean isApplicationRequest(HttpRequestPacket request) {
            return request.getRequestURI().startsWith(this.contextPath);
        }

        public void onClose(WebSocket socket, DataFrame frame) {
            super.onClose(socket, frame);
            LOGGER.trace("onClose {} ", (Object)socket);
            DefaultWebSocket g2w = (DefaultWebSocket)DefaultWebSocket.class.cast(socket);
            org.atmosphere.websocket.WebSocket webSocket = (org.atmosphere.websocket.WebSocket)g2w.getUpgradeRequest().getAttribute("grizzly.webSocket");
            if (webSocket != null) {
                this.webSocketProcessor.close(webSocket, 1000);
            }
        }

        public void onConnect(WebSocket socket) {
            super.onConnect(socket);
            LOGGER.trace("onConnect {} ", (Object)socket);
            if (!DefaultWebSocket.class.isAssignableFrom(socket.getClass())) {
                throw new IllegalStateException();
            }
            DefaultWebSocket g2WebSocket = (DefaultWebSocket)DefaultWebSocket.class.cast(socket);
            try {
                AtmosphereRequest r = AtmosphereRequest.wrap(g2WebSocket.getUpgradeRequest());
                Grizzly2WebSocket webSocket = new Grizzly2WebSocket((WebSocket)g2WebSocket, this.config);
                g2WebSocket.getUpgradeRequest().setAttribute("grizzly.webSocket", (Object)webSocket);
                this.webSocketProcessor.open(webSocket, r, AtmosphereResponse.newInstance(this.config, r, webSocket));
            }
            catch (Exception e) {
                LOGGER.warn("failed to connect to web socket", (Throwable)e);
            }
        }

        public void onMessage(WebSocket socket, String text) {
            super.onMessage(socket, text);
            LOGGER.trace("onMessage(String) {} ", (Object)socket);
            DefaultWebSocket g2w = (DefaultWebSocket)DefaultWebSocket.class.cast(socket);
            org.atmosphere.websocket.WebSocket webSocket = (org.atmosphere.websocket.WebSocket)g2w.getUpgradeRequest().getAttribute("grizzly.webSocket");
            if (webSocket != null) {
                this.webSocketProcessor.invokeWebSocketProtocol(webSocket, text);
            }
        }

        public void onMessage(WebSocket socket, byte[] bytes) {
            super.onMessage(socket, bytes);
            LOGGER.trace("onMessage(byte[]) {} ", (Object)socket);
            DefaultWebSocket g2w = (DefaultWebSocket)DefaultWebSocket.class.cast(socket);
            org.atmosphere.websocket.WebSocket webSocket = (org.atmosphere.websocket.WebSocket)g2w.getUpgradeRequest().getAttribute("grizzly.webSocket");
            if (webSocket != null) {
                this.webSocketProcessor.invokeWebSocketProtocol(webSocket, bytes, 0, bytes.length);
            }
        }

        public void onPing(WebSocket socket, byte[] bytes) {
            LOGGER.trace("onPing {} ", (Object)socket);
        }

        public void onPong(WebSocket socket, byte[] bytes) {
            LOGGER.trace("onPong {} ", (Object)socket);
        }

        public void onFragment(WebSocket socket, String fragment, boolean last) {
            LOGGER.trace("onFragment(String) {} ", (Object)socket);
        }

        public void onFragment(WebSocket socket, byte[] fragment, boolean last) {
            LOGGER.trace("onFragment(byte) {} ", (Object)socket);
        }
    }
}

