/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.util.Arrays;
import java.util.LinkedList;
import javax.servlet.Servlet;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.managed.MeteorServiceInterceptor;
import org.atmosphere.config.service.MeteorService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(value=MeteorService.class)
public class MeteorServiceProcessor
implements Processor<Servlet> {
    private static final Logger logger = LoggerFactory.getLogger(MeteorServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<Servlet> annotatedClass) {
        try {
            ReflectorServletProcessor r = framework.newClassInstance(ReflectorServletProcessor.class, ReflectorServletProcessor.class);
            r.setServletClassName(annotatedClass.getName());
            LinkedList<AtmosphereInterceptor> l = new LinkedList<AtmosphereInterceptor>();
            MeteorService m = annotatedClass.getAnnotation(MeteorService.class);
            framework.setBroadcasterCacheClassName(m.broadcasterCache().getName());
            String mapping = m.path();
            AnnotationUtil.atmosphereConfig(m.atmosphereConfig(), framework);
            AnnotationUtil.filters(m.broadcastFilters(), framework);
            AtmosphereInterceptor aa = AnnotationUtil.listeners(m.listeners(), framework);
            if (aa != null) {
                l.add(aa);
            }
            AnnotationUtil.interceptors(framework, Arrays.asList(m.interceptors()), l);
            if (m.path().contains("{")) {
                l.addFirst(framework.newClassInstance(AtmosphereInterceptor.class, MeteorServiceInterceptor.class));
            }
            framework.addAtmosphereHandler(mapping, (AtmosphereHandler)r, AnnotationUtil.broadcaster(framework, m.broadcaster(), m.path()), l);
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

