/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.config.service.Singleton;
import org.atmosphere.config.service.WebSocketHandlerService;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereMappingException;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.util.DefaultEndpointMapper;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.Utils;
import org.atmosphere.util.VoidExecutorService;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketHandler;
import org.atmosphere.websocket.WebSocketPingPongListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.atmosphere.websocket.WebSocketProtocolStream;
import org.atmosphere.websocket.WebSocketStreamingHandler;
import org.atmosphere.websocket.protocol.StreamingHttpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebSocketProcessor
implements WebSocketProcessor,
Serializable,
WebSocketPingPongListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWebSocketProcessor.class);
    private AtmosphereFramework framework;
    private WebSocketProtocol webSocketProtocol;
    private boolean destroyable;
    private boolean executeAsync;
    private ExecutorService asyncExecutor;
    private ScheduledExecutorService scheduler;
    private final Map<String, WebSocketProcessor.WebSocketHandlerProxy> handlers = new ConcurrentHashMap<String, WebSocketProcessor.WebSocketHandlerProxy>();
    private final EndpointMapper<WebSocketProcessor.WebSocketHandlerProxy> mapper = new DefaultEndpointMapper<WebSocketProcessor.WebSocketHandlerProxy>();
    private boolean wildcardMapping = false;
    private int byteBufferMaxSize = 0x200000;
    private int charBufferMaxSize = 0x200000;
    private long closingTime;
    private AsynchronousProcessor asynchronousProcessor;
    private boolean invokeInterceptors;

    @Override
    public WebSocketProcessor configure(AtmosphereConfig config) {
        this.framework = config.framework();
        this.webSocketProtocol = this.framework.getWebSocketProtocol();
        String s = this.framework.getAtmosphereConfig().getInitParameter("org.atmosphere.cpr.recycleAtmosphereRequestResponse");
        this.destroyable = s != null && Boolean.valueOf(s) != false;
        s = this.framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.WebSocketProtocol.executeAsync");
        this.executeAsync = s != null && Boolean.valueOf(s) != false;
        s = this.framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.webSocketBufferingMaxSize");
        if (s != null) {
            this.charBufferMaxSize = this.byteBufferMaxSize = Integer.valueOf(s).intValue();
        }
        this.asyncExecutor = this.executeAsync ? ExecutorsFactory.getAsyncOperationExecutor(config, "WebSocket") : VoidExecutorService.VOID;
        this.scheduler = ExecutorsFactory.getScheduler(config);
        this.optimizeMapping();
        this.closingTime = Long.valueOf(config.getInitParameter("org.atmosphere.cpr.delayClosingTime", "0"));
        this.invokeInterceptors = Boolean.valueOf(config.getInitParameter("org.atmosphere.websocket.DefaultWebSocketProcessor.invokeInterceptorsOnMessage", "true"));
        config.startupHook(new AtmosphereConfig.StartupHook(){

            @Override
            public void started(final AtmosphereFramework framework) {
                if (AsynchronousProcessor.class.isAssignableFrom(framework.getAsyncSupport().getClass())) {
                    DefaultWebSocketProcessor.this.asynchronousProcessor = (AsynchronousProcessor)AsynchronousProcessor.class.cast(framework.getAsyncSupport());
                } else {
                    DefaultWebSocketProcessor.this.asynchronousProcessor = new AsynchronousProcessor(framework.getAtmosphereConfig()){

                        @Override
                        public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
                            return framework.getAsyncSupport().service(req, res);
                        }
                    };
                }
            }
        });
        return this;
    }

    @Override
    public boolean handshake(HttpServletRequest request) {
        if (request != null) {
            logger.trace("Processing request {}", (Object)request);
        }
        return true;
    }

    @Override
    public WebSocketProcessor registerWebSocketHandler(String path, WebSocketProcessor.WebSocketHandlerProxy webSockethandler) {
        this.handlers.put(path, webSockethandler.path(path));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void open(final WebSocket webSocket, AtmosphereRequest request, AtmosphereResponse response) throws IOException {
        if (this.framework.isDestroyed()) {
            return;
        }
        if (this.framework.getAtmosphereConfig().handlers().size() == 0) {
            AtmosphereFramework atmosphereFramework = this.framework;
            synchronized (atmosphereFramework) {
                if (this.handlers.size() == 0) {
                    logger.warn("No AtmosphereHandler or WebSocketHandler installed. Adding a default one.");
                }
                this.framework.addAtmosphereHandler("/*", AtmosphereFramework.REFLECTOR_ATMOSPHEREHANDLER);
            }
        }
        request.headers(DefaultWebSocketProcessor.configureHeader(request)).setAttribute(WebSocket.WEBSOCKET_SUSPEND, true);
        AtmosphereResource r = this.framework.atmosphereFactory().create(this.framework.getAtmosphereConfig(), response, this.framework.getAsyncSupport());
        boolean cleanUpAfterDisconnect = false;
        try {
            request.setAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE, r);
            request.setAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid", r.uuid());
            if (Utils.firefoxWebSocketEnabled((HttpServletRequest)request)) {
                request.setAttribute("firefox", "true");
            }
            ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).webSocket(webSocket);
            webSocket.resource(r);
            this.webSocketProtocol.onOpen(webSocket);
            WebSocketHandler proxy = null;
            if (this.handlers.size() != 0) {
                WebSocketProcessor.WebSocketHandlerProxy handler = this.mapper.map(request, this.handlers);
                if (handler == null) {
                    logger.debug("No WebSocketHandler maps request for {} with mapping {}", (Object)request.getRequestURI(), this.handlers);
                    throw new AtmosphereMappingException("No AtmosphereHandler maps request for " + request.getRequestURI());
                }
                proxy = this.postProcessMapping(webSocket, request, handler);
            }
            this.dispatch(webSocket, request, response);
            if (proxy != null) {
                webSocket.webSocketHandler(proxy).resource().suspend(-1L);
                proxy.onOpen(webSocket);
            }
            request.removeAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE);
            if (webSocket.resource() != null) {
                final Action action = ((AtmosphereResourceImpl)webSocket.resource()).action();
                if (action.timeout() != -1L && !this.framework.getAsyncSupport().getContainerName().contains("Netty")) {
                    final AtomicReference f = new AtomicReference();
                    f.set(this.scheduler.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            if (WebSocket.class.isAssignableFrom(webSocket.getClass()) && System.currentTimeMillis() - ((WebSocket)WebSocket.class.cast(webSocket)).lastWriteTimeStampInMilliseconds() > action.timeout()) {
                                DefaultWebSocketProcessor.this.asynchronousProcessor.endRequest((AtmosphereResourceImpl)webSocket.resource(), false);
                                ((Future)f.get()).cancel(true);
                            }
                        }
                    }, action.timeout(), action.timeout(), TimeUnit.MILLISECONDS));
                }
            } else {
                logger.warn("AtmosphereResource was null");
                cleanUpAfterDisconnect = true;
            }
            this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<String>("", WebSocketEventListener.WebSocketEvent.TYPE.CONNECT, webSocket));
        }
        catch (AtmosphereMappingException ex) {
            cleanUpAfterDisconnect = true;
            throw ex;
        }
        catch (IOException ex) {
            cleanUpAfterDisconnect = true;
            throw ex;
        }
        catch (Exception ex) {
            logger.trace("onOpen exception", (Throwable)ex);
            cleanUpAfterDisconnect = true;
        }
        finally {
            if (cleanUpAfterDisconnect) {
                logger.warn("Problem opening websocket for {}", (Object)r.uuid());
                this.framework.atmosphereFactory().remove(r.uuid());
                ((AtmosphereResourceEventImpl)AtmosphereResourceEventImpl.class.cast(r.getAtmosphereResourceEvent())).setCancelled(true);
                ((AsynchronousProcessor)AsynchronousProcessor.class.cast(this.framework.getAsyncSupport())).completeLifecycle(r, true);
            }
            webSocket.shiftAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebSocketHandler postProcessMapping(WebSocket webSocket, AtmosphereRequest request, WebSocketProcessor.WebSocketHandlerProxy w) {
        WebSocketProcessor.WebSocketHandlerProxy p = null;
        String path = w.path();
        if (this.wildcardMapping()) {
            String pathInfo = null;
            try {
                pathInfo = request.getPathInfo();
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
            path = pathInfo != null ? request.getServletPath() + pathInfo : request.getServletPath();
            if (path == null || path.isEmpty()) {
                path = "/";
            }
            Map<String, WebSocketProcessor.WebSocketHandlerProxy> map = this.handlers;
            synchronized (map) {
                String targetPath;
                WebSocketHandlerService a;
                p = this.handlers.get(path);
                if (p == null && (a = w.proxied.getClass().getAnnotation(WebSocketHandlerService.class)) != null && (targetPath = a.path()).indexOf("{") != -1 && targetPath.indexOf("}") != -1) {
                    try {
                        boolean singleton;
                        boolean bl = singleton = w.proxied.getClass().getAnnotation(Singleton.class) != null;
                        if (!singleton) {
                            this.registerWebSocketHandler(path, new WebSocketProcessor.WebSocketHandlerProxy(a.broadcaster(), this.framework.newClassInstance(WebSocketHandler.class, w.proxied.getClass())));
                        } else {
                            this.registerWebSocketHandler(path, new WebSocketProcessor.WebSocketHandlerProxy(a.broadcaster(), w));
                        }
                        p = this.handlers.get(path);
                    }
                    catch (Throwable e) {
                        logger.warn("Unable to create WebSocketHandler", e);
                    }
                }
            }
        }
        try {
            webSocket.resource().setBroadcaster(AnnotationUtil.broadcaster(this.framework, p != null ? p.broadcasterClazz : w.broadcasterClazz, path));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return p != null ? p : w;
    }

    private void dispatch(final WebSocket webSocket, List<AtmosphereRequest> list) {
        if (list == null) {
            return;
        }
        for (final AtmosphereRequest r : list) {
            if (r == null) continue;
            this.asyncExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtmosphereResponse w = new AtmosphereResponse(webSocket, r, DefaultWebSocketProcessor.this.destroyable);
                    try {
                        DefaultWebSocketProcessor.this.dispatch(webSocket, r, w);
                    }
                    finally {
                        r.destroy();
                        w.destroy();
                    }
                }
            });
        }
    }

    private WebSocketProcessor.WebSocketHandlerProxy webSocketHandlerForMessage(WebSocket webSocket) {
        AtmosphereResourceImpl impl = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(webSocket.resource());
        if (impl != null) {
            impl.getRequest(false).setAttribute(FrameworkConfig.WEBSOCKET_MESSAGE, "true");
        }
        return (WebSocketProcessor.WebSocketHandlerProxy)WebSocketProcessor.WebSocketHandlerProxy.class.cast(webSocket.webSocketHandler());
    }

    private void invokeInterceptors(WebSocketProcessor.WebSocketHandlerProxy webSocketHandler, WebSocket webSocket, Object webSocketMessageAsBody) throws IOException {
        this.invokeInterceptors(webSocketHandler, webSocket, webSocketMessageAsBody, 0, 0);
    }

    private void invokeInterceptors(WebSocketProcessor.WebSocketHandlerProxy webSocketHandler, WebSocket webSocket, Object webSocketMessageAsBody, int offset, int length) throws IOException {
        AtmosphereResourceImpl resource = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(webSocket.resource());
        if (resource == null) {
            return;
        }
        AtmosphereRequest request = resource.getRequest(false);
        if (String.class.isAssignableFrom(webSocketMessageAsBody.getClass())) {
            request.body((String)String.class.cast(webSocketMessageAsBody));
        } else if (Reader.class.isAssignableFrom(webSocketMessageAsBody.getClass())) {
            request.body((Reader)Reader.class.cast(webSocketMessageAsBody));
        } else if (InputStream.class.isAssignableFrom(webSocketMessageAsBody.getClass())) {
            request.body((InputStream)InputStream.class.cast(webSocketMessageAsBody));
        } else {
            request.body(new ByteArrayInputStream((byte[])webSocketMessageAsBody, offset, length));
        }
        int tracing = 0;
        Action a = this.asynchronousProcessor.invokeInterceptors(this.framework.interceptors(), resource, tracing);
        if (a.type() != Action.TYPE.CONTINUE && a.type() != Action.TYPE.SKIP_ATMOSPHEREHANDLER) {
            return;
        }
        boolean skipAtmosphereHandler = request.getAttribute(Action.TYPE.SKIP_ATMOSPHEREHANDLER.name()) != null ? (Boolean)request.getAttribute(Action.TYPE.SKIP_ATMOSPHEREHANDLER.name()) : Boolean.FALSE;
        if (!skipAtmosphereHandler) {
            try {
                if (String.class.isAssignableFrom(webSocketMessageAsBody.getClass())) {
                    webSocketHandler.onTextMessage(webSocket, (String)String.class.cast(webSocketMessageAsBody));
                } else if (Reader.class.isAssignableFrom(webSocketMessageAsBody.getClass())) {
                    ((WebSocketStreamingHandler)WebSocketStreamingHandler.class.cast(webSocketHandler.proxied)).onTextStream(webSocket, (Reader)Reader.class.cast(webSocketMessageAsBody));
                } else if (InputStream.class.isAssignableFrom(webSocketMessageAsBody.getClass())) {
                    ((WebSocketStreamingHandler)WebSocketStreamingHandler.class.cast(webSocketHandler.proxied())).onBinaryStream(webSocket, (InputStream)InputStream.class.cast(webSocketMessageAsBody));
                } else {
                    webSocketHandler.onByteMessage(webSocket, (byte[])webSocketMessageAsBody, offset, length);
                }
            }
            catch (IOException t) {
                resource.onThrowable(t);
                throw t;
            }
        }
        request.setAttribute(Action.TYPE.SKIP_ATMOSPHEREHANDLER.name(), Boolean.FALSE);
        this.asynchronousProcessor.postInterceptors(this.framework.interceptors(), resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invokeWebSocketProtocol(WebSocket webSocket, String webSocketMessage) {
        block7: {
            WebSocketProcessor.WebSocketHandlerProxy webSocketHandler = this.webSocketHandlerForMessage(webSocket);
            if (webSocketHandler == null) {
                if (WebSocketProtocolStream.class.isAssignableFrom(this.webSocketProtocol.getClass())) {
                    logger.debug("The WebServer doesn't support streaming. Wrapping the message as stream.");
                    this.invokeWebSocketProtocol(webSocket, new StringReader(webSocketMessage));
                    return;
                }
                List<AtmosphereRequest> list = this.webSocketProtocol.onMessage(webSocket, webSocketMessage);
                this.dispatch(webSocket, list);
            } else {
                if (WebSocketStreamingHandler.class.isAssignableFrom(webSocketHandler.proxied().getClass())) {
                    logger.debug("The WebServer doesn't support streaming. Wrapping the message as stream.");
                    this.invokeWebSocketProtocol(webSocket, new StringReader(webSocketMessage));
                    return;
                }
                try {
                    if (this.invokeInterceptors) {
                        this.invokeInterceptors(webSocketHandler, webSocket, webSocketMessage);
                        break block7;
                    }
                    webSocketHandler.onTextMessage(webSocket, webSocketMessage);
                }
                catch (Exception ex) {
                    this.handleException(ex, webSocket, webSocketHandler);
                }
            }
        }
        this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<String>(webSocketMessage, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, webSocket));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invokeWebSocketProtocol(WebSocket webSocket, byte[] data, int offset, int length) {
        block7: {
            WebSocketProcessor.WebSocketHandlerProxy webSocketHandler = this.webSocketHandlerForMessage(webSocket);
            if (webSocketHandler == null) {
                if (WebSocketProtocolStream.class.isAssignableFrom(this.webSocketProtocol.getClass())) {
                    logger.debug("The WebServer doesn't support streaming. Wrapping the message as stream.");
                    this.invokeWebSocketProtocol(webSocket, new ByteArrayInputStream(data, offset, length));
                    return;
                }
                List<AtmosphereRequest> list = this.webSocketProtocol.onMessage(webSocket, data, offset, length);
                this.dispatch(webSocket, list);
            } else {
                if (WebSocketStreamingHandler.class.isAssignableFrom(webSocketHandler.proxied().getClass())) {
                    logger.debug("The WebServer doesn't support streaming. Wrapping the message as stream.");
                    this.invokeWebSocketProtocol(webSocket, new ByteArrayInputStream(data, offset, length));
                    return;
                }
                try {
                    if (this.invokeInterceptors) {
                        this.invokeInterceptors(webSocketHandler, webSocket, data, offset, length);
                        break block7;
                    }
                    webSocketHandler.onByteMessage(webSocket, data, offset, length);
                }
                catch (Exception ex) {
                    this.handleException(ex, webSocket, webSocketHandler);
                }
            }
        }
        this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<byte[]>(data, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, webSocket));
    }

    @Override
    public void invokeWebSocketProtocol(WebSocket webSocket, InputStream stream) {
        block7: {
            WebSocketProcessor.WebSocketHandlerProxy webSocketHandler = this.webSocketHandlerForMessage(webSocket);
            try {
                if (webSocketHandler == null) {
                    if (WebSocketProtocolStream.class.isAssignableFrom(this.webSocketProtocol.getClass())) {
                        List<AtmosphereRequest> list = ((WebSocketProtocolStream)WebSocketProtocolStream.class.cast(this.webSocketProtocol)).onBinaryStream(webSocket, stream);
                        this.dispatch(webSocket, list);
                        break block7;
                    }
                    this.dispatchStream(webSocket, stream);
                    return;
                }
                if (WebSocketStreamingHandler.class.isAssignableFrom(webSocketHandler.proxied.getClass())) {
                    if (this.invokeInterceptors) {
                        this.invokeInterceptors(webSocketHandler, webSocket, stream);
                    } else {
                        ((WebSocketStreamingHandler)WebSocketStreamingHandler.class.cast(webSocketHandler.proxied())).onBinaryStream(webSocket, stream);
                    }
                    break block7;
                }
                this.dispatchStream(webSocket, stream);
                return;
            }
            catch (Exception ex) {
                this.handleException(ex, webSocket, webSocketHandler);
            }
        }
        this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<InputStream>(stream, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, webSocket));
    }

    @Override
    public void invokeWebSocketProtocol(WebSocket webSocket, Reader reader) {
        block7: {
            WebSocketProcessor.WebSocketHandlerProxy webSocketHandler = this.webSocketHandlerForMessage(webSocket);
            try {
                if (webSocketHandler == null) {
                    if (WebSocketProtocolStream.class.isAssignableFrom(this.webSocketProtocol.getClass())) {
                        List<AtmosphereRequest> list = ((WebSocketProtocolStream)WebSocketProtocolStream.class.cast(this.webSocketProtocol)).onTextStream(webSocket, reader);
                        this.dispatch(webSocket, list);
                        break block7;
                    }
                    this.dispatchReader(webSocket, reader);
                    return;
                }
                if (WebSocketStreamingHandler.class.isAssignableFrom(webSocketHandler.proxied().getClass())) {
                    if (this.invokeInterceptors) {
                        this.invokeInterceptors(webSocketHandler, webSocket, reader);
                    } else {
                        ((WebSocketStreamingHandler)WebSocketStreamingHandler.class.cast(webSocketHandler.proxied())).onTextStream(webSocket, reader);
                    }
                    break block7;
                }
                this.dispatchReader(webSocket, reader);
                return;
            }
            catch (Exception ex) {
                this.handleException(ex, webSocket, webSocketHandler);
            }
        }
        this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<Reader>(reader, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, webSocket));
    }

    private void handleException(Exception ex, WebSocket webSocket, WebSocketHandler webSocketHandler) {
        logger.error("", (Throwable)ex);
        AtmosphereResource r = webSocket.resource();
        if (r != null) {
            webSocketHandler.onError(webSocket, new WebSocketProcessor.WebSocketException(ex, new AtmosphereResponse.Builder().request(r != null ? ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false) : null).status(500).statusMessage("Server Error").build()));
        }
    }

    public final void dispatch(WebSocket webSocket, AtmosphereRequest request, AtmosphereResponse r) {
        if (request == null) {
            return;
        }
        try {
            this.framework.doCometSupport(request, r);
        }
        catch (Throwable e) {
            logger.warn("Failed invoking AtmosphereFramework.doCometSupport()", e);
            this.webSocketProtocol.onError(webSocket, new WebSocketProcessor.WebSocketException(e, new AtmosphereResponse.Builder().request(request).status(500).statusMessage("Server Error").build()));
            return;
        }
        if (r.getStatus() >= 400) {
            this.webSocketProtocol.onError(webSocket, new WebSocketProcessor.WebSocketException("Status code higher or equal than 400", r));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(final WebSocket webSocket, int closeCode) {
        WebSocketHandler webSocketHandler = webSocket.webSocketHandler();
        final AtmosphereResourceImpl resource = (AtmosphereResourceImpl)webSocket.resource();
        if (resource == null) {
            logger.trace("Already closed {}", (Object)webSocket);
        } else {
            final boolean allowedToClose = this.allowedCloseCode(closeCode);
            final AtmosphereRequest r = resource.getRequest(false);
            final AtmosphereResponse s = resource.getResponse(false);
            boolean ff = r.getAttribute("firefox") != null;
            boolean completeLifecycle = true;
            try {
                this.webSocketProtocol.onClose(webSocket);
                if (webSocketHandler != null) {
                    webSocketHandler.onClose(webSocket);
                }
                logger.trace("About to close AtmosphereResource for {} with code {}", (Object)resource, (Object)closeCode);
                if (!(resource.getAtmosphereResourceEvent().isClosedByClient() || resource.getAtmosphereResourceEvent().isClosedByApplication() || resource.isCancelled())) {
                    if (allowedToClose) {
                        if (ff || this.closingTime > 0L) {
                            completeLifecycle = false;
                            logger.debug("Delaying closing operation for firefox and resource {}", (Object)resource.uuid());
                            ExecutorsFactory.getScheduler(this.framework.getAtmosphereConfig()).schedule(new Callable<Object>(){

                                @Override
                                public Object call() throws Exception {
                                    DefaultWebSocketProcessor.this.executeClose(webSocket, 1005);
                                    DefaultWebSocketProcessor.this.finish(webSocket, resource, r, s, !allowedToClose);
                                    return null;
                                }
                            }, ff ? (this.closingTime == 0L ? 1000L : this.closingTime) : this.closingTime, TimeUnit.MILLISECONDS);
                        } else {
                            this.executeClose(webSocket, closeCode);
                        }
                    } else {
                        logger.debug("Timeout {}", (Object)resource.uuid());
                        this.asynchronousProcessor.endRequest((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(webSocket.resource()), false);
                    }
                } else {
                    logger.trace("Unable to properly complete {}", (Object)(resource == null ? "null" : resource.uuid()));
                    completeLifecycle = false;
                }
                if (completeLifecycle) {
                    this.finish(webSocket, resource, r, s, !allowedToClose);
                }
            }
            catch (Throwable throwable) {
                if (completeLifecycle) {
                    this.finish(webSocket, resource, r, s, !allowedToClose);
                }
                throw throwable;
            }
        }
    }

    private boolean allowedCloseCode(int closeCode) {
        return closeCode <= 1001 || closeCode > 1004;
    }

    private void finish(WebSocket webSocket, AtmosphereResource resource, AtmosphereRequest r, AtmosphereResponse s, boolean closeWebSocket) {
        this.framework.atmosphereFactory().remove(resource.uuid());
        if (webSocket != null) {
            try {
                r.setAttribute("Clean_Close", Boolean.TRUE);
                webSocket.resource(null);
                if (closeWebSocket) {
                    webSocket.close(s);
                }
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
        }
        if (r != null) {
            r.destroy(true);
        }
        if (s != null) {
            s.destroy(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeClose(WebSocket webSocket, int closeCode) {
        AtmosphereResource r = webSocket.resource();
        boolean isClosedByClient = r == null ? true : r.getAtmosphereResourceEvent().isClosedByClient();
        try {
            if (r != null) {
                this.asynchronousProcessor.endRequest((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r), true);
            }
        }
        finally {
            if (!isClosedByClient) {
                this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<Integer>(closeCode, WebSocketEventListener.WebSocketEvent.TYPE.CLOSE, webSocket));
            }
        }
    }

    @Override
    public void destroy() {
        boolean shared = this.framework.isShareExecutorServices();
        if (this.asyncExecutor != null && !shared) {
            this.asyncExecutor.shutdown();
        }
        if (this.scheduler != null && !shared) {
            this.scheduler.shutdown();
        }
    }

    @Override
    public void notifyListener(WebSocket webSocket, WebSocketEventListener.WebSocketEvent event) {
        AtmosphereResource resource = webSocket.resource();
        if (resource == null) {
            return;
        }
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(resource);
        for (AtmosphereResourceEventListener l : r.atmosphereResourceEventListener()) {
            boolean isClosedByClient;
            if (WebSocketEventListener.class.isAssignableFrom(l.getClass())) {
                try {
                    switch (event.type()) {
                        case CONNECT: {
                            ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onConnect(event);
                            break;
                        }
                        case DISCONNECT: {
                            ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onDisconnect(event);
                            this.onDisconnect(event, l);
                            break;
                        }
                        case CONTROL: {
                            ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onControl(event);
                            break;
                        }
                        case MESSAGE: {
                            ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onMessage(event);
                            break;
                        }
                        case HANDSHAKE: {
                            ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onHandshake(event);
                            break;
                        }
                        case CLOSE: {
                            isClosedByClient = r.getAtmosphereResourceEvent().isClosedByClient();
                            l.onDisconnect(new AtmosphereResourceEventImpl(r, !isClosedByClient, false, isClosedByClient, null));
                            this.onDisconnect(event, l);
                            ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onClose(event);
                        }
                    }
                }
                catch (Throwable t) {
                    logger.debug("Listener error {}", t);
                    try {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onThrowable(new AtmosphereResourceEventImpl(r, false, false, t));
                    }
                    catch (Throwable t2) {
                        logger.warn("Listener error {}", t2);
                    }
                }
                continue;
            }
            switch (event.type()) {
                case CLOSE: {
                    isClosedByClient = r.getAtmosphereResourceEvent().isClosedByClient();
                    l.onDisconnect(new AtmosphereResourceEventImpl(r, !isClosedByClient, false, isClosedByClient, null));
                }
            }
        }
    }

    private void onDisconnect(WebSocketEventListener.WebSocketEvent event, AtmosphereResourceEventListener l) {
        if (event.webSocket() != null && event.webSocket().resource() != null) {
            this.framework.notifyDestroyed(event.webSocket().resource().uuid());
        }
        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onDisconnect(event);
    }

    public static final Map<String, String> configureHeader(AtmosphereRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration<String> e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            headers.put(s, request.getParameter(s));
        }
        headers.put("X-Atmosphere-Transport", "websocket");
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchStream(WebSocket webSocket, InputStream is) throws IOException {
        int read = 0;
        ByteBuffer bb = webSocket.bb;
        try {
            while (read > -1) {
                bb.position(bb.position() + read);
                if (bb.remaining() == 0) {
                    bb = this.resizeByteBuffer(webSocket);
                }
                read = is.read(bb.array(), bb.position(), bb.remaining());
            }
            bb.flip();
            this.invokeWebSocketProtocol(webSocket, bb.array(), 0, bb.limit());
        }
        finally {
            bb.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchReader(WebSocket webSocket, Reader r) throws IOException {
        int read = 0;
        CharBuffer cb = webSocket.cb;
        try {
            while (read > -1) {
                cb.position(cb.position() + read);
                if (cb.remaining() == 0) {
                    cb = this.resizeCharBuffer(webSocket);
                }
                read = r.read(cb.array(), cb.position(), cb.remaining());
            }
            cb.flip();
            this.invokeWebSocketProtocol(webSocket, cb.toString());
        }
        finally {
            cb.clear();
        }
    }

    private ByteBuffer resizeByteBuffer(WebSocket webSocket) throws IOException {
        int maxSize = this.byteBufferMaxSize;
        ByteBuffer bb = webSocket.bb;
        if (bb.limit() >= maxSize) {
            throw new IOException("Message Buffer too small. Use " + StreamingHttpProtocol.class.getName() + " when streaming over websocket.");
        }
        long newSize = bb.limit() * 2;
        if (newSize > (long)maxSize) {
            newSize = maxSize;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate((int)newSize);
        bb.rewind();
        newBuffer.put(bb);
        webSocket.bb = newBuffer;
        return newBuffer;
    }

    private CharBuffer resizeCharBuffer(WebSocket webSocket) throws IOException {
        int maxSize = this.charBufferMaxSize;
        CharBuffer cb = webSocket.cb;
        if (cb.limit() >= maxSize) {
            throw new IOException("Message Buffer too small. Use " + StreamingHttpProtocol.class.getName() + " when streaming over websocket.");
        }
        long newSize = cb.limit() * 2;
        if (newSize > (long)maxSize) {
            newSize = maxSize;
        }
        CharBuffer newBuffer = CharBuffer.allocate((int)newSize);
        cb.rewind();
        newBuffer.put(cb);
        webSocket.cb = newBuffer;
        return newBuffer;
    }

    protected void optimizeMapping() {
        for (String w : this.framework.getAtmosphereConfig().handlers().keySet()) {
            if (!w.contains("{") || !w.contains("}")) continue;
            this.wildcardMapping = true;
        }
    }

    public boolean wildcardMapping() {
        return this.wildcardMapping;
    }

    public DefaultWebSocketProcessor wildcardMapping(boolean wildcardMapping) {
        this.wildcardMapping = wildcardMapping;
        return this;
    }

    public Map<String, WebSocketProcessor.WebSocketHandlerProxy> handlers() {
        return this.handlers;
    }

    public boolean executeAsync() {
        return this.executeAsync;
    }

    public boolean destroyable() {
        return this.destroyable;
    }

    public int byteBufferMaxSize() {
        return this.byteBufferMaxSize;
    }

    public DefaultWebSocketProcessor byteBufferMaxSize(int byteBufferMaxSize) {
        this.byteBufferMaxSize = byteBufferMaxSize;
        return this;
    }

    public int charBufferMaxSize() {
        return this.charBufferMaxSize;
    }

    public DefaultWebSocketProcessor charBufferMaxSize(int charBufferMaxSize) {
        this.charBufferMaxSize = charBufferMaxSize;
        return this;
    }

    public long closingTime() {
        return this.closingTime;
    }

    public EndpointMapper<WebSocketProcessor.WebSocketHandlerProxy> mapper() {
        return this.mapper;
    }

    public boolean invokeInterceptors() {
        return this.invokeInterceptors;
    }

    @Override
    public void onPong(WebSocket webSocket, byte[] payload, int offset, int length) {
        WebSocketProcessor.WebSocketHandlerProxy webSocketHandler = this.webSocketHandlerForMessage(webSocket);
        if (webSocketHandler != null && WebSocketPingPongListener.class.isAssignableFrom(webSocketHandler.proxied().getClass())) {
            ((WebSocketPingPongListener)WebSocketPingPongListener.class.cast(webSocketHandler.proxied())).onPong(webSocket, payload, offset, length);
        }
    }

    @Override
    public void onPing(WebSocket webSocket, byte[] payload, int offset, int length) {
        WebSocketProcessor.WebSocketHandlerProxy webSocketHandler = this.webSocketHandlerForMessage(webSocket);
        if (webSocketHandler != null && WebSocketPingPongListener.class.isAssignableFrom(webSocketHandler.proxied().getClass())) {
            ((WebSocketPingPongListener)WebSocketPingPongListener.class.cast(webSocketHandler.proxied())).onPing(webSocket, payload, offset, length);
        }
    }
}

