/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import org.atmosphere.util.JDK6ForkJoinPool;
import org.atmosphere.util.JDK7ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkJoinPool
extends AbstractExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(ForkJoinPool.class);
    private final AbstractExecutorService forkJoinPool;
    private static boolean useForkJoinPool;

    public ForkJoinPool(boolean shared, String threadName) {
        this.forkJoinPool = useForkJoinPool ? new JDK7ForkJoinPool(shared, threadName) : new JDK6ForkJoinPool(shared, threadName);
        logger.info("Using ForkJoinPool  {}. Set the {} to -1 to fully use its power.", (Object)this.forkJoinPool.getClass().getName(), (Object)"org.atmosphere.cpr.broadcaster.maxAsyncWriteThreads");
    }

    @Override
    public void shutdown() {
        this.forkJoinPool.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.forkJoinPool.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.forkJoinPool.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.forkJoinPool.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.forkJoinPool.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.forkJoinPool.execute(command);
    }

    static {
        try {
            Class.forName("java.util.concurrent.ForkJoinPool");
            useForkJoinPool = true;
        }
        catch (ClassNotFoundException e) {
            useForkJoinPool = false;
        }
    }
}

