/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import org.atmosphere.container.JettyWebSocketUtil;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.websocket.WebSocketProcessor;
import org.eclipse.jetty.websocket.WebSocketFactory;

public class JettyServlet30AsyncSupportWithWebSocket
extends Servlet30CometSupport {
    private final WebSocketFactory webSocketFactory;

    public JettyServlet30AsyncSupportWithWebSocket(AtmosphereConfig config) {
        super(config);
        WebSocketProcessor webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(config.framework());
        this.webSocketFactory = JettyWebSocketUtil.getFactory(config, webSocketProcessor);
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = JettyWebSocketUtil.doService(this, req, res, this.webSocketFactory);
        return action == null ? super.service(req, res) : action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

