/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import org.atmosphere.interceptor.InvokationOrder;
import org.atmosphere.runtime.Action;
import org.atmosphere.runtime.AtmosphereConfig;
import org.atmosphere.runtime.AtmosphereInterceptorAdapter;
import org.atmosphere.runtime.AtmosphereRequest;
import org.atmosphere.runtime.AtmosphereResource;
import org.atmosphere.runtime.AtmosphereResponse;
import org.atmosphere.util.Utils;

public class CorsInterceptor
extends AtmosphereInterceptorAdapter {
    private final String EXPOSE_HEADERS = "X-Atmosphere-tracking-id, X-Heartbeat-Server";
    private boolean enableAccessControl = true;

    @Override
    public void configure(AtmosphereConfig config) {
        String ac = config.getInitParameter("org.atmosphere.runtime.dropAccessControlAllowOriginHeader");
        if (ac != null) {
            this.enableAccessControl = !Boolean.parseBoolean(ac);
        }
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (Utils.webSocketMessage(r)) {
            return Action.CONTINUE;
        }
        if (!this.enableAccessControl) {
            return Action.CONTINUE;
        }
        AtmosphereRequest req = r.getRequest();
        AtmosphereResponse res = r.getResponse();
        if (req.getHeader("Origin") != null && res.getHeader("Access-Control-Allow-Origin") == null) {
            res.addHeader("Access-Control-Allow-Origin", req.getHeader("Origin"));
            res.addHeader("Access-Control-Expose-Headers", "X-Atmosphere-tracking-id, X-Heartbeat-Server");
            res.setHeader("Access-Control-Allow-Credentials", "true");
        }
        if ("OPTIONS".equals(req.getMethod())) {
            res.setHeader("Access-Control-Allow-Methods", "OPTIONS, GET, POST");
            res.setHeader("Access-Control-Allow-Headers", "Origin, Content-Type, AuthToken, X-Atmosphere-Framework, X-Requested-With, X-Atmosphere-tracking-id, X-Heartbeat-Server, X-Atmosphere-Transport, X-Atmosphere-TrackMessageSize, X-atmo-protocol");
            res.setHeader("Access-Control-Max-Age", "-1");
            return Action.SKIP_ATMOSPHEREHANDLER;
        }
        return Action.CONTINUE;
    }

    public boolean enableAccessControl() {
        return this.enableAccessControl;
    }

    public CorsInterceptor enableAccessControl(boolean enableAccessControl) {
        this.enableAccessControl = enableAccessControl;
        return this;
    }

    @Override
    public InvokationOrder.PRIORITY priority() {
        return InvokationOrder.FIRST_BEFORE_DEFAULT;
    }

    @Override
    public String toString() {
        return "CORS Interceptor Support";
    }
}

