/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.runtime;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.runtime.Action;
import org.atmosphere.runtime.AsyncSupport;
import org.atmosphere.runtime.AtmosphereConfig;
import org.atmosphere.runtime.AtmosphereFramework;
import org.atmosphere.runtime.AtmosphereHandler;
import org.atmosphere.runtime.AtmosphereInterceptor;
import org.atmosphere.runtime.AtmosphereMappingException;
import org.atmosphere.runtime.AtmosphereRequest;
import org.atmosphere.runtime.AtmosphereResource;
import org.atmosphere.runtime.AtmosphereResourceEventImpl;
import org.atmosphere.runtime.AtmosphereResourceImpl;
import org.atmosphere.runtime.AtmosphereResponse;
import org.atmosphere.runtime.Broadcaster;
import org.atmosphere.runtime.BroadcasterFactory;
import org.atmosphere.runtime.DefaultBroadcaster;
import org.atmosphere.runtime.FrameworkConfig;
import org.atmosphere.runtime.SessionTimeoutSupport;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsynchronousProcessor
implements AsyncSupport<AtmosphereResourceImpl> {
    private static final Logger logger = LoggerFactory.getLogger(AsynchronousProcessor.class);
    protected static final Action timedoutAction = new Action(Action.TYPE.TIMEOUT);
    protected static final Action cancelledAction = new Action(Action.TYPE.CANCELLED);
    protected final AtmosphereConfig config;
    private EndpointMapper<AtmosphereFramework.AtmosphereHandlerWrapper> mapper;
    private final long closingTime;
    private final boolean isServlet30;
    private boolean closeOnCancel;

    public AsynchronousProcessor(AtmosphereConfig config) {
        this.config = config;
        this.closingTime = Long.valueOf(config.getInitParameter("org.atmosphere.runtime.delayClosingTime", "0"));
        this.isServlet30 = Servlet30CometSupport.class.isAssignableFrom(this.getClass());
        this.closeOnCancel = config.getInitParameter("org.atmosphere.runtime.AsynchronousProcessor.closeOnCancel", false);
        config.startupHook(new AtmosphereConfig.StartupHook(){

            @Override
            public void started(AtmosphereFramework framework) {
                AsynchronousProcessor.this.mapper = framework.endPointMapper();
            }
        });
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
    }

    protected boolean supportSession() {
        return this.config.isSupportSession();
    }

    protected boolean allowSessionTimeoutRemoval() {
        return this.config.isSessionTimeoutRemovalAllowed();
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo();
    }

    public Action suspended(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
        return this.action(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Action action(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        boolean skipAtmosphereHandler;
        LinkedList<AtmosphereInterceptor> invokedInterceptors;
        AtmosphereResourceImpl resource;
        AtmosphereFramework.AtmosphereHandlerWrapper handlerWrapper;
        block20: {
            if (!Utils.properProtocol(req)) {
                logger.debug("Invalid request state.");
                res.setStatus(501);
                res.addHeader("X-Atmosphere-error", "Websocket protocol not supported");
                res.flushBuffer();
                return new Action();
            }
            if (Utils.webSocketEnabled(req) && !this.supportWebSocket()) {
                logger.warn("Websocket protocol not supported");
                res.setStatus(501);
                res.addHeader("X-Atmosphere-error", "Websocket protocol not supported");
                res.flushBuffer();
                return new Action();
            }
            if (this.config.handlers().isEmpty()) {
                logger.error("No AtmosphereHandler found. Make sure you define it inside WEB-INF/atmosphere.xml or annotate using @___Service");
                throw new AtmosphereMappingException("No AtmosphereHandler found. Make sure you define it inside WEB-INF/atmosphere.xml or annotate using @___Service");
            }
            if (res.request() == null) {
                res.request(req);
            }
            if (this.supportSession()) {
                HttpSession s = req.getSession(this.config.getInitParameter("org.atmosphere.runtime.sessionCreate", true));
                try {
                    if (s != null && s.isNew()) {
                        s.setAttribute(FrameworkConfig.BROADCASTER_FACTORY, (Object)this.config.getBroadcasterFactory());
                    }
                }
                catch (IllegalStateException ex) {
                    AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(req.resource());
                    logger.warn("Session Expired for {}. Closing the connection", (Object)req.uuid(), (Object)ex);
                    if (r != null) {
                        logger.trace("Ending request for {}", (Object)r.uuid());
                        this.endRequest(r, true);
                        return Action.CANCELLED;
                    }
                    logger.trace("Sending error for {}", (Object)req.uuid());
                    res.setStatus(500);
                    res.addHeader("X-Atmosphere-error", "Session expired");
                    res.flushBuffer();
                    return new Action();
                }
            }
            req.setAttribute(FrameworkConfig.SUPPORT_SESSION, this.supportSession());
            int tracing = 0;
            handlerWrapper = this.map(req);
            if (this.config.getBroadcasterFactory() == null) {
                logger.error("Atmosphere is misconfigured and will not work. BroadcasterFactory is null");
                return Action.CANCELLED;
            }
            resource = this.configureWorkflow(null, handlerWrapper, req, res);
            String v = req.getHeader("X-Atmosphere-Binary");
            if (v != null) {
                resource.forceBinaryWrite(Boolean.valueOf(v));
            }
            invokedInterceptors = handlerWrapper.interceptors;
            try {
                Action a = this.invokeInterceptors(invokedInterceptors, resource, tracing);
                if (a.type() == Action.TYPE.CONTINUE || a.type() == Action.TYPE.SKIP_ATMOSPHEREHANDLER) break block20;
                Action action = a;
                this.postInterceptors(handlerWrapper != null ? handlerWrapper.interceptors : invokedInterceptors, resource);
                return action;
            }
            catch (Throwable throwable) {
                this.postInterceptors(handlerWrapper != null ? handlerWrapper.interceptors : invokedInterceptors, resource);
                throw throwable;
            }
        }
        if (req.getAttribute(FrameworkConfig.NEW_MAPPING) != null) {
            req.removeAttribute(FrameworkConfig.NEW_MAPPING);
            handlerWrapper = this.map(req);
            if (handlerWrapper == null) {
                logger.debug("Remap {}", (Object)resource.uuid());
                throw new AtmosphereMappingException("Invalid state. No AtmosphereHandler maps request for " + req.getRequestURI());
            }
            resource = this.configureWorkflow(resource, handlerWrapper, req, res);
            resource.setBroadcaster(handlerWrapper.broadcaster);
        }
        if (!(skipAtmosphereHandler = (req.getAttribute(Action.TYPE.SKIP_ATMOSPHEREHANDLER.name()) != null ? (Boolean)req.getAttribute(Action.TYPE.SKIP_ATMOSPHEREHANDLER.name()) : Boolean.FALSE).booleanValue())) {
            try {
                logger.trace("\t Last: {}", (Object)handlerWrapper.atmosphereHandler.getClass().getName());
                handlerWrapper.atmosphereHandler.onRequest(resource);
            }
            catch (IOException t) {
                resource.onThrowable(t);
                throw t;
            }
        }
        this.postInterceptors(handlerWrapper != null ? handlerWrapper.interceptors : invokedInterceptors, resource);
        Action action = resource.action();
        if (this.supportSession() && this.allowSessionTimeoutRemoval() && action.type().equals((Object)Action.TYPE.SUSPEND)) {
            SessionTimeoutSupport.setupTimeout(this.config, req.getSession(this.config.getInitParameter("org.atmosphere.runtime.sessionCreate", true)));
        }
        logger.trace("Action for {} was {} with transport " + req.getHeader("X-Atmosphere-Transport"), (Object)(req.resource() != null ? req.resource().uuid() : "null"), (Object)action);
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtmosphereResourceImpl configureWorkflow(AtmosphereResourceImpl resource, AtmosphereFramework.AtmosphereHandlerWrapper handlerWrapper, AtmosphereRequest req, AtmosphereResponse res) {
        Broadcaster b = handlerWrapper.broadcaster;
        if (b.isDestroyed()) {
            BroadcasterFactory f;
            BroadcasterFactory broadcasterFactory = f = this.config.getBroadcasterFactory();
            synchronized (broadcasterFactory) {
                f.remove(b, b.getID());
                try {
                    handlerWrapper.broadcaster = f.get(b.getID());
                }
                catch (IllegalStateException ex) {
                    logger.trace("", (Throwable)ex);
                    handlerWrapper.broadcaster = f.lookup(b.getID(), true);
                }
            }
        }
        if (resource == null) {
            resource = (AtmosphereResourceImpl)req.getAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE);
        }
        if (resource == null) {
            resource = (AtmosphereResourceImpl)this.config.resourcesFactory().create(this.config, handlerWrapper.broadcaster, res, this, handlerWrapper.atmosphereHandler);
        } else {
            try {
                resource.getBroadcaster();
            }
            catch (IllegalStateException ex) {
                resource.setBroadcaster(handlerWrapper.broadcaster);
            }
            resource.atmosphereHandler(handlerWrapper.atmosphereHandler);
        }
        req.setAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE, resource);
        req.setAttribute(FrameworkConfig.ATMOSPHERE_HANDLER_WRAPPER, handlerWrapper);
        req.setAttribute(Action.TYPE.SKIP_ATMOSPHEREHANDLER.name(), Boolean.FALSE);
        return resource;
    }

    protected void shutdown() {
        Collection<AtmosphereResource> c = this.config.resourcesFactory().findAll();
        for (AtmosphereResource r : c) {
            try {
                r.close();
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
        }
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
    }

    @Override
    public AsyncSupport complete(AtmosphereResourceImpl r) {
        return this;
    }

    private String path(AtmosphereRequest request) {
        String pathInfo = null;
        try {
            pathInfo = request.getPathInfo();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        String path = pathInfo != null ? request.getServletPath() + pathInfo : request.getServletPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        return path;
    }

    public Action invokeInterceptors(List<AtmosphereInterceptor> c, AtmosphereResource r, int tracing) {
        Action a = Action.CONTINUE;
        for (AtmosphereInterceptor arc : c) {
            boolean skip;
            if (!((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).isInScope()) {
                logger.warn("Request closed during processing {} and transport {}", (Object)r.uuid(), (Object)r.transport());
                return Action.CANCELLED;
            }
            try {
                a = arc.inspect(r);
            }
            catch (Exception ex) {
                logger.error("Interceptor {} crashed. Processing will continue with other interceptor.", (Object)arc, (Object)ex);
                continue;
            }
            if (a == null) {
                logger.trace("Action was null for {}", (Object)arc);
                a = Action.CANCELLED;
            }
            boolean bl = skip = a.type() == Action.TYPE.SKIP_ATMOSPHEREHANDLER;
            if (skip) {
                logger.trace("AtmosphereInterceptor {} asked to skip the AtmosphereHandler for {}", (Object)arc, (Object)r.uuid());
                r.getRequest().setAttribute(Action.TYPE.SKIP_ATMOSPHEREHANDLER.name(), Boolean.TRUE);
            }
            if (a.type() != Action.TYPE.CONTINUE) {
                logger.trace("Interceptor {} interrupted the dispatch for {} with " + a, (Object)arc, (Object)r.uuid());
                return a;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("\t {}: {} for {}", (Object[])new String[]{String.valueOf(tracing++), arc.getClass().getName(), r.uuid()});
        }
        return a;
    }

    public void postInterceptors(List<AtmosphereInterceptor> c, AtmosphereResource r) {
        AtmosphereInterceptor arc = null;
        for (int i = c.size() - 1; i > -1; --i) {
            try {
                arc = c.get(i);
                arc.postInspect(r);
                continue;
            }
            catch (Exception ex) {
                logger.error("Interceptor {} crashed. Processing will continue with other interceptor.", (Object)arc, (Object)ex);
            }
        }
    }

    protected AtmosphereFramework.AtmosphereHandlerWrapper map(AtmosphereRequest req) throws ServletException {
        AtmosphereFramework.AtmosphereHandlerWrapper atmosphereHandlerWrapper = this.mapper.map(req, this.config.handlers());
        if (atmosphereHandlerWrapper == null) {
            logger.debug("No AtmosphereHandler maps request for {} with mapping {}", (Object)req.getRequestURI(), this.config.handlers());
            throw new AtmosphereMappingException("No AtmosphereHandler maps request for " + req.getRequestURI());
        }
        return atmosphereHandlerWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action resumed(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)request.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        if (r == null) {
            return Action.CANCELLED;
        }
        AtmosphereHandler atmosphereHandler = r.getAtmosphereHandler();
        AtmosphereResourceEventImpl event = r.getAtmosphereResourceEvent();
        if (event != null && event.isResuming() && !event.isCancelled()) {
            AtmosphereResourceImpl atmosphereResourceImpl = r;
            synchronized (atmosphereResourceImpl) {
                atmosphereHandler.onStateChange(event);
            }
        }
        return Action.RESUME;
    }

    public Action timedout(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        logger.trace("Timing out {}", (Object)req);
        this.endRequest((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(req.resource()), false);
        return timedoutAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean completeLifecycle(AtmosphereResource r, boolean cancelled) {
        if (r != null && !r.isCancelled() && !((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getAndSetInClosingPhase()) {
            logger.trace("Finishing lifecycle for AtmosphereResource {}", (Object)r.uuid());
            AtmosphereResourceImpl impl = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r);
            try {
                if (impl.isCancelled()) {
                    logger.debug("{} is already cancelled", (Object)impl.uuid());
                    boolean bl = false;
                    return bl;
                }
                AtmosphereResourceEventImpl e = impl.getAtmosphereResourceEvent();
                if (this.config.framework().isDestroyed()) {
                    cancelled = true;
                }
                if (!e.isClosedByClient()) {
                    if (cancelled) {
                        e.setCancelled(cancelled);
                    } else {
                        e.setIsResumedOnTimeout(true);
                        Broadcaster b = r.getBroadcaster();
                        if (b instanceof DefaultBroadcaster) {
                            ((DefaultBroadcaster)b).broadcastOnResume(r);
                        }
                    }
                }
                this.invokeAtmosphereHandler(impl);
                return true;
            }
            catch (Throwable ex) {
                logger.error("Failed to cancel resource: {}", (Object)impl.uuid(), (Object)ex);
                return true;
            }
            finally {
                try {
                    impl.notifyListeners();
                    if (this.closeOnCancel) {
                        try {
                            impl.getResponse(false).getOutputStream().close();
                        }
                        catch (Throwable t) {
                            try {
                                impl.getResponse(false).getWriter().close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    impl.setIsInScope(false);
                    impl.cancel();
                }
                catch (Throwable t) {
                    logger.debug("completeLifecycle", t);
                }
                finally {
                    impl._destroy();
                }
            }
        }
        logger.trace("AtmosphereResource {} was already cancelled or gc", (Object)(r != null ? r.uuid() : "null"));
        return false;
    }

    protected void invokeAtmosphereHandler(AtmosphereResourceImpl r) throws IOException {
        block8: {
            if (r.isInScope()) {
                String disableOnEvent = r.getAtmosphereConfig().getInitParameter("org.atmosphere.disableOnStateEvent");
                r.getAtmosphereResourceEvent().setMessage(r.writeOnTimeout());
                try {
                    AtmosphereHandler atmosphereHandler;
                    if (disableOnEvent != null && disableOnEvent.equals(String.valueOf(true)) || (atmosphereHandler = r.getAtmosphereHandler()) == null || !r.isInScope()) break block8;
                    try {
                        Utils.inject(r);
                    }
                    catch (IllegalAccessException e) {
                        logger.warn("", (Throwable)e);
                    }
                    atmosphereHandler.onStateChange(r.getAtmosphereResourceEvent());
                }
                catch (IOException ex) {
                    try {
                        r.onThrowable(ex);
                    }
                    catch (Throwable t) {
                        logger.warn("failed calling onThrowable()", (Throwable)ex);
                    }
                }
            } else {
                logger.trace("AtmosphereResource out of scope {}", (Object)r.uuid());
                return;
            }
        }
    }

    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        logger.trace("Cancelling {}", (Object)req);
        final AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(req.resource());
        if (this.closingTime > 0L) {
            ExecutorsFactory.getScheduler(this.config).schedule(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AsynchronousProcessor.this.endRequest(r, true);
                    return null;
                }
            }, this.closingTime, TimeUnit.MILLISECONDS);
        } else if (this.completeLifecycle(req.resource(), true)) {
            this.config.framework().notify(Action.TYPE.CANCELLED, req, res);
        }
        return cancelledAction;
    }

    public void endRequest(AtmosphereResourceImpl r, boolean cancel) {
        if (this.completeLifecycle(r, cancel)) {
            this.config.framework().notify(Action.TYPE.CANCELLED, r.getRequest(false), r.getResponse(false));
        }
    }

    @Override
    public boolean supportWebSocket() {
        return false;
    }
}

