/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.runtime;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.atmosphere.runtime.AtmosphereResource;
import org.atmosphere.runtime.AtmosphereResourceEvent;
import org.atmosphere.runtime.AtmosphereResourceEventListener;
import org.atmosphere.runtime.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.runtime.AtmosphereResourceSession;
import org.atmosphere.runtime.AtmosphereResourceSessionFactory;
import org.atmosphere.runtime.DefaultAtmosphereResourceSession;

public class DefaultAtmosphereResourceSessionFactory
implements AtmosphereResourceSessionFactory {
    private final ConcurrentMap<String, AtmosphereResourceSession> sessions = new ConcurrentHashMap<String, AtmosphereResourceSession>();
    private final AtmosphereResourceEventListener disconnectListener = new AtmosphereResourceEventListenerAdapter(){

        @Override
        public void onDisconnect(AtmosphereResourceEvent event) {
            String uuid = event.getResource().uuid();
            AtmosphereResourceSession session = (AtmosphereResourceSession)DefaultAtmosphereResourceSessionFactory.this.sessions.remove(uuid);
            if (session != null) {
                session.invalidate();
            }
        }

        public String toString() {
            return "DefaultAtmosphereResourceSessionFactory.disconnectListener";
        }
    };

    @Override
    public AtmosphereResourceSession getSession(AtmosphereResource r, boolean create) {
        AtmosphereResourceSession session = (AtmosphereResourceSession)this.sessions.get(r.uuid());
        if (create && session == null) {
            r.addEventListener(this.getDisconnectListener());
            session = new DefaultAtmosphereResourceSession();
            AtmosphereResourceSession existing = this.sessions.putIfAbsent(r.uuid(), session);
            if (existing != null) {
                session = existing;
            }
        }
        return session;
    }

    @Override
    public AtmosphereResourceSession getSession(AtmosphereResource resource) {
        return this.getSession(resource, true);
    }

    @Override
    public void destroy() {
        this.sessions.clear();
    }

    protected AtmosphereResourceEventListener getDisconnectListener() {
        return this.disconnectListener;
    }
}

