/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.runtime.BroadcastFilter;

public class StringFilterAggregator
implements BroadcastFilter {
    private final int maxBufferedString;
    private final AtomicReference<StringBuilder> bufferedMessage = new AtomicReference<StringBuilder>(new StringBuilder());

    public StringFilterAggregator() {
        this.maxBufferedString = 256;
    }

    public StringFilterAggregator(int maxBufferedString) {
        this.maxBufferedString = maxBufferedString;
    }

    @Override
    public BroadcastFilter.BroadcastAction filter(String broadcasterId, Object originalMessage, Object message) {
        if (message instanceof String) {
            this.bufferedMessage.get().append(message);
            if (this.bufferedMessage.get().length() < this.maxBufferedString) {
                return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.ABORT, message);
            }
            message = this.bufferedMessage.toString();
            this.bufferedMessage.get().delete(0, this.bufferedMessage.get().length());
            return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, message);
        }
        return new BroadcastFilter.BroadcastAction(message);
    }
}

