/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpSession;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.server.HandshakeRequest;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.atmosphere.container.version.JSR356WebSocket;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.util.CookieUtil;
import org.atmosphere.util.IOUtils;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR356Endpoint
extends Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(JSR356Endpoint.class);
    private static final String JAVAX_WEBSOCKET_ENDPOINT_LOCAL_ADDRESS = "jakarta.websocket.endpoint.localAddress";
    private static final String JAVAX_WEBSOCKET_ENDPOINT_REMOTE_ADDRESS = "jakarta.websocket.endpoint.remoteAddress";
    private final WebSocketProcessor webSocketProcessor;
    private final Integer maxBinaryBufferSize;
    private final Integer maxTextBufferSize;
    private AtmosphereRequest request;
    private final AtmosphereFramework framework;
    private WebSocket webSocket;
    private final int webSocketIdleTimeoutMs;
    private HttpSession handshakeSession;
    private Map<String, List<String>> handshakeHeaders;
    private final boolean disableDnsLookups;

    public JSR356Endpoint(AtmosphereFramework framework, WebSocketProcessor webSocketProcessor) {
        this.framework = framework;
        this.webSocketProcessor = webSocketProcessor;
        if (framework.isUseNativeImplementation()) {
            throw new IllegalStateException("You cannot use WebSocket native implementation with JSR356. Please set org.atmosphere.useNative to false");
        }
        String s = framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.maxIdleTime");
        this.webSocketIdleTimeoutMs = s != null ? Integer.parseInt(s) : -1;
        s = framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize");
        this.maxBinaryBufferSize = s != null ? Integer.valueOf(s) : Integer.valueOf(-1);
        s = framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.maxTextMessageSize");
        this.maxTextBufferSize = s != null ? Integer.valueOf(s) : Integer.valueOf(-1);
        s = framework.getAtmosphereConfig().getInitParameter("org.atmosphere.cpr.disableDnsLookups");
        this.disableDnsLookups = s != null ? Boolean.parseBoolean(s) : false;
    }

    public JSR356Endpoint handshakeRequest(HandshakeRequest handshakeRequest) {
        this.handshakeSession = (HttpSession)handshakeRequest.getHttpSession();
        this.handshakeHeaders = new HashMap<String, List<String>>();
        this.handshakeHeaders.putAll(handshakeRequest.getHeaders());
        return this;
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        if (this.framework.isDestroyed()) {
            return;
        }
        if (!session.isOpen()) {
            logger.trace("Session Closed {}", (Object)session);
            return;
        }
        if (this.maxBinaryBufferSize != -1) {
            session.setMaxBinaryMessageBufferSize(this.maxBinaryBufferSize.intValue());
        }
        if (this.webSocketIdleTimeoutMs != -1) {
            session.setMaxIdleTimeout((long)this.webSocketIdleTimeoutMs);
        }
        if (this.maxTextBufferSize != -1) {
            session.setMaxTextMessageBufferSize(this.maxTextBufferSize.intValue());
        }
        this.webSocket = new JSR356WebSocket(session, this.framework.getAtmosphereConfig());
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> e : this.handshakeHeaders.entrySet()) {
            headers.put(e.getKey(), !e.getValue().isEmpty() ? e.getValue().get(0) : "");
        }
        headers.put("Connection", "Upgrade");
        String servletPath = this.framework.getAtmosphereConfig().getInitParameter("org.atmosphere.container.JSR356AsyncSupport.mappingPath");
        if (servletPath == null) {
            servletPath = IOUtils.guestServletPath(this.framework.getAtmosphereConfig());
        }
        boolean recomputeForBackwardCompat = false;
        URI uri = session.getRequestURI();
        String rawPath = uri.getPath();
        String contextPath = this.framework.getAtmosphereConfig().getServletContext().getContextPath();
        int pathInfoStartAt = rawPath.indexOf(servletPath) + servletPath.length();
        String pathInfo = null;
        if (rawPath.length() >= pathInfoStartAt) {
            pathInfo = rawPath.substring(pathInfoStartAt);
        } else {
            recomputeForBackwardCompat = true;
        }
        if (recomputeForBackwardCompat) {
            String[] paths = uri.getPath() != null ? uri.getPath().split("/") : new String[]{};
            int pathInfoStartIndex = 3;
            if ("".equals(contextPath) || "".equals(servletPath)) {
                pathInfoStartIndex = 2;
            }
            StringBuilder b = new StringBuilder("/");
            for (int i = 0; i < paths.length; ++i) {
                if (i < pathInfoStartIndex) continue;
                b.append(paths[i]).append("/");
            }
            if (b.length() > 1) {
                b.deleteCharAt(b.length() - 1);
            }
            pathInfo = b.toString();
        }
        if (pathInfo.equals("/")) {
            pathInfo = null;
        }
        try {
            List<String> cookieHeaders;
            String requestURL = uri.toASCIIString();
            if (requestURL.contains("?")) {
                requestURL = requestURL.substring(0, requestURL.indexOf("?"));
            }
            if (!requestURL.startsWith("http://") || !requestURL.startsWith("https://")) {
                if (requestURL.startsWith("/")) {
                    List<String> l = this.handshakeHeaders.get("origin");
                    if (l == null) {
                        l = this.handshakeHeaders.get("Origin");
                    }
                    String origin = null;
                    if (l != null && !l.isEmpty()) {
                        origin = l.get(0);
                    }
                    if (origin == null || origin.equalsIgnoreCase("null")) {
                        logger.trace("Unable to retrieve the `origin` header for websocket {}", (Object)session);
                        origin = "http" + (session.isSecure() ? "s" : "") + "://0.0.0.0:80";
                    }
                    requestURL = origin + requestURL;
                } else if (requestURL.startsWith("ws://")) {
                    requestURL = requestURL.replace("ws://", "http://");
                } else if (requestURL.startsWith("wss://")) {
                    requestURL = requestURL.replace("wss://", "https://");
                }
            }
            if ((cookieHeaders = this.handshakeHeaders.get("cookie")) == null) {
                cookieHeaders = this.handshakeHeaders.get("Cookie");
            }
            HashSet<Cookie> cookies = null;
            if (cookieHeaders != null) {
                cookies = new HashSet<Cookie>();
                for (String cookieHeader : cookieHeaders) {
                    cookies.addAll(CookieUtil.ServerCookieDecoder.STRICT.decode(cookieHeader));
                }
            }
            ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
            if (this.handshakeSession != null) {
                Enumeration attributeNames = this.handshakeSession.getAttributeNames();
                while (attributeNames.hasMoreElements()) {
                    String attributeName = (String)attributeNames.nextElement();
                    attributes.put(attributeName, this.handshakeSession.getAttribute(attributeName));
                }
            }
            this.request = ((AtmosphereRequestImpl.Builder)((AtmosphereRequestImpl.Builder)((AtmosphereRequestImpl.Builder)((AtmosphereRequestImpl.Builder)((AtmosphereRequestImpl.Builder)new AtmosphereRequestImpl.Builder().requestURI(uri.getPath()).requestURL(requestURL).headers(headers)).cookies(cookies)).session(this.handshakeSession).servletPath(servletPath).contextPath(this.framework.getServletContext().getContextPath()).pathInfo(pathInfo).destroyable(false).userPrincipal(session.getUserPrincipal()).remoteInetSocketAddress(() -> (InetSocketAddress)endpointConfig.getUserProperties().get(JAVAX_WEBSOCKET_ENDPOINT_REMOTE_ADDRESS), this.disableDnsLookups)).localInetSocketAddress(() -> (InetSocketAddress)endpointConfig.getUserProperties().get(JAVAX_WEBSOCKET_ENDPOINT_LOCAL_ADDRESS), this.disableDnsLookups)).attributes(attributes)).isSSecure(session.isSecure()).build().queryString(session.getQueryString());
            if (!this.webSocketProcessor.handshake(this.request)) {
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, "Handshake not accepted."));
                }
                catch (IOException e) {
                    logger.trace("", (Throwable)e);
                }
                return;
            }
            this.framework.addInitParameter("org.atmosphere.cpr.allowQueryStreamAsPostOrGet", "false");
            this.webSocketProcessor.open(this.webSocket, this.request, AtmosphereResponseImpl.newInstance(this.framework.getAtmosphereConfig(), this.request, this.webSocket));
            this.framework.addInitParameter("org.atmosphere.cpr.allowQueryStreamAsPostOrGet", "true");
            if (session.isOpen()) {
                if (JSR356Endpoint.isWebsocket11Spec()) {
                    session.addMessageHandler(String.class, s -> this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, (String)s));
                    session.addMessageHandler(ByteBuffer.class, bb -> {
                        byte[] b = bb.hasArray() ? bb.array() : new byte[bb.limit()];
                        bb.get(b);
                        this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, b, 0, b.length);
                    });
                } else {
                    session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                        public void onMessage(String s) {
                            JSR356Endpoint.this.webSocketProcessor.invokeWebSocketProtocol(JSR356Endpoint.this.webSocket, s);
                        }
                    });
                    session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

                        public void onMessage(ByteBuffer bb) {
                            byte[] b = bb.hasArray() ? bb.array() : new byte[bb.limit()];
                            bb.get(b);
                            JSR356Endpoint.this.webSocketProcessor.invokeWebSocketProtocol(JSR356Endpoint.this.webSocket, b, 0, b.length);
                        }
                    });
                }
            } else {
                logger.trace("Session closed during onOpen {}", (Object)session);
                this.onClose(session, new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Session closed already"));
            }
        }
        catch (Throwable e) {
            if (session.isOpen()) {
                logger.error("", e);
            } else {
                logger.trace("Session closed during onOpen", e);
            }
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, e.getMessage()));
            }
            catch (IOException e1) {
                logger.trace("", e);
            }
        }
    }

    private static boolean isWebsocket11Spec() {
        try {
            Session.class.getMethod("addMessageHandler", Class.class, MessageHandler.Whole.class);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void onClose(Session session, CloseReason closeCode) {
        logger.trace("{} closed {}", (Object)session, (Object)closeCode);
        if (this.request != null) {
            this.request.destroy();
            this.webSocketProcessor.close(this.webSocket, closeCode.getCloseCode().getCode());
        }
    }

    public void onError(Session session, Throwable t) {
        try {
            logger.debug("Problem in web socket session", t);
            this.webSocketProcessor.notifyListener(this.webSocket, new WebSocketEventListener.WebSocketEvent<Throwable>(t, WebSocketEventListener.WebSocketEvent.TYPE.EXCEPTION, this.webSocket));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

