/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.inject;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.PathParam;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.handler.AnnotatedProxy;
import org.atmosphere.inject.InjectIntrospectorAdapter;
import org.atmosphere.inject.annotation.RequestScoped;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped(value={PathParam.class})
public class PathParamIntrospector
extends InjectIntrospectorAdapter<String> {
    private final Logger logger = LoggerFactory.getLogger(PathParamIntrospector.class);
    protected final ThreadLocal<String> pathLocal = new ThreadLocal();

    @Override
    public boolean supportedType(Type t) {
        return t instanceof Class && String.class.isAssignableFrom((Class)t);
    }

    @Override
    public String injectable(AtmosphereResource r) {
        AtmosphereFramework.AtmosphereHandlerWrapper w;
        String named = this.pathLocal.get();
        String[] paths = (String[])r.getRequest().getAttribute(PathParam.class.getName());
        if ((paths == null || paths.length != 2) && (w = (AtmosphereFramework.AtmosphereHandlerWrapper)r.getRequest().getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER_WRAPPER)) != null) {
            String targetPath;
            AnnotatedProxy ap;
            if (AnnotatedProxy.class.isAssignableFrom(w.atmosphereHandler.getClass()) && (ap = (AnnotatedProxy)w.atmosphereHandler).target().getClass().isAnnotationPresent(ManagedService.class) && (targetPath = ap.target().getClass().getAnnotation(ManagedService.class).path()).contains("{") && targetPath.contains("}")) {
                paths = new String[]{Utils.pathInfo(r.getRequest()), targetPath};
            }
            if (paths == null || paths.length != 2) {
                return null;
            }
        }
        this.logger.debug("Path: {}, targetPath: {}", this.pathLocal, (Object)paths[1]);
        String[] inParts = paths[0].split("/");
        String[] outParts = paths[1].split("/");
        HashMap<String, String> annotatedPathVars = new HashMap<String, String>();
        int len = Math.min(outParts.length, inParts.length);
        for (int i = 0; i < len; ++i) {
            String s = outParts[i];
            if (!s.startsWith("{") || !s.endsWith("}")) continue;
            int end = s.contains(":") ? s.indexOf(":") : s.length() - 1;
            annotatedPathVars.put(s.substring(1, end), inParts[i]);
            this.logger.debug("Putting PathVar pair: {} -> {}", (Object)s.substring(1, s.length() - 1), (Object)inParts[i]);
        }
        return (String)annotatedPathVars.get(named);
    }

    @Override
    public void introspectField(Class clazz, Field f) {
        if (f.isAnnotationPresent(PathParam.class)) {
            String name = f.getAnnotation(PathParam.class).value();
            if (name.isEmpty()) {
                name = f.getName();
            }
            this.pathLocal.set(name);
        }
    }
}

