/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.cluster.shoal;

import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.MessageSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureSuspectedActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.MessageActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.ClusterBroadcastFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoalFilter
implements CallBack,
ClusterBroadcastFilter<String> {
    static final Logger logger = Logger.getLogger("SimpleShoalGMSSample");
    final Object waitLock = new Object();
    private GroupManagementService gms;
    private String clusterName = "cluster-shoal";
    private String serverName = "Atmosphere-";
    private String topicName = "atmosphere-shoal";
    private Broadcaster bc;
    private final ConcurrentLinkedQueue<String> receivedMessages = new ConcurrentLinkedQueue();
    private static final AtomicInteger count = new AtomicInteger();

    public ShoalFilter() {
        this(null);
    }

    public ShoalFilter(Broadcaster bc) {
        this(bc, "atmosphere-framework");
    }

    public ShoalFilter(Broadcaster bc, String containerName) {
        this(bc, containerName, "cluster-atmosphere");
    }

    public ShoalFilter(Broadcaster bc, String containerName, String clusterName) {
        this.bc = bc;
        try {
            this.serverName = InetAddress.getLocalHost().getHostAddress() + "-" + containerName + "-" + count.getAndIncrement();
        }
        catch (UnknownHostException ex) {
            this.serverName = this.serverName + containerName;
        }
        this.clusterName = clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void init() {
        try {
            logger.log(Level.INFO, "Starting Atmosphere Shoal Clustering support");
            this.gms = this.initializeGMS(this.serverName, this.clusterName);
            this.registerForGroupEvents(this.gms);
            this.joinGMSGroup(this.clusterName, this.gms);
        }
        catch (Throwable t) {
            logger.log(Level.FINE, "", t);
        }
    }

    public void destroy() {
        this.gms.shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
    }

    private GroupManagementService initializeGMS(String serverName, String clusterName) {
        return (GroupManagementService)GMSFactory.startGMSModule((String)serverName, (String)clusterName, (GroupManagementService.MemberType)GroupManagementService.MemberType.CORE, null);
    }

    private void registerForGroupEvents(GroupManagementService gms) {
        gms.addActionFactory((JoinNotificationActionFactory)new JoinNotificationActionFactoryImpl((CallBack)this));
        gms.addActionFactory((FailureSuspectedActionFactory)new FailureSuspectedActionFactoryImpl((CallBack)this));
        gms.addActionFactory((FailureNotificationActionFactory)new FailureNotificationActionFactoryImpl((CallBack)this));
        gms.addActionFactory((PlannedShutdownActionFactory)new PlannedShutdownActionFactoryImpl((CallBack)this));
        gms.addActionFactory((MessageActionFactory)new MessageActionFactoryImpl((CallBack)this), this.topicName);
    }

    private void joinGMSGroup(String clusterName, GroupManagementService gms) throws GMSException {
        gms.join();
    }

    public void processNotification(Signal signal) {
        try {
            signal.acquire();
            String msg = null;
            if (signal instanceof MessageSignal) {
                msg = new String(((MessageSignal)signal).getMessage());
                this.receivedMessages.offer(msg);
            }
            signal.release();
            if (msg != null && this.bc != null) {
                this.bc.broadcast((Object)msg);
            }
        }
        catch (SignalAcquireException e) {
            logger.log(Level.WARNING, "Exception occured while acquiring signal" + (Object)((Object)e));
        }
        catch (SignalReleaseException e) {
            logger.log(Level.WARNING, "Exception occured while releasing signal" + (Object)((Object)e));
        }
    }

    public BroadcastFilter.BroadcastAction filter(Object o) {
        if (o instanceof String) {
            String message = (String)o;
            try {
                if (!this.receivedMessages.remove(message)) {
                    this.gms.getGroupHandle().sendMessage(this.topicName, message.getBytes());
                }
            }
            catch (GMSException ex) {
                logger.log(Level.WARNING, "", ex);
            }
            return new BroadcastFilter.BroadcastAction((Object)message);
        }
        return new BroadcastFilter.BroadcastAction(o);
    }

    public Broadcaster getBroadcaster() {
        return this.bc;
    }

    public void setBroadcaster(Broadcaster bc) {
        this.bc = bc;
    }
}

