/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.socketio.transport;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.List;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.socketio.transport.SocketIOPacketImpl;
import org.atmosphere.socketio.transport.Transport;
import org.atmosphere.socketio.transport.XHRTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransport
implements Transport {
    private static final Logger logger = LoggerFactory.getLogger(XHRTransport.class);
    public static final String SESSION_KEY = AbstractTransport.class.getName() + ".Session";
    public static final String POST_MESSAGE_RECEIVED = "POST_MESSAGE_RECEIVED";

    protected String extractSessionId(AtmosphereRequest request) {
        String path = request.getPathInfo();
        if (path != null && path.length() > 0 && !"/".equals(path)) {
            String[] parts;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((parts = path.split("/")).length >= 2) {
                String protocol;
                String requestURI = request.getRequestURI();
                parts = requestURI.substring(requestURI.indexOf(protocol = parts[1])).split("/");
                if (parts.length >= 2) {
                    return parts[1] == null ? null : (parts[1].length() == 0 ? null : parts[1]);
                }
                return null;
            }
        }
        return null;
    }

    public static String extractString(Reader reader) {
        String output = null;
        try {
            int n;
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
            output = ((Object)writer).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return output;
    }

    @Override
    public void destroy() {
    }

    protected String decodePostData(String contentType, String data) {
        if (contentType == null || contentType.startsWith("application/x-www-form-urlencoded")) {
            if (data.length() > 2 && data.substring(0, 2).startsWith("d=")) {
                String extractedData = data.substring(3);
                try {
                    extractedData = URLDecoder.decode(extractedData, "UTF-8");
                    if (extractedData != null && extractedData.length() > 2 && extractedData.charAt(0) == '\"' && extractedData.charAt(extractedData.length() - 1) == '\"') {
                        extractedData = extractedData.substring(1, extractedData.length() - 1).replaceAll("\\\\\"", "\"");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    logger.trace("", (Throwable)e);
                }
                return extractedData;
            }
            return data;
        }
        if (contentType.startsWith("text/plain")) {
            return data;
        }
        return data;
    }

    protected boolean isDisconnectRequest(AtmosphereRequest request) {
        if ("GET".equals(request.getMethod())) {
            if (request.getParameterMap().containsKey("disconnect")) {
                return true;
            }
        } else if ("POST".equals(request.getMethod())) {
            try {
                List<SocketIOPacketImpl> list;
                String data = this.decodePostData(request.getContentType(), AbstractTransport.extractString(request.getReader()));
                request.setAttribute(POST_MESSAGE_RECEIVED, (Object)data);
                request.body(data);
                if (data != null && data.length() > 0 && !(list = SocketIOPacketImpl.parse(data)).isEmpty() && SocketIOPacketImpl.PacketType.DISCONNECT.equals((Object)list.get(0).getFrameType())) {
                    return true;
                }
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
        }
        return false;
    }
}

