/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.socketio.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.socketio.SocketIOClosedException;
import org.atmosphere.socketio.SocketIOException;
import org.atmosphere.socketio.SocketIOPacket;
import org.atmosphere.socketio.SocketIOSession;
import org.atmosphere.socketio.SocketIOSessionFactory;
import org.atmosphere.socketio.SocketIOSessionOutbound;
import org.atmosphere.socketio.cpr.SocketIOAtmosphereHandler;
import org.atmosphere.socketio.transport.AbstractTransport;
import org.atmosphere.socketio.transport.DisconnectReason;
import org.atmosphere.socketio.transport.SocketIOPacketImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XHRTransport
extends AbstractTransport {
    private static final Logger logger = LoggerFactory.getLogger(XHRTransport.class);
    private final int bufferSize;

    public XHRTransport(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    protected abstract XHRSessionHelper createHelper(SocketIOSession var1);

    protected SocketIOSession connect(SocketIOSession session, AtmosphereResourceImpl resource, AtmosphereHandler atmosphereHandler, SocketIOSessionFactory sessionFactory) throws IOException {
        if (session == null) {
            session = sessionFactory.createSession(resource, atmosphereHandler);
            resource.getRequest().setAttribute(SocketIOAtmosphereHandler.SOCKETIO_SESSION_ID, (Object)session.getSessionId());
        }
        XHRSessionHelper handler = this.createHelper(session);
        handler.connect(resource);
        return session;
    }

    protected SocketIOSession connect(AtmosphereResourceImpl resource, AtmosphereHandler atmosphereHandler, SocketIOSessionFactory sessionFactory) throws IOException {
        return this.connect(null, resource, atmosphereHandler, sessionFactory);
    }

    @Override
    public Action handle(AtmosphereResourceImpl resource, AtmosphereHandler atmosphereHandler, SocketIOSessionFactory sessionFactory) throws IOException {
        AtmosphereRequest request = resource.getRequest();
        AtmosphereResponse response = resource.getResponse();
        Object obj = request.getAttribute(SESSION_KEY);
        SocketIOSession session = null;
        String sessionId = null;
        if (obj != null) {
            session = (SocketIOSession)obj;
        } else {
            sessionId = this.extractSessionId(request);
            if (sessionId != null && sessionId.length() > 0) {
                session = sessionFactory.getSession(sessionId);
            }
        }
        boolean isDisconnectRequest = this.isDisconnectRequest(request);
        Action action = Action.CONTINUE;
        if (session != null) {
            SocketIOSessionOutbound handler = session.getTransportHandler();
            if (handler != null) {
                if (!isDisconnectRequest) {
                    action = handler.handle(request, response, session);
                } else {
                    handler.disconnect();
                    response.setStatus(200);
                }
            } else if (!isDisconnectRequest) {
                if ((session = this.connect(session, resource, atmosphereHandler, sessionFactory)) == null) {
                    response.sendError(503);
                }
            } else {
                response.setStatus(200);
            }
        } else if (sessionId != null && sessionId.length() > 0) {
            logger.trace("Session NULL but not sessionId : wrong session id or the connection was DISCONNECTED");
            response.sendError(400);
        } else if ("GET".equals(request.getMethod())) {
            session = this.connect(resource, atmosphereHandler, sessionFactory);
            if (session == null) {
                response.sendError(503);
            }
        } else {
            response.sendError(400);
        }
        return action;
    }

    protected abstract class XHRSessionHelper
    implements SocketIOSessionOutbound {
        protected final SocketIOSession session;
        private volatile boolean is_open = false;
        private final boolean isStreamingConnection;

        XHRSessionHelper(SocketIOSession session, boolean isConnectionPersistant) {
            this.session = session;
            this.isStreamingConnection = isConnectionPersistant;
        }

        protected abstract void startSend(AtmosphereResponse var1) throws IOException;

        protected abstract void writeData(AtmosphereResponse var1, String var2) throws IOException;

        protected abstract void finishSend(AtmosphereResponse var1) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disconnect() {
            XHRSessionHelper xHRSessionHelper = this;
            synchronized (xHRSessionHelper) {
                this.session.onDisconnect(DisconnectReason.DISCONNECT);
                this.abort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            XHRSessionHelper xHRSessionHelper = this;
            synchronized (xHRSessionHelper) {
                this.session.startClose();
            }
        }

        @Override
        public void sendMessage(SocketIOPacket packet) throws SocketIOException {
            if (packet != null) {
                this.sendMessage(((Object)packet).toString());
            }
        }

        @Override
        public void sendMessage(List<SocketIOPacketImpl> messages) throws SocketIOException {
            if (messages != null) {
                block5: for (SocketIOPacketImpl msg : messages) {
                    switch (msg.getFrameType()) {
                        case MESSAGE: 
                        case JSON: 
                        case EVENT: 
                        case ACK: 
                        case ERROR: {
                            msg.setPadding(messages.size() > 1);
                            try {
                                this.sendMessage(msg.toString());
                            }
                            catch (Exception e) {
                                AtmosphereResourceImpl resource = this.session.getAtmosphereResourceImpl();
                                if (resource == null || !DefaultBroadcaster.class.isAssignableFrom(resource.getBroadcaster().getClass())) continue block5;
                                ((DefaultBroadcaster)DefaultBroadcaster.class.cast(resource.getBroadcaster())).getBroadcasterConfig().getBroadcasterCache().addToCache(resource.getBroadcaster().getID(), (AtmosphereResource)resource, (Object)msg);
                            }
                            break;
                        }
                        default: {
                            logger.error("Unknown SocketIOEvent msg = " + msg);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendMessage(String message) throws SocketIOException {
            logger.trace("Session[" + this.session.getSessionId() + "]: " + "sendMessage(String): " + message);
            XHRSessionHelper xHRSessionHelper = this;
            synchronized (xHRSessionHelper) {
                if (this.is_open) {
                    AtmosphereResourceImpl resource = this.session.getAtmosphereResourceImpl();
                    logger.trace("Session[" + this.session.getSessionId() + "]: " + resource.getRequest().getMethod() + "sendMessage");
                    try {
                        this.writeData(resource.getResponse(), message);
                    }
                    catch (Exception e) {
                        if (!resource.isCancelled()) {
                            logger.trace("calling from " + this.getClass().getName() + " : " + "sendMessage ON FORCE UN RESUME");
                            try {
                                this.finishSend(resource.getResponse());
                            }
                            catch (IOException ex) {
                                logger.trace("", (Throwable)ex);
                            }
                            resource.resume();
                        }
                        throw new SocketIOException(e);
                    }
                    if (!this.isStreamingConnection) {
                        try {
                            this.finishSend(resource.getResponse());
                        }
                        catch (IOException e) {
                            logger.trace("", (Throwable)e);
                        }
                        resource.resume();
                    } else {
                        logger.trace("calling from " + this.getClass().getName() + " : " + "sendMessage");
                        this.session.startHeartbeatTimer();
                    }
                } else {
                    logger.trace("calling from " + this.getClass().getName() + " : " + "SocketIOClosedException sendMessage");
                    throw new SocketIOClosedException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Action handle(AtmosphereRequest request, final AtmosphereResponse response, SocketIOSession session) throws IOException {
            logger.trace("Session id[" + session.getSessionId() + "] method=" + request.getMethod() + "  response HashCode=" + response.hashCode());
            AtmosphereResourceImpl resource = (AtmosphereResourceImpl)request.getAttribute(ApplicationConfig.ATMOSPHERE_RESOURCE);
            if ("GET".equals(request.getMethod())) {
                XHRSessionHelper xHRSessionHelper = this;
                synchronized (xHRSessionHelper) {
                    if (!this.is_open) {
                        response.sendError(404);
                    } else if (!this.isStreamingConnection) {
                        if (resource != null) {
                            resource.getRequest().setAttribute(SocketIOAtmosphereHandler.SOCKETIO_SESSION_ID, (Object)session.getSessionId());
                            resource.getRequest().setAttribute("SocketIOSessionOutbound", (Object)session.getTransportHandler());
                            session.setAtmosphereResourceImpl(resource);
                            resource.addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceEventListenerAdapter(){

                                public void onResume(AtmosphereResourceEvent event) {
                                    if (event.isResumedOnTimeout()) {
                                        try {
                                            event.getResource().write((OutputStream)response.getOutputStream(), (Object)new SocketIOPacketImpl(SocketIOPacketImpl.PacketType.NOOP).toString());
                                        }
                                        catch (IOException e) {
                                            logger.trace("", (Throwable)e);
                                        }
                                    }
                                }
                            });
                            session.clearTimeoutTimer();
                            request.setAttribute(AbstractTransport.SESSION_KEY, (Object)session);
                            StringBuilder data = new StringBuilder();
                            if (DefaultBroadcaster.class.isAssignableFrom(resource.getBroadcaster().getClass())) {
                                List cachedMessages = ((DefaultBroadcaster)DefaultBroadcaster.class.cast(resource.getBroadcaster())).getBroadcasterConfig().getBroadcasterCache().retrieveFromCache(resource.getBroadcaster().getID(), (AtmosphereResource)resource);
                                if (cachedMessages != null) {
                                    if (cachedMessages.size() > 1) {
                                        for (Object object : cachedMessages) {
                                            String msg = object.toString();
                                            data.append('\ufffd').append(msg.length()).append('\ufffd').append(msg);
                                        }
                                    } else if (cachedMessages.size() == 1) {
                                        data.append(cachedMessages.get(0));
                                    }
                                }
                                if (data.toString().length() > 0) {
                                    this.startSend(response);
                                    this.writeData(response, data.toString());
                                    this.finishSend(response);
                                    resource.resume();
                                }
                            }
                            resource.disableSuspend(false);
                            resource.suspend(session.getRequestSuspendTime(), false);
                            resource.disableSuspend(true);
                        }
                    } else {
                        response.sendError(404);
                    }
                }
            }
            if ("POST".equals(request.getMethod())) {
                if (this.is_open) {
                    int size = request.getContentLength();
                    if (size == 0) {
                        response.sendError(400);
                    } else {
                        String data = (String)request.getAttribute("POST_MESSAGE_RECEIVED");
                        if (data == null) {
                            data = XHRTransport.this.decodePostData(request.getContentType(), AbstractTransport.extractString(request.getReader()));
                        }
                        if (data != null && data.length() > 0) {
                            List<SocketIOPacketImpl> list = SocketIOPacketImpl.parse(data);
                            SocketIOSession socketIOSession = session;
                            synchronized (socketIOSession) {
                                for (SocketIOPacketImpl msg : list) {
                                    if (msg.getFrameType().equals((Object)SocketIOPacketImpl.PacketType.EVENT)) {
                                        session.onMessage(session.getAtmosphereResourceImpl(), session.getTransportHandler(), msg.getData());
                                        this.writeData(response, "1");
                                        continue;
                                    }
                                    this.writeData(response, "1");
                                }
                            }
                        }
                    }
                    resource.resume();
                }
            } else {
                response.sendError(400);
            }
            return Action.CANCELLED;
        }

        protected abstract void customConnect(AtmosphereRequest var1, AtmosphereResponse var2) throws IOException;

        public void connect(AtmosphereResourceImpl resource) throws IOException {
            AtmosphereRequest request = resource.getRequest();
            AtmosphereResponse response = resource.getResponse();
            request.setAttribute(AbstractTransport.SESSION_KEY, (Object)this.session);
            response.setBufferSize(XHRTransport.this.bufferSize);
            this.customConnect(request, response);
            this.is_open = true;
            this.session.onConnect(resource, this);
            this.finishSend(response);
            if (this.isStreamingConnection) {
                resource.suspend();
            }
        }

        @Override
        public void abort() {
            logger.error("calling from " + this.getClass().getName() + " : " + "abort");
            this.session.clearHeartbeatTimer();
            this.session.clearTimeoutTimer();
            this.is_open = false;
            this.session.onShutdown();
            this.session.getAtmosphereResourceImpl().resume();
        }

        @Override
        public String getSessionId() {
            return this.session.getSessionId();
        }
    }
}

