/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.socketio;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class SocketIOSessionActivityMonitor {
    protected ScheduledExecutorService executor = null;
    protected ScheduledFuture<Boolean> future = null;
    protected long delay = 0L;
    protected TimeUnit timeUnit = TimeUnit.MILLISECONDS;

    public SocketIOSessionActivityMonitor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public abstract Callable<Boolean> getCommand();

    public void start() {
        this.future = this.executor.schedule(this.getCommand(), this.delay, this.timeUnit);
    }

    public void cancel() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }
}

