/*
 * Copyright 2012 Sebastien Dionne
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.atmosphere.socketio;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;

/**
 * @author Sebastien Dionne  : sebastien.dionne@gmail.com
 */
public class TimeoutSessionMonitor extends SocketIOSessionActivityMonitor {

    private SocketIOSession session = null;

    public TimeoutSessionMonitor(SocketIOSession session, ScheduledExecutorService executor) {
        super(executor);
        this.session = session;
    }

    @Override
    public Callable<Boolean> getCommand() {
        return new Callable<Boolean>() {
            @Override
            public Boolean call() throws Exception {
                session.timeout();
                return true;
            }
        };
    }

}
