/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.socketio.cache;

import java.util.List;
import org.atmosphere.cache.UUIDBroadcasterCache;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.BroadcasterCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketIOBroadcasterCache
extends UUIDBroadcasterCache {
    private static final Logger logger = LoggerFactory.getLogger(SocketIOBroadcasterCache.class);

    public UUIDBroadcasterCache.CacheMessage addCacheCandidate(String broadcasterID, AtmosphereResource resource, Object msg) {
        logger.trace("addCacheCandidate broadcasterID[" + broadcasterID + "]  AtmosphereResource UUID = " + "[" + this.uuid(resource) + "] message=" + msg);
        return super.addCacheCandidate(broadcasterID, resource, msg);
    }

    public void addToCache(String broadcasterID, AtmosphereResource resource, BroadcasterCache.Message msg) {
        logger.trace("addToCache broadcasterID[" + broadcasterID + "]  AtmosphereResource UUID = " + "[" + this.uuid(resource) + "] message=" + msg.message);
        super.addToCache(broadcasterID, resource, msg);
    }

    public void clearCache(String broadcasterID, AtmosphereResourceImpl resource, UUIDBroadcasterCache.CacheMessage message) {
        logger.trace("clearCache broadcasterID[" + broadcasterID + "]  AtmosphereResource UUID = " + "[" + this.uuid((AtmosphereResource)resource) + "] message=" + message);
        super.clearCache(broadcasterID, resource, message);
    }

    public List<Object> retrieveFromCache(String broadcasterID, AtmosphereResource resource) {
        logger.trace("retrieveFromCache broadcasterID[" + broadcasterID + "]  AtmosphereResource UUID = " + "[" + this.uuid(resource) + "]");
        return super.retrieveFromCache(broadcasterID, resource);
    }

    protected String uuid(AtmosphereResource r) {
        if (r == null) {
            return null;
        }
        String uuid = (String)r.getRequest().getAttribute(ApplicationConfig.SUSPENDED_ATMOSPHERE_RESOURCE_UUID);
        if (uuid == null) {
            uuid = r.uuid();
        }
        return uuid;
    }
}

