/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.socketio.cpr;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.socketio.SocketIOSessionOutbound;
import org.atmosphere.socketio.transport.DisconnectReason;
import org.atmosphere.socketio.transport.SocketIOPacketImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SocketIOAtmosphereHandler
implements AtmosphereHandler {
    private final Logger logger = LoggerFactory.getLogger(SocketIOAtmosphereHandler.class);
    public static final String SOCKETIO_SESSION_OUTBOUND = "SocketIOSessionOutbound";
    public static final String SOCKETIO_SESSION_ID = SocketIOAtmosphereHandler.class.getPackage().getName() + ".sessionid";

    public abstract void onConnect(AtmosphereResource var1, SocketIOSessionOutbound var2) throws IOException;

    public abstract void onDisconnect(AtmosphereResource var1, SocketIOSessionOutbound var2, DisconnectReason var3);

    public abstract void onMessage(AtmosphereResource var1, SocketIOSessionOutbound var2, String var3);

    public final void onRequest(AtmosphereResource event) throws IOException {
        this.logger.trace("onRequest");
    }

    public final void onStateChange(AtmosphereResourceEvent event) throws IOException {
        if (event.isResuming() || event.isResumedOnTimeout()) {
            return;
        }
        AtmosphereRequest request = event.getResource().getRequest();
        this.logger.trace("onStateChange on SessionID=" + request.getAttribute(SOCKETIO_SESSION_ID) + "  Method=" + request.getMethod());
        SocketIOSessionOutbound outbound = (SocketIOSessionOutbound)request.getAttribute(SOCKETIO_SESSION_OUTBOUND);
        if (outbound != null && event.getMessage() != null) {
            try {
                if (event.getMessage().getClass().isArray()) {
                    List<Object> list = Arrays.asList(event.getMessage());
                    for (Object object : list) {
                        List<SocketIOPacketImpl> messages = SocketIOPacketImpl.parse(object.toString());
                        outbound.sendMessage(messages);
                    }
                } else if (event.getMessage() instanceof List) {
                    List list = (List)List.class.cast(event.getMessage());
                    for (Object object : list) {
                        List<SocketIOPacketImpl> messages = SocketIOPacketImpl.parse(object.toString());
                        outbound.sendMessage(messages);
                    }
                } else if (event.getMessage() instanceof String) {
                    this.logger.trace("onStateChange Sending message on resume : message = " + event.getMessage().toString());
                    List<SocketIOPacketImpl> messages = SocketIOPacketImpl.parse(event.getMessage().toString());
                    outbound.sendMessage(messages);
                }
            }
            catch (Exception e) {
                this.logger.warn("", (Throwable)e);
                outbound.disconnect();
            }
        }
    }

    public void destroy() {
        this.logger.trace("destroy");
    }
}

