/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.socketio.transport;

import java.io.IOException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.socketio.SocketIOSession;
import org.atmosphere.socketio.SocketIOSessionFactory;
import org.atmosphere.socketio.cpr.SocketIOAtmosphereHandler;
import org.atmosphere.socketio.transport.SocketIOPacketImpl;
import org.atmosphere.socketio.transport.XHRTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPPollingTransport
extends XHRTransport {
    public static final String TRANSPORT_NAME = "jsonp-polling";
    private static final Logger logger = LoggerFactory.getLogger(JSONPPollingTransport.class);
    private long jsonpIndex = 0L;

    public JSONPPollingTransport(int bufferSize) {
        super(bufferSize);
    }

    @Override
    public String getName() {
        return TRANSPORT_NAME;
    }

    @Override
    protected XHRPollingSessionHelper createHelper(SocketIOSession session) {
        return new XHRPollingSessionHelper(session);
    }

    @Override
    protected SocketIOSession connect(SocketIOSession session, AtmosphereResourceImpl resource, AtmosphereHandler atmosphereHandler, SocketIOSessionFactory sessionFactory) throws IOException {
        if (session == null) {
            session = sessionFactory.createSession(resource, atmosphereHandler);
            resource.getRequest().setAttribute(SocketIOAtmosphereHandler.SOCKETIO_SESSION_ID, (Object)session.getSessionId());
        }
        XHRPollingSessionHelper handler = this.createHelper(session);
        handler.connect(resource);
        return session;
    }

    @Override
    protected SocketIOSession connect(AtmosphereResourceImpl resource, AtmosphereHandler atmosphereHandler, SocketIOSessionFactory sessionFactory) throws IOException {
        return this.connect(null, resource, atmosphereHandler, sessionFactory);
    }

    protected class XHRPollingSessionHelper
    extends XHRTransport.XHRSessionHelper {
        XHRPollingSessionHelper(SocketIOSession session) {
            super(JSONPPollingTransport.this, session, false);
        }

        @Override
        protected void startSend(AtmosphereResponse response) throws IOException {
        }

        @Override
        protected void writeData(AtmosphereResponse response, String data) throws IOException {
            logger.trace("calling from " + this.getClass().getName() + " : " + "writeData(string) = " + data);
            response.setContentType("text/javascript; charset=UTF-8");
            response.getOutputStream().print("io.j[" + JSONPPollingTransport.this.jsonpIndex + "](\"" + StringEscapeUtils.escapeEcmaScript((String)data) + "\");");
            logger.trace("WRITE SUCCESS calling from " + this.getClass().getName() + " : " + "writeData(string) = " + data);
        }

        @Override
        protected void finishSend(AtmosphereResponse response) throws IOException {
            response.flushBuffer();
        }

        @Override
        protected void customConnect(AtmosphereRequest request, AtmosphereResponse response) throws IOException {
            if (request.getParameter("i") != null) {
                JSONPPollingTransport.this.jsonpIndex = Integer.parseInt(request.getParameter("i"));
            } else {
                JSONPPollingTransport.this.jsonpIndex = 0L;
            }
            this.writeData(response, new SocketIOPacketImpl(SocketIOPacketImpl.PacketType.CONNECT).toString());
        }
    }
}

