/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.socketio.cpr;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.config.service.AtmosphereInterceptorService;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsyncIOWriterAdapter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.socketio.SocketIOSession;
import org.atmosphere.socketio.SocketIOSessionManager;
import org.atmosphere.socketio.SocketIOSessionOutbound;
import org.atmosphere.socketio.cpr.SocketIOAtmosphereHandler;
import org.atmosphere.socketio.transport.JSONPPollingTransport;
import org.atmosphere.socketio.transport.SocketIOPacketImpl;
import org.atmosphere.socketio.transport.SocketIOSessionManagerImpl;
import org.atmosphere.socketio.transport.Transport;
import org.atmosphere.socketio.transport.WebSocketTransport;
import org.atmosphere.socketio.transport.XHRPollingTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereInterceptorService
public class SocketIOAtmosphereInterceptor
implements AtmosphereInterceptor {
    public static final String SOCKETIO_PACKET = SocketIOSessionManagerImpl.SocketIOProtocol.class.getName();
    private static final Logger logger = LoggerFactory.getLogger(SocketIOAtmosphereInterceptor.class);
    private static final int BUFFER_SIZE_DEFAULT = 8192;
    private final SocketIOSessionManager sessionManager = new SocketIOSessionManagerImpl();
    private long heartbeatInterval = 25000L;
    private long timeout = 60000L;
    private long heartbeatTimeout = 60000L;
    private static int suspendTime = 20000;
    private final Map<String, Transport> transports = new HashMap<String, Transport>();
    private String availableTransports;
    public static final String BUFFER_SIZE_INIT_PARAM = "socketio-bufferSize";
    public static final String SOCKETIO_TRANSPORT = "socketio-transport";
    public static final String SOCKETIO_TIMEOUT = "socketio-timeout";
    public static final String SOCKETIO_HEARTBEAT = "socketio-heartbeat";
    public static final String SOCKETIO_HEARTBEAT_TIMEOUT = "socketio-heartbeat-timeout";
    public static final String SOCKETIO_SUSPEND = "socketio-suspendTime";

    private SocketIOSessionManager getSessionManager(String version) {
        if (version.equals("1")) {
            return this.sessionManager;
        }
        return null;
    }

    public String toString() {
        return "SocketIO-Support";
    }

    public Action inspect(AtmosphereResource r) {
        final AtmosphereRequest request = r.getRequest();
        AtmosphereResponse response = r.getResponse();
        AtmosphereHandler atmosphereHandler = r.getAtmosphereHandler();
        try {
            Transport transport;
            String path = request.getPathInfo();
            if (path == null || path.length() == 0 || "/".equals(path)) {
                logger.debug("Not a SocketIO client");
                return Action.CONTINUE;
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            String[] parts = path.split("/");
            String protocol = null;
            String version = null;
            if (parts.length == 0) {
                logger.debug("Not a SocketIO protocol supported");
                return Action.CONTINUE;
            }
            if (parts.length == 1) {
                if (parts[0].length() == 1) {
                    version = parts[0];
                    if (!Character.isDigit(version.charAt(0))) {
                        version = null;
                    }
                } else {
                    protocol = parts[0];
                }
            } else {
                version = parts[0];
                protocol = parts[1];
                if (!Character.isDigit(version.charAt(0))) {
                    version = null;
                    protocol = null;
                }
            }
            if (protocol == null && version == null) {
                logger.debug("Not a SocketIO protocol supported");
                return Action.CONTINUE;
            }
            if (protocol == null && version != null) {
                response.setStatus(200);
                response.setContentType("plain/text");
                SocketIOSession session = this.getSessionManager(version).createSession((AtmosphereResourceImpl)r, atmosphereHandler);
                response.getWriter().print(session.getSessionId() + ":" + this.heartbeatTimeout / 1000L + ":" + this.timeout / 1000L + ":" + this.availableTransports);
                return Action.CANCELLED;
            }
            if (protocol != null && version == null) {
                version = "0";
            }
            if ((transport = this.transports.get(protocol + "-" + version)) != null) {
                if (!SocketIOAtmosphereHandler.class.isAssignableFrom(atmosphereHandler.getClass())) {
                    response.asyncIOWriter((AsyncIOWriter)new AsyncIOWriterAdapter(){

                        public AsyncIOWriter write(AtmosphereResponse r, String data) throws IOException {
                            String msg;
                            SocketIOSessionOutbound outbound = (SocketIOSessionOutbound)request.getAttribute("SocketIOSessionOutbound");
                            SocketIOSessionManagerImpl.SocketIOProtocol p = (SocketIOSessionManagerImpl.SocketIOProtocol)r.request().getAttribute(SOCKETIO_PACKET);
                            String string = msg = p == null ? data : SocketIOSessionManagerImpl.mapper.writeValueAsString((Object)p.clearArgs().addArgs(data));
                            if (outbound != null) {
                                outbound.sendMessage(new SocketIOPacketImpl(SocketIOPacketImpl.PacketType.EVENT, msg));
                            } else {
                                r.getResponse().getOutputStream().write(msg.getBytes(r.getCharacterEncoding()));
                            }
                            return this;
                        }

                        public AsyncIOWriter write(AtmosphereResponse r, byte[] data) throws IOException {
                            SocketIOSessionManagerImpl.SocketIOProtocol p = (SocketIOSessionManagerImpl.SocketIOProtocol)r.request().getAttribute(SOCKETIO_PACKET);
                            if (p == null) {
                                r.getResponse().getOutputStream().write(data);
                            } else {
                                this.write(r, new String(data, r.request().getCharacterEncoding()));
                            }
                            return this;
                        }

                        public AsyncIOWriter write(AtmosphereResponse r, byte[] data, int offset, int length) throws IOException {
                            SocketIOSessionManagerImpl.SocketIOProtocol p = (SocketIOSessionManagerImpl.SocketIOProtocol)r.request().getAttribute(SOCKETIO_PACKET);
                            if (p == null) {
                                r.getResponse().getOutputStream().write(data, offset, length);
                            } else {
                                this.write(r, new String(data, offset, length, r.request().getCharacterEncoding()));
                            }
                            return this;
                        }

                        public AsyncIOWriter flush(AtmosphereResponse r) throws IOException {
                            try {
                                r.getResponse().getOutputStream().flush();
                            }
                            catch (IllegalStateException ex) {
                                r.getResponse().getWriter().flush();
                            }
                            return this;
                        }

                        public AsyncIOWriter writeError(AtmosphereResponse r, int errorCode, String message) throws IOException {
                            ((HttpServletResponse)r.getResponse()).sendError(errorCode, message);
                            return this;
                        }
                    });
                }
                transport.handle((AtmosphereResourceImpl)r, atmosphereHandler, this.getSessionManager(version));
            } else {
                logger.error("Protocol not supported : " + protocol);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return Action.CONTINUE;
    }

    public void postInspect(AtmosphereResource r) {
    }

    public void destroy() {
    }

    public void configure(AtmosphereConfig config) {
        String suspendWebXML;
        String heartbeatTimeoutWebXML;
        String heartbeatWebXML;
        String timeoutWebXML;
        String s;
        this.availableTransports = s = config.getInitParameter(SOCKETIO_TRANSPORT);
        if (this.availableTransports == null) {
            this.availableTransports = "websocket,xhr-polling,jsonp-polling";
        }
        if ((timeoutWebXML = config.getInitParameter(SOCKETIO_TIMEOUT)) != null) {
            this.timeout = Integer.parseInt(timeoutWebXML);
        }
        if ((heartbeatWebXML = config.getInitParameter(SOCKETIO_HEARTBEAT)) != null) {
            this.heartbeatInterval = Integer.parseInt(heartbeatWebXML);
        }
        if ((heartbeatTimeoutWebXML = config.getInitParameter(SOCKETIO_HEARTBEAT_TIMEOUT)) != null) {
            this.heartbeatTimeout = Integer.parseInt(heartbeatTimeoutWebXML);
        }
        if ((suspendWebXML = config.getInitParameter(SOCKETIO_SUSPEND)) != null) {
            suspendTime = Integer.parseInt(suspendWebXML);
        }
        WebSocketTransport websocketTransport1 = new WebSocketTransport();
        XHRPollingTransport xhrPollingTransport1 = new XHRPollingTransport(8192);
        JSONPPollingTransport jsonpPollingTransport1 = new JSONPPollingTransport(8192);
        this.transports.put(websocketTransport1.getName() + "-1", websocketTransport1);
        this.transports.put(xhrPollingTransport1.getName() + "-1", xhrPollingTransport1);
        this.transports.put(jsonpPollingTransport1.getName() + "-1", jsonpPollingTransport1);
        this.sessionManager.setTimeout(this.timeout);
        this.sessionManager.setHeartbeatInterval(this.heartbeatInterval);
        this.sessionManager.setRequestSuspendTime(suspendTime);
    }
}

