/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.socketio.transport;

import java.util.ArrayList;
import java.util.List;
import org.atmosphere.socketio.SocketIOException;
import org.atmosphere.socketio.SocketIOPacket;

public class SocketIOPacketImpl
implements SocketIOPacket {
    public static final char SOCKETIO_MSG_DELIMITER = '\ufffd';
    public static final String POST_RESPONSE = "1";
    private final PacketType packetType;
    private final String id;
    private final String endpoint;
    private final String data;
    private boolean padding = false;

    public SocketIOPacketImpl(PacketType frameType) {
        this(frameType, null, null, null, false);
    }

    public SocketIOPacketImpl(PacketType frameType, String data) {
        this(frameType, null, null, data, false);
    }

    public SocketIOPacketImpl(PacketType frameType, String data, boolean padding) {
        this(frameType, null, null, data, padding);
    }

    public SocketIOPacketImpl(PacketType frameType, String id, String endpoint, String data) {
        this(frameType, id, endpoint, data, false);
    }

    public SocketIOPacketImpl(PacketType frameType, String id, String endpoint, String data, boolean padding) {
        this.packetType = frameType;
        this.id = id;
        this.endpoint = endpoint;
        this.data = data;
        this.padding = padding;
    }

    public PacketType getFrameType() {
        return this.packetType;
    }

    public String getData() {
        return this.data;
    }

    public void setPadding(boolean padding) {
        this.padding = padding;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.packetType.value).append(":");
        if (this.id != null) {
            sb.append(this.id);
        }
        sb.append(":");
        if (this.endpoint != null) {
            sb.append(this.endpoint);
        }
        if (this.data != null) {
            sb.append(":");
            sb.append(this.data);
        }
        String msg = sb.toString();
        if (this.padding) {
            sb = new StringBuilder();
            sb.append('\ufffd').append(msg.length()).append('\ufffd').append(msg);
            msg = sb.toString();
        }
        return msg;
    }

    private static SocketIOPacketImpl parse2(String data) throws SocketIOException {
        try {
            String[] array = data.split(":");
            if (array.length < 1) {
                System.err.println("Message invalide=" + data);
                return null;
            }
            String type = null;
            String id = null;
            String endpoint = null;
            String message = null;
            if (array.length == 1) {
                type = array[0];
            } else if (array.length == 2) {
                type = array[0];
                id = array[1];
            } else if (array.length == 3) {
                type = array[0];
                id = array[1];
                endpoint = array[2];
            } else {
                type = array[0];
                id = array[1];
                endpoint = array[2];
                int start = data.indexOf(":");
                ++start;
                start = data.indexOf(":", start);
                ++start;
                if ((start = data.indexOf(":", start)) > -1) {
                    message = data.substring(start + 1);
                }
            }
            return new SocketIOPacketImpl(PacketType.fromInt(Integer.parseInt(type)), id, endpoint, message);
        }
        catch (Exception e) {
            throw new SocketIOException("Invalid message = " + data, e);
        }
    }

    public static List<SocketIOPacketImpl> parse(String data) throws SocketIOException {
        ArrayList<SocketIOPacketImpl> messages = new ArrayList<SocketIOPacketImpl>();
        if (data == null || data.length() == 0) {
            return messages;
        }
        try {
            if (data.charAt(0) == '\ufffd') {
                int size = data.length();
                int previousDelimiterIndex = 1;
                int nextDelimiterIndex = -1;
                for (int i = 1; i < size; ++i) {
                    while (i < size) {
                        if (data.charAt(i) == '\ufffd') {
                            nextDelimiterIndex = i;
                            break;
                        }
                        ++i;
                    }
                    if (nextDelimiterIndex <= previousDelimiterIndex) continue;
                    int length = Integer.parseInt(data.substring(previousDelimiterIndex, nextDelimiterIndex));
                    i = ++nextDelimiterIndex + length;
                    previousDelimiterIndex = i + 1;
                    SocketIOPacketImpl msg = SocketIOPacketImpl.parse2(data.substring(nextDelimiterIndex, i));
                    if (msg == null) continue;
                    messages.add(msg);
                }
            } else {
                SocketIOPacketImpl msg = SocketIOPacketImpl.parse2(data);
                if (msg != null) {
                    messages.add(msg);
                }
            }
            return messages;
        }
        catch (Exception e) {
            throw new SocketIOException("Invalid message=" + data, e);
        }
    }

    public static enum PacketType {
        UNKNOWN(-1),
        DISCONNECT(0),
        CONNECT(1),
        HEARTBEAT(2),
        MESSAGE(3),
        JSON(4),
        EVENT(5),
        ACK(6),
        ERROR(7),
        NOOP(8);

        private int value;

        private PacketType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static PacketType fromInt(int val) {
            switch (val) {
                case 0: {
                    return DISCONNECT;
                }
                case 1: {
                    return CONNECT;
                }
                case 2: {
                    return HEARTBEAT;
                }
                case 3: {
                    return MESSAGE;
                }
                case 4: {
                    return JSON;
                }
                case 5: {
                    return EVENT;
                }
                case 6: {
                    return ACK;
                }
                case 7: {
                    return ERROR;
                }
                case 8: {
                    return NOOP;
                }
            }
            return UNKNOWN;
        }
    }
}

