/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.socketio.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.socketio.HeartBeatSessionMonitor;
import org.atmosphere.socketio.SocketIOException;
import org.atmosphere.socketio.SocketIOSession;
import org.atmosphere.socketio.SocketIOSessionFactory;
import org.atmosphere.socketio.SocketIOSessionManager;
import org.atmosphere.socketio.SocketIOSessionOutbound;
import org.atmosphere.socketio.TimeoutSessionMonitor;
import org.atmosphere.socketio.cpr.SocketIOAtmosphereHandler;
import org.atmosphere.socketio.transport.DisconnectReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketIOSessionManagerImpl
implements SocketIOSessionManager,
SocketIOSessionFactory {
    private static final Logger logger = LoggerFactory.getLogger(SocketIOSessionManagerImpl.class);
    private static final int SESSION_ID_LENGTH = 20;
    private static Random random = new SecureRandom();
    private final ConcurrentMap<String, SocketIOSession> socketIOSessions = new ConcurrentHashMap<String, SocketIOSession>();
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private long heartbeatInterval = 25000L;
    private long timeout = 60000L;
    private long requestSuspendTime = 20000L;
    public static final ObjectMapper mapper = new ObjectMapper();

    private static String generateRandomString(int length) {
        byte[] bytes = new byte[16];
        StringBuilder buffer = new StringBuilder(length);
        int resultLenBytes = 0;
        while (resultLenBytes < length) {
            random.nextBytes(bytes);
            for (int j = 0; j < bytes.length && resultLenBytes < length; ++resultLenBytes, ++j) {
                byte b1 = (byte)((bytes[j] & 0xF0) >> 4);
                byte b2 = (byte)(bytes[j] & 0xF);
                if (b1 < 10) {
                    buffer.append((char)(48 + b1));
                } else {
                    buffer.append((char)(65 + (b1 - 10)));
                }
                if (b2 < 10) {
                    buffer.append((char)(48 + b2));
                    continue;
                }
                buffer.append((char)(65 + (b2 - 10)));
            }
        }
        return buffer.toString();
    }

    private String generateSessionId() {
        return SocketIOSessionManagerImpl.generateRandomString(20);
    }

    @Override
    public SocketIOSession createSession(AtmosphereResourceImpl resource, AtmosphereHandler inbound) {
        SessionImpl impl = new SessionImpl(this.generateSessionId(), resource, inbound, this.getTimeout(), this.getHeartbeatInterval(), this.getRequestSuspendTime());
        this.socketIOSessions.put(impl.getSessionId(), impl);
        return impl;
    }

    @Override
    public SocketIOSession getSession(String sessionId) {
        return (SocketIOSession)this.socketIOSessions.get(sessionId);
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setHeartbeatInterval(long interval) {
        this.heartbeatInterval = interval;
    }

    @Override
    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @Override
    public void setRequestSuspendTime(long suspendTime) {
        this.requestSuspendTime = suspendTime;
    }

    @Override
    public long getRequestSuspendTime() {
        return this.requestSuspendTime;
    }

    static /* synthetic */ ScheduledExecutorService access$000(SocketIOSessionManagerImpl x0) {
        return x0.executor;
    }

    public static final class SocketIOProtocol {
        public String name;
        public Collection<String> args;

        public Collection<String> getArgs() {
            return this.args;
        }

        public void setArgs(Collection<String> args) {
            this.args = args;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public SocketIOProtocol addArgs(String s) {
            if (this.args == null) {
                this.args = new LinkedList<String>();
            }
            this.args.add(s);
            return this;
        }

        public SocketIOProtocol clearArgs() {
            this.args.clear();
            return this;
        }

        public String toString() {
            return "SocketIOProtocol [name=" + this.name + ", args=" + this.args + "]";
        }
    }

    public static enum ConnectionState {
        UNKNOWN(-1),
        CONNECTING(0),
        CONNECTED(1),
        CLOSING(2),
        CLOSED(3);

        private int value;

        private ConnectionState(int v) {
            this.value = v;
        }

        public int value() {
            return this.value;
        }

        public static ConnectionState fromInt(int val) {
            switch (val) {
                case 0: {
                    return CONNECTING;
                }
                case 1: {
                    return CONNECTED;
                }
                case 2: {
                    return CLOSING;
                }
                case 3: {
                    return CLOSED;
                }
            }
            return UNKNOWN;
        }
    }

    private class SessionImpl
    implements SocketIOSession {
        private final String sessionId;
        private AtmosphereResourceImpl resource = null;
        private AtmosphereHandler atmosphereHandler;
        private SocketIOSessionOutbound handler = null;
        private ConnectionState state = ConnectionState.CONNECTING;
        private long heartBeatInterval = 0L;
        private long timeout = 0L;
        private long requestSuspendTime = 0L;
        private HeartBeatSessionMonitor heartBeatSessionMonitor = new HeartBeatSessionMonitor(this, SocketIOSessionManagerImpl.access$000(SocketIOSessionManagerImpl.this));
        private TimeoutSessionMonitor timeoutSessionMonitor = new TimeoutSessionMonitor(this, SocketIOSessionManagerImpl.access$000(SocketIOSessionManagerImpl.this));
        private boolean timedout = false;
        private AtomicLong messageId = new AtomicLong(0L);
        private String closeId = null;
        private AtomicBoolean firstRequest = new AtomicBoolean(true);

        SessionImpl(String sessionId, AtmosphereResourceImpl resource, AtmosphereHandler atmosphereHandler, long timeout, long heartBeatInterval, long requestSuspendTime) {
            this.sessionId = sessionId;
            this.atmosphereHandler = atmosphereHandler;
            this.resource = resource;
            this.timeout = timeout;
            this.heartBeatInterval = heartBeatInterval;
            this.requestSuspendTime = requestSuspendTime;
            this.heartBeatSessionMonitor.setDelay(heartBeatInterval);
            this.timeoutSessionMonitor.setDelay(timeout);
        }

        @Override
        public String generateRandomString(int length) {
            return SocketIOSessionManagerImpl.generateRandomString(length);
        }

        @Override
        public String getSessionId() {
            return this.sessionId;
        }

        @Override
        public AtmosphereHandler getAtmosphereHandler() {
            return this.atmosphereHandler;
        }

        @Override
        public SocketIOSessionOutbound getTransportHandler() {
            return this.handler;
        }

        @Override
        public void startTimeoutTimer() {
            logger.trace("startTimeoutTimer for SessionID= " + this.sessionId);
            this.clearTimeoutTimer();
            if (!this.timedout && this.timeout > 0L) {
                this.timeoutSessionMonitor.start();
            }
        }

        @Override
        public void clearTimeoutTimer() {
            logger.trace("clearTimeoutTimer for SessionID= " + this.sessionId);
            if (this.timeoutSessionMonitor != null) {
                this.timeoutSessionMonitor.cancel();
            }
        }

        @Override
        public void sendHeartBeat() {
            String data = "" + this.messageId.incrementAndGet();
            logger.trace("Session[" + this.sessionId + "]: sendPing " + data);
            try {
                this.handler.sendMessage("2::");
            }
            catch (Exception e) {
                logger.debug("handler.sendMessage failed: ", (Throwable)e);
                this.handler.abort();
            }
            logger.trace("calling from " + this.getClass().getName() + " : sendPing");
            this.startTimeoutTimer();
        }

        @Override
        public void timeout() {
            logger.trace("Session[" + this.sessionId + "]: onTimeout");
            if (!this.timedout) {
                this.timedout = true;
                this.state = ConnectionState.CLOSED;
                this.onDisconnect(DisconnectReason.TIMEOUT);
                this.handler.abort();
            }
        }

        @Override
        public void startHeartbeatTimer() {
            logger.trace("startHeartbeatTimer");
            this.clearHeartbeatTimer();
            this.clearTimeoutTimer();
            if (!this.timedout && this.heartBeatInterval > 0L) {
                this.heartBeatSessionMonitor.start();
            }
        }

        @Override
        public void clearHeartbeatTimer() {
            logger.trace("clearHeartbeatTimer : Clear previous Timer");
            if (this.heartBeatSessionMonitor != null) {
                this.heartBeatSessionMonitor.cancel();
            }
        }

        @Override
        public void setHeartbeat(long delay) {
            this.heartBeatInterval = delay;
            this.heartBeatSessionMonitor.setDelay(delay);
        }

        @Override
        public long getHeartbeat() {
            return this.heartBeatInterval;
        }

        @Override
        public void setTimeout(long timeout) {
            this.timeout = timeout;
            this.timeoutSessionMonitor.setDelay(timeout);
        }

        @Override
        public long getTimeout() {
            return this.timeout;
        }

        @Override
        public void setRequestSuspendTime(long suspendTime) {
            this.requestSuspendTime = suspendTime;
        }

        @Override
        public long getRequestSuspendTime() {
            return this.requestSuspendTime;
        }

        @Override
        public void startClose() {
            logger.error("startClose");
            this.state = ConnectionState.CLOSING;
            this.closeId = "server";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onClose(String data) {
            if (this.state == ConnectionState.CLOSING) {
                if (this.closeId != null && this.closeId.equals(data)) {
                    this.state = ConnectionState.CLOSED;
                    this.onDisconnect(DisconnectReason.CLOSED);
                    this.handler.abort();
                    return;
                } else {
                    try {
                        this.handler.sendMessage(data);
                        return;
                    }
                    catch (SocketIOException e) {
                        if (this.state == ConnectionState.CLOSED) return;
                        logger.error("handler.sendMessage failed: ", (Throwable)e);
                        this.state = ConnectionState.CLOSED;
                        this.onDisconnect(DisconnectReason.UNKNOWN);
                        this.handler.abort();
                    }
                }
                return;
            }
            this.clearTimeoutTimer();
            this.clearHeartbeatTimer();
            this.state = ConnectionState.CLOSING;
            try {
                this.handler.sendMessage(data);
                return;
            }
            catch (SocketIOException e) {
                logger.error("handler.sendMessage failed: ", (Throwable)e);
                this.handler.abort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnect(AtmosphereResourceImpl resource, SocketIOSessionOutbound handler) {
            if (handler == null) {
                this.state = ConnectionState.CLOSED;
                this.atmosphereHandler = null;
                SocketIOSessionManagerImpl.this.socketIOSessions.remove(this.sessionId);
            } else if (this.handler == null) {
                this.handler = handler;
                try {
                    this.state = ConnectionState.CONNECTED;
                    if (this.atmosphereHandler == null) {
                        logger.debug("Invalid state");
                        return;
                    }
                    resource.getRequest().setAttribute(SocketIOAtmosphereHandler.SOCKETIO_SESSION_ID, (Object)this.sessionId);
                    resource.getRequest().setAttribute("SocketIOSessionOutbound", (Object)handler);
                    this.startHeartbeatTimer();
                    AtmosphereHandler atmosphereHandler = this.atmosphereHandler;
                    synchronized (atmosphereHandler) {
                        if (SocketIOAtmosphereHandler.class.isAssignableFrom(this.atmosphereHandler.getClass())) {
                            ((SocketIOAtmosphereHandler)SocketIOAtmosphereHandler.class.cast(this.atmosphereHandler)).onConnect((AtmosphereResource)resource, handler);
                        } else {
                            resource.disableSuspend(true);
                            this.atmosphereHandler.onRequest((AtmosphereResource)resource);
                        }
                    }
                }
                catch (Throwable e) {
                    logger.error("Session[" + this.sessionId + "]: Exception thrown by SocketIOInbound.onConnect()", e);
                    this.state = ConnectionState.CLOSED;
                    handler.abort();
                }
            } else {
                handler.abort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(AtmosphereResourceImpl resource, SocketIOSessionOutbound outbound, String message) {
            this.startHeartbeatTimer();
            if (this.atmosphereHandler != null && message != null) {
                try {
                    AtmosphereHandler atmosphereHandler = this.atmosphereHandler;
                    synchronized (atmosphereHandler) {
                        if (SocketIOAtmosphereHandler.class.isAssignableFrom(this.atmosphereHandler.getClass())) {
                            ((SocketIOAtmosphereHandler)SocketIOAtmosphereHandler.class.cast(this.atmosphereHandler)).onMessage((AtmosphereResource)resource, outbound, message);
                        } else {
                            SocketIOProtocol p = (SocketIOProtocol)mapper.readValue(message, SocketIOProtocol.class);
                            for (String msg : p.getArgs()) {
                                AtmosphereRequest r = resource.getRequest();
                                r.setAttribute(SocketIOProtocol.class.getName(), (Object)p);
                                r.body(msg).method("POST");
                                resource.disableSuspend(true);
                                this.atmosphereHandler.onRequest((AtmosphereResource)resource);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    logger.error("Session[" + this.sessionId + "]: Exception thrown by SocketIOInbound.onMessage()", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisconnect(DisconnectReason reason) {
            logger.trace("Session[" + this.sessionId + "]: onDisconnect: " + (Object)((Object)reason));
            this.clearTimeoutTimer();
            this.clearHeartbeatTimer();
            if (this.atmosphereHandler != null) {
                this.state = ConnectionState.CLOSED;
                try {
                    AtmosphereHandler atmosphereHandler = this.atmosphereHandler;
                    synchronized (atmosphereHandler) {
                        if (SocketIOAtmosphereHandler.class.isAssignableFrom(this.atmosphereHandler.getClass())) {
                            ((SocketIOAtmosphereHandler)SocketIOAtmosphereHandler.class.cast(this.atmosphereHandler)).onDisconnect((AtmosphereResource)this.resource, this.handler, reason);
                        } else {
                            this.atmosphereHandler.onStateChange((AtmosphereResourceEvent)new AtmosphereResourceEventImpl(this.resource, true, false));
                        }
                    }
                }
                catch (Throwable e) {
                    logger.error("Session[" + this.sessionId + "]: Exception thrown by SocketIOInbound.onDisconnect()", e);
                }
                this.atmosphereHandler = null;
            }
        }

        @Override
        public void onShutdown() {
            logger.trace("Session[" + this.sessionId + "]: onShutdown");
            if (this.atmosphereHandler != null) {
                if (this.state == ConnectionState.CLOSING) {
                    if (this.closeId != null) {
                        this.onDisconnect(DisconnectReason.CLOSE_FAILED);
                    } else {
                        this.onDisconnect(DisconnectReason.CLOSED_REMOTELY);
                    }
                } else {
                    this.onDisconnect(DisconnectReason.ERROR);
                }
            }
            SocketIOSessionManagerImpl.this.socketIOSessions.remove(this.sessionId);
        }

        @Override
        public AtmosphereResourceImpl getAtmosphereResourceImpl() {
            return this.resource;
        }

        @Override
        public void setAtmosphereResourceImpl(AtmosphereResourceImpl resource) {
            this.resource = resource;
        }
    }
}

