/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.socketio.transport;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.socketio.SocketIOSession;
import org.atmosphere.socketio.transport.XHRTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XHRPollingTransport
extends XHRTransport {
    private static final Logger logger = LoggerFactory.getLogger(XHRPollingTransport.class);
    public static final String TRANSPORT_NAME = "xhr-polling";
    private final ReentrantLock lock = new ReentrantLock();

    public XHRPollingTransport(int bufferSize) {
        super(bufferSize);
    }

    @Override
    public String getName() {
        return TRANSPORT_NAME;
    }

    @Override
    protected XHRPollingSessionHelper createHelper(SocketIOSession session) {
        return new XHRPollingSessionHelper(session);
    }

    protected class XHRPollingSessionHelper
    extends XHRTransport.XHRSessionHelper {
        XHRPollingSessionHelper(SocketIOSession session) {
            super(XHRPollingTransport.this, session, false);
        }

        @Override
        protected void startSend(AtmosphereResponse response) throws IOException {
            response.setContentType("text/plain; charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
        }

        @Override
        protected void writeData(AtmosphereResponse response, String data) throws IOException {
            XHRPollingTransport.this.lock.lock();
            try {
                logger.trace("calling from " + this.getClass().getName() + " : writeData(string) = " + data);
                response.getOutputStream().write(data.getBytes("UTF-8"));
                logger.trace("WRITE SUCCESS calling from " + this.getClass().getName() + " : writeData(string) = " + data);
            }
            finally {
                XHRPollingTransport.this.lock.unlock();
            }
        }

        @Override
        protected void finishSend(AtmosphereResponse response) throws IOException {
            response.flushBuffer();
            response.getOutputStream().flush();
        }

        @Override
        protected void customConnect(AtmosphereRequest request, AtmosphereResponse response) throws IOException {
            this.startSend(response);
            this.writeData(response, "1::");
        }
    }
}

