/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.socketio.cpr;

import java.io.IOException;
import java.util.List;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.socketio.SocketIOException;
import org.atmosphere.socketio.SocketIOSession;
import org.atmosphere.socketio.SocketIOWebSocketSessionWrapper;
import org.atmosphere.socketio.transport.SocketIOPacketImpl;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketEventListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketIOWebSocketEventListener
extends WebSocketEventListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(SocketIOWebSocketEventListener.class);
    private SocketIOWebSocketSessionWrapper sessionWrapper = null;

    public void setSessionWrapper(SocketIOWebSocketSessionWrapper sessionWrapper) {
        this.sessionWrapper = sessionWrapper;
    }

    public void onMessage(WebSocketEventListener.WebSocketEvent event) {
        logger.trace("calling from " + ((Object)((Object)this)).getClass().getName() + " : onMessage");
        if (!this.sessionWrapper.isInitiated()) {
            if ("OPEN".equals(event.message())) {
                try {
                    this.sessionWrapper.getSession().onConnect(this.sessionWrapper.getSession().getAtmosphereResourceImpl(), this.sessionWrapper);
                    this.sessionWrapper.initiated(true);
                }
                catch (Exception e) {
                    this.sessionWrapper.webSocket().close();
                    this.sessionWrapper.getSession().onShutdown();
                }
            } else {
                this.sessionWrapper.webSocket().close();
                this.sessionWrapper.getSession().onShutdown();
            }
        } else {
            List<SocketIOPacketImpl> messages = null;
            try {
                messages = SocketIOPacketImpl.parse(event.message().toString());
            }
            catch (SocketIOException e) {
                logger.warn("", (Throwable)e);
            }
            if (messages != null && !messages.isEmpty()) {
                SocketIOSession session = this.sessionWrapper.getSession();
                for (SocketIOPacketImpl msg : messages) {
                    session.onMessage(session.getAtmosphereResourceImpl(), session.getTransportHandler(), msg.getData());
                }
            }
        }
    }

    public void onConnect(WebSocketEventListener.WebSocketEvent event) {
        logger.trace("calling from " + ((Object)((Object)this)).getClass().getName() + " : onConnect");
        this.sessionWrapper.setWebSocket(event.webSocket());
        try {
            event.webSocket().write(new SocketIOPacketImpl(SocketIOPacketImpl.PacketType.CONNECT).toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sessionWrapper.getSession().onShutdown();
        }
        try {
            this.sessionWrapper.getSession().setAtmosphereResourceImpl((AtmosphereResourceImpl)event.webSocket().resource());
            this.sessionWrapper.getSession().onConnect(this.sessionWrapper.getSession().getAtmosphereResourceImpl(), this.sessionWrapper);
            this.sessionWrapper.initiated(true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.sessionWrapper.getSession().onShutdown();
        }
    }

    public void onClose(WebSocketEventListener.WebSocketEvent event) {
        logger.trace("calling from " + ((Object)((Object)this)).getClass().getName() + " : onClose event = " + event);
        this.sessionWrapper.getSession().onClose(event.message().toString());
    }

    protected SocketIOWebSocketSessionWrapper getSessionWrapper() {
        return this.sessionWrapper;
    }
}

