/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.sockjs;

import java.io.IOException;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.sockjs.IFrameUtils;
import org.atmosphere.sockjs.SSETransport;
import org.atmosphere.sockjs.TransportBasedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlFileTransport
extends TransportBasedListener {
    private static final byte[] padding;
    private static final Logger logger;

    public void onPreSuspend(AtmosphereResourceEvent event) {
        AtmosphereResponse response = event.getResource().getResponse();
        AtmosphereRequest request = event.getResource().getRequest();
        String callback = request.getParameter("c");
        response.setContentType("text/html; charset=UTF-8");
        response.write(IFrameUtils.generateHtmlFile(callback)).write(padding);
        try {
            response.write("<script>\np(\"o\")\n</script>\n".getBytes()).flushBuffer();
        }
        catch (IOException e) {
            logger.trace("", (Throwable)e);
        }
    }

    static {
        StringBuilder whitespace = new StringBuilder();
        for (int i = 0; i < 1024; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\r\n");
        String paddingText = whitespace.toString();
        padding = paddingText.getBytes();
        logger = LoggerFactory.getLogger(SSETransport.class);
    }
}

