/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.sockjs;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import org.atmosphere.config.service.AtmosphereInterceptorService;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.interceptor.HeartbeatInterceptor;
import org.atmosphere.sockjs.HtmlFileTransport;
import org.atmosphere.sockjs.IFrameUtils;
import org.atmosphere.sockjs.JSONPTransport;
import org.atmosphere.sockjs.JsonCodec;
import org.atmosphere.sockjs.LongPollingTransport;
import org.atmosphere.sockjs.SSETransport;
import org.atmosphere.sockjs.SockjsSession;
import org.atmosphere.sockjs.StreamingTransport;
import org.atmosphere.sockjs.WebSocketTransport;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.StringEscapeUtils;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereInterceptorService
public class SockJsAtmosphereInterceptor
extends AtmosphereInterceptorAdapter {
    public static final String SOCKS_JS_ORIGIN = SockJsAtmosphereInterceptor.class.getName() + ".origin";
    private static final Logger logger = LoggerFactory.getLogger(SockJsAtmosphereInterceptor.class);
    private boolean supportWebSocket = true;
    private final AtomicReference<String> baseURL = new AtomicReference<String>("");
    private AtmosphereFramework framework;
    private final Map<String, SockjsSession> sessions = Collections.synchronizedMap(new WeakHashMap());
    public static final AtmosphereHandler ECHO_ATMOSPHEREHANDLER = new AbstractReflectorAtmosphereHandler(){

        public void onRequest(AtmosphereResource resource) throws IOException {
            String body = IOUtils.readEntirely((AtmosphereResource)resource).toString();
            if (!body.isEmpty()) {
                resource.getBroadcaster().broadcast((Object)body);
            }
        }
    };

    public void configure(AtmosphereConfig config) {
        this.framework = config.framework();
        this.supportWebSocket = config.framework().getAsyncSupport().supportWebSocket();
        config.properties().put("jsonpTransport", "c");
        for (AtmosphereInterceptor i : this.framework.interceptors()) {
            if (!HeartbeatInterceptor.class.isAssignableFrom(i.getClass())) continue;
            ((HeartbeatInterceptor)HeartbeatInterceptor.class.cast(i)).paddingText("h".getBytes()).heartbeatFrequencyInSeconds(25);
        }
        boolean addInterceptor = true;
        for (AtmosphereInterceptor i : this.framework.interceptors()) {
            if (!AtmosphereResourceLifecycleInterceptor.class.isAssignableFrom(i.getClass())) continue;
            addInterceptor = true;
        }
        if (addInterceptor) {
            this.framework.interceptor((AtmosphereInterceptor)new AtmosphereResourceLifecycleInterceptor(true));
        }
        if (config.handlers().size() == 0) {
            this.framework.addAtmosphereHandler("/*", ECHO_ATMOSPHEREHANDLER);
        }
    }

    public Action inspect(AtmosphereResource r) {
        AtmosphereRequest request = r.getRequest();
        if (request.getAttribute("sockjs.skipInterceptor") != null) {
            return Action.CONTINUE;
        }
        boolean info = request.getRequestURI().endsWith("/info");
        if (info) {
            return this.info(r);
        }
        boolean iframe = request.getRequestURI().endsWith("/iframe.html");
        if (iframe) {
            return this.iframe(r);
        }
        if (!this.baseURL.get().isEmpty() && request.getRequestURI().startsWith(this.baseURL.get())) {
            super.inspect(r);
            String sessionId = this.param(request.getRequestURI(), 2);
            String transport = this.param(request.getRequestURI(), 4);
            SockjsSession s = this.sessions.get(sessionId);
            this.configureTransport((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r), transport, s != null);
            boolean longPolling = Utils.resumableTransport((AtmosphereResource.TRANSPORT)r.transport());
            if (s == null) {
                this.sessions.put(sessionId, new SockjsSession());
                if (!longPolling) {
                    this.installWriter(r, sessionId);
                }
                return Action.CONTINUE;
            }
            if (longPolling) {
                this.installWriter(r, sessionId);
                return Action.CONTINUE;
            }
            return this.injectMessage(r);
        }
        return Action.CONTINUE;
    }

    private Action iframe(AtmosphereResource r) {
        AtmosphereResponse response = r.getResponse();
        response.setContentType("text/html");
        String origin = this.framework.getAtmosphereConfig().getInitParameter(SOCKS_JS_ORIGIN);
        if (origin == null) {
            origin = "http://localhost:8080/lib/sockjs.js";
        }
        try {
            response.write(IFrameUtils.generateIFrame(origin)).flushBuffer();
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return Action.CANCELLED;
    }

    protected Action info(AtmosphereResource r) {
        AtmosphereResponse response = r.getResponse();
        AtmosphereRequest request = r.getRequest();
        response.headers().put("Content-Type", "application/json; charset=UTF-8");
        ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
        json.put("websocket", this.supportWebSocket);
        json.putArray("origins").add("*:*");
        json.put("entropy", new Random().nextInt());
        r.write(JsonCodec.encode(json));
        if (this.baseURL.get().isEmpty()) {
            this.baseURL.set(request.getRequestURI().substring(0, request.getRequestURI().indexOf("/info")));
        }
        return Action.CANCELLED;
    }

    private String param(String url, int pos) {
        String[] params = url.split("/");
        if (params.length < pos) {
            return "/";
        }
        return params[pos];
    }

    private void configureTransport(AtmosphereResourceImpl r, String s, boolean hasSession) {
        if ("websocket".equals(s)) {
            r.transport(AtmosphereResource.TRANSPORT.WEBSOCKET).addEventListener((AtmosphereResourceEventListener)new WebSocketTransport());
        } else if ("xhr".equals(s) || "xdr".equals(s)) {
            r.transport(AtmosphereResource.TRANSPORT.LONG_POLLING);
            if (!hasSession) {
                r.addEventListener((AtmosphereResourceEventListener)new LongPollingTransport());
            }
        } else if ("xhr_streaming".equals(s)) {
            r.transport(AtmosphereResource.TRANSPORT.STREAMING).addEventListener((AtmosphereResourceEventListener)new StreamingTransport());
        } else if ("jsonp".equals(s)) {
            r.transport(AtmosphereResource.TRANSPORT.JSONP);
            if (!hasSession) {
                r.addEventListener((AtmosphereResourceEventListener)new JSONPTransport());
            }
        } else if ("eventsource".equals(s)) {
            r.transport(AtmosphereResource.TRANSPORT.SSE).addEventListener((AtmosphereResourceEventListener)new SSETransport());
        } else if (s.indexOf("_send") != -1) {
            r.transport(AtmosphereResource.TRANSPORT.POLLING);
        } else if ("htmlfile".equals(s)) {
            r.transport(AtmosphereResource.TRANSPORT.HTMLFILE).addEventListener((AtmosphereResourceEventListener)new HtmlFileTransport());
        } else if (s.indexOf("_send") == -1) {
            r.transport(AtmosphereResource.TRANSPORT.UNDEFINED).addEventListener((AtmosphereResourceEventListener)new StreamingTransport());
        }
    }

    private void installWriter(final AtmosphereResource r, final String sessionId) {
        final AtmosphereResource.TRANSPORT transport = r.transport();
        AtmosphereResponse response = r.getResponse();
        AsyncIOWriter writer = response.getAsyncIOWriter();
        if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
            ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor((AsyncIOInterceptor)new AsyncIOInterceptorAdapter(){

                public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
                    String charEncoding = response.getCharacterEncoding() == null ? "UTF-8" : response.getCharacterEncoding();
                    String s = new String(responseDraft, charEncoding);
                    if (s.equalsIgnoreCase("h") || s.equals("c") || s.equals("o\n") && r.transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET)) {
                        return s.getBytes();
                    }
                    if (!s.isEmpty()) {
                        try {
                            if (transport.equals((Object)AtmosphereResource.TRANSPORT.JSONP)) {
                                return ("a" + s).getBytes(charEncoding);
                            }
                            if (transport.equals((Object)AtmosphereResource.TRANSPORT.HTMLFILE)) {
                                StringBuilder sb = new StringBuilder();
                                sb.append("<script>\np(").append("\"").append(StringEscapeUtils.escapeJavaScript((String)("a[\"" + StringEscapeUtils.escapeJavaScript((String)s) + "\"]\n"))).append("\")</script>\n");
                                return sb.toString().getBytes(charEncoding);
                            }
                            return ("a[\"" + StringEscapeUtils.escapeJavaScript((String)s) + "\"]\n").getBytes(charEncoding);
                        }
                        catch (Exception e) {
                            logger.error("", (Throwable)e);
                            return "".getBytes();
                        }
                    }
                    return s.getBytes();
                }
            });
        } else {
            logger.warn("Unable to apply {}. Your AsyncIOWriter must implement {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)AtmosphereInterceptorWriter.class.getName());
        }
        r.addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceEventListenerAdapter(){

            public void onDisconnect(AtmosphereResourceEvent event) {
                SockJsAtmosphereInterceptor.this.sessions.remove(sessionId);
            }
        });
    }

    private Action injectMessage(AtmosphereResource r) {
        AtmosphereResponse response = r.getResponse();
        AtmosphereRequest request = r.getRequest();
        try {
            String body = IOUtils.readEntirely((AtmosphereResource)r).toString();
            if (!body.isEmpty() && body.startsWith("d=")) {
                body = URLDecoder.decode(body, "UTF-8");
                body = body.substring(2);
                response.setStatus(200);
                response.write("ok", true).flushBuffer();
                this.reInject(request, response, body);
            } else {
                String[] messages;
                for (String m : messages = this.parseMessageString(body)) {
                    if (m == null) continue;
                    this.reInject(request, response, m);
                }
                response.setStatus(204);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return Action.CANCELLED;
    }

    private void reInject(AtmosphereRequest request, AtmosphereResponse response, String body) throws IOException, ServletException {
        request.setAttribute("sockjs.skipInterceptor", (Object)Boolean.TRUE);
        this.framework.doCometSupport(request.body(body), response);
        request.setAttribute("sockjs.skipInterceptor", null);
    }

    private String[] parseMessageString(String msgs) {
        try {
            String[] parts;
            if (msgs.startsWith("[")) {
                parts = (String[])JsonCodec.decodeValue(msgs, String[].class);
            } else {
                String str = (String)JsonCodec.decodeValue(msgs, String.class);
                parts = new String[]{str};
            }
            return parts;
        }
        catch (Exception e) {
            return null;
        }
    }
}

