/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.sockjs;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

public class JsonCodec {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String encode(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static Object decodeValue(String str, Class<?> clazz) {
        try {
            return mapper.readValue(str, clazz);
        }
        catch (IOException e) {
            return null;
        }
    }

    static {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(String.class, (JsonSerializer)new JsonSerializer<String>(){
            final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
            final int[] ESCAPE_CODES = CharTypes.get7BitOutputEscapes();

            private void writeUnicodeEscape(JsonGenerator gen, char c) throws IOException {
                gen.writeRaw('\\');
                gen.writeRaw('u');
                gen.writeRaw(this.HEX_CHARS[c >> 12 & 0xF]);
                gen.writeRaw(this.HEX_CHARS[c >> 8 & 0xF]);
                gen.writeRaw(this.HEX_CHARS[c >> 4 & 0xF]);
                gen.writeRaw(this.HEX_CHARS[c & 0xF]);
            }

            private void writeShortEscape(JsonGenerator gen, char c) throws IOException {
                gen.writeRaw('\\');
                gen.writeRaw(c);
            }

            public void serialize(String str, JsonGenerator gen, SerializerProvider provider) throws IOException {
                int status = ((JsonWriteContext)gen.getOutputContext()).writeValue();
                switch (status) {
                    case 2: {
                        gen.writeRaw(':');
                        break;
                    }
                    case 1: {
                        gen.writeRaw(',');
                        break;
                    }
                    case 5: {
                        throw new JsonGenerationException("Can not write string value here");
                    }
                }
                gen.writeRaw('\"');
                for (char c : str.toCharArray()) {
                    int code;
                    if (c >= '\u0080') {
                        this.writeUnicodeEscape(gen, c);
                        continue;
                    }
                    int n = code = c < this.ESCAPE_CODES.length ? this.ESCAPE_CODES[c] : 0;
                    if (code == 0) {
                        gen.writeRaw(c);
                        continue;
                    }
                    if (code == -1) {
                        this.writeUnicodeEscape(gen, c);
                        continue;
                    }
                    this.writeShortEscape(gen, (char)code);
                }
                gen.writeRaw('\"');
            }
        });
        mapper.registerModule((Module)simpleModule);
    }
}

