/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.container.config;

import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.core.reflection.ReflectionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedClassScanner {
    private static final Logger LOGGER = Logger.getLogger(AnnotatedClassScanner.class.getName());
    private Set<Class<?>> classes;
    private final Set<String> annotations;
    private final ClassLoader classloader;
    private final AnnotatedClassVisitor classVisitor = new AnnotatedClassVisitor();

    public AnnotatedClassScanner(Class ... annotations) {
        this.classloader = ReflectionHelper.getContextClassLoader();
        this.annotations = this.getAnnotationSet(annotations);
        this.classes = new HashSet();
    }

    public Set<Class<?>> scan(File[] paths) {
        this.classes = new HashSet();
        for (File file : paths) {
            this.index(file);
        }
        return this.classes;
    }

    public Set<Class<?>> scan(String[] packages) {
        this.classes = new HashSet();
        for (String p : packages) {
            try {
                String fileP = p.replace('.', '/');
                Enumeration<URL> urls = this.classloader.getResources(fileP);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    try {
                        URI uri = this.getURI(url);
                        this.index(uri, fileP);
                    }
                    catch (URISyntaxException e) {
                        LOGGER.log(Level.WARNING, "URL, " + url + ", cannot be converted to a URI", e);
                    }
                }
            }
            catch (IOException ex) {
                String s = "The resources for the package" + p + ", could not be obtained";
                LOGGER.severe(s);
                throw new RuntimeException(s, ex);
            }
        }
        return this.classes;
    }

    private URI getURI(URL url) throws URISyntaxException {
        if (url.getProtocol().equalsIgnoreCase("vfsfile")) {
            return new URI(url.toString().substring(3));
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            URI uri = URI.create(this.toExternalForm(url));
            LOGGER.log(Level.WARNING, "The URL, " + url + ", obtained from the class loader, " + this.classloader + ", is invalid resulting in failure of the invocation URL.toURI()" + ". The URL has been explicitly converted to the URI, " + uri);
            return uri;
        }
    }

    private String toExternalForm(URL u) {
        int len = u.getProtocol().length() + 1;
        if (u.getAuthority() != null && u.getAuthority().length() > 0) {
            len += 2 + u.getAuthority().length();
        }
        if (u.getPath() != null) {
            len += u.getPath().length();
        }
        if (u.getQuery() != null) {
            len += 1 + u.getQuery().length();
        }
        if (u.getRef() != null) {
            len += 1 + u.getRef().length();
        }
        StringBuffer result = new StringBuffer(len);
        result.append(u.getProtocol());
        result.append(":");
        if (u.getAuthority() != null && u.getAuthority().length() > 0) {
            result.append("//");
            result.append(u.getAuthority());
        }
        if (u.getPath() != null) {
            result.append(UriComponent.contextualEncode(u.getPath(), UriComponent.Type.PATH));
        }
        if (u.getQuery() != null) {
            result.append('?');
            result.append(UriComponent.contextualEncode(u.getQuery(), UriComponent.Type.QUERY));
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        return result.toString();
    }

    public Set<Class<?>> getMatchingClasses() {
        return this.classes;
    }

    private Set<String> getAnnotationSet(Class ... annotations) {
        HashSet<String> a = new HashSet<String>();
        for (Class cls : annotations) {
            a.add("L" + cls.getName().replaceAll("\\.", "/") + ";");
        }
        return a;
    }

    private void index(File file) {
        if (file.isDirectory()) {
            this.indexDir(file, true);
        } else if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
            this.indexJar(file);
        } else {
            LOGGER.warning("File, " + file.getAbsolutePath() + ", is ignored, it not a directory, a jar file or a zip file");
        }
    }

    private void index(URI u, String filePackageName) {
        String scheme = u.getScheme();
        if (scheme.equals("file")) {
            File f = new File(u.getPath());
            if (f.isDirectory()) {
                this.indexDir(f, false);
            } else {
                LOGGER.warning("URL, " + u + ", is ignored. The path, " + f.getPath() + ", is not a directory");
            }
        } else if (scheme.equals("jar") || scheme.equals("zip")) {
            URI jarUri = URI.create(u.getRawSchemeSpecificPart());
            String jarFile = jarUri.getPath();
            jarFile = jarFile.substring(0, jarFile.indexOf(33));
            this.indexJar(new File(jarFile), filePackageName);
        } else {
            LOGGER.warning("URL, " + u + ", is ignored, it not a file or a jar file URL");
        }
    }

    private void indexDir(File root, boolean indexJars) {
        for (File child : root.listFiles()) {
            if (child.isDirectory()) {
                this.indexDir(child, indexJars);
                continue;
            }
            if (indexJars && child.getName().endsWith(".jar")) {
                this.indexJar(child);
                continue;
            }
            if (!child.getName().endsWith(".class")) continue;
            this.analyzeClassFile(child.toURI());
        }
    }

    private void indexJar(File file) {
        this.indexJar(file, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexJar(File file, String parent) {
        JarFile jar = this.getJarFile(file);
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry e = entries.nextElement();
                if (e.isDirectory() || !e.getName().startsWith(parent) || !e.getName().endsWith(".class")) continue;
                this.analyzeClassFile(jar, e);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while processing file, " + file, e);
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException ex) {
                String s = "Error closing jar file, " + jar.getName();
                LOGGER.severe(s);
            }
        }
    }

    private JarFile getJarFile(File file) {
        if (file == null) {
            return null;
        }
        try {
            return new JarFile(file);
        }
        catch (IOException ex) {
            String s = "File, " + file.getAbsolutePath() + ", is not a jar file";
            LOGGER.severe(s);
            throw new RuntimeException(s, ex);
        }
    }

    private void analyzeClassFile(URI classFileUri) {
        this.getClassReader(classFileUri).accept(this.classVisitor, 0);
    }

    private void analyzeClassFile(JarFile jarFile, JarEntry entry) {
        this.getClassReader(jarFile, entry).accept(this.classVisitor, 0);
    }

    private ClassReader getClassReader(JarFile jarFile, JarEntry entry) {
        InputStream is = null;
        try {
            ClassReader cr;
            is = jarFile.getInputStream(entry);
            ClassReader classReader = cr = new ClassReader(is);
            return classReader;
        }
        catch (IOException ex) {
            String s = "Error accessing input stream of the jar file, " + jarFile.getName() + ", entry, " + entry.getName();
            LOGGER.severe(s);
            throw new RuntimeException(s, ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                String s = "Error closing input stream of the jar file, " + jarFile.getName() + ", entry, " + entry.getName() + ", closed.";
                LOGGER.severe(s);
            }
        }
    }

    private ClassReader getClassReader(URI classFileUri) {
        InputStream is = null;
        try {
            ClassReader cr;
            is = classFileUri.toURL().openStream();
            ClassReader classReader = cr = new ClassReader(is);
            return classReader;
        }
        catch (IOException ex) {
            String s = "Error accessing input stream of the class file URI, " + classFileUri;
            LOGGER.severe(s);
            throw new RuntimeException(s, ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                String s = "Error closing input stream of the class file URI, " + classFileUri;
                LOGGER.severe(s);
            }
        }
    }

    private Class getClassForName(String className) {
        try {
            return ReflectionHelper.classForNameWithException(className, this.classloader);
        }
        catch (ClassNotFoundException ex) {
            String s = "A class file of the class name, " + className + "is identified but the class could not be found";
            LOGGER.severe(s);
            throw new RuntimeException(s, ex);
        }
    }

    private final class AnnotatedClassVisitor
    implements ClassVisitor {
        private String className;
        private boolean isScoped;
        private boolean isAnnotated;

        private AnnotatedClassVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            this.isScoped = (access & 1) != 0;
            this.isAnnotated = false;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.isAnnotated |= AnnotatedClassScanner.this.annotations.contains(desc);
            return null;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (this.className.equals(name)) {
                this.isScoped = (access & 1) != 0;
                this.isScoped &= (access & 8) == 8;
            }
        }

        public void visitEnd() {
            if (this.isScoped && this.isAnnotated) {
                AnnotatedClassScanner.this.classes.add(AnnotatedClassScanner.this.getClassForName(this.className.replaceAll("/", ".")));
            }
        }

        public void visitOuterClass(String string, String string0, String string1) {
        }

        public FieldVisitor visitField(int i, String string, String string0, String string1, Object object) {
            return null;
        }

        public void visitSource(String string, String string0) {
        }

        public void visitAttribute(Attribute attribute) {
        }

        public MethodVisitor visitMethod(int i, String string, String string0, String string1, String[] string2) {
            return null;
        }
    }
}

