/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.jcdi;

import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCManagedComponentProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCDIComponentProviderFactory
implements IoCComponentProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(JCDIComponentProviderFactory.class.getName());
    private final BeanManager bm;
    private final Map<Class<? extends Annotation>, ComponentScope> scopeMap = this.createScopeMap();

    public JCDIComponentProviderFactory(Object bm) {
        this.bm = (BeanManager)bm;
    }

    @Override
    public IoCComponentProvider getComponentProvider(Class<?> c) {
        return this.getComponentProvider(null, c);
    }

    @Override
    public IoCComponentProvider getComponentProvider(ComponentContext cc, final Class<?> c) {
        Set bs = this.bm.getBeans(c, new Annotation[0]);
        if (bs.isEmpty()) {
            return null;
        }
        final Bean b = this.bm.resolve(bs);
        final ComponentScope cs = this.getComponentScope(b);
        LOGGER.info("Binding the JCDI managed class " + c.getName() + " to JCDIComponentProviderFactory in the scope " + (Object)((Object)cs));
        return new IoCManagedComponentProvider(){

            public ComponentScope getScope() {
                return cs;
            }

            public Object getInjectableInstance(Object o) {
                return o;
            }

            public Object getInstance() {
                CreationalContext bcc = JCDIComponentProviderFactory.this.bm.createCreationalContext((Contextual)b);
                return c.cast(JCDIComponentProviderFactory.this.bm.getReference(b, (Type)c, bcc));
            }
        };
    }

    private ComponentScope getComponentScope(Bean<?> b) {
        ComponentScope cs = this.scopeMap.get(b.getScope());
        return cs != null ? cs : ComponentScope.Undefined;
    }

    private Map<Class<? extends Annotation>, ComponentScope> createScopeMap() {
        HashMap<Class<? extends Annotation>, ComponentScope> m = new HashMap<Class<? extends Annotation>, ComponentScope>();
        m.put(ApplicationScoped.class, ComponentScope.Singleton);
        m.put(RequestScoped.class, ComponentScope.PerRequest);
        return m;
    }
}

