/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.atmosphere.annotation.Broadcast;
import org.atmosphere.annotation.Cluster;
import org.atmosphere.annotation.Resume;
import org.atmosphere.annotation.Schedule;
import org.atmosphere.annotation.Suspend;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.jersey.Broadcastable;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtmosphereFilter
implements ResourceFilterFactory {
    private Logger logger = LoggerUtils.getLogger();
    static final String CONTAINER_RESPONSE = "cr";
    public static final String SUSPENDED_RESOURCE = "org.atmosphere.suspendedResource";
    @Context
    private HttpServletRequest servletReq;
    @Context
    private UriInfo uriInfo;
    private static final String beginCompatibleData = AtmosphereFilter.createCompatibleStringJunk();
    private final ConcurrentHashMap<String, AtmosphereResource> resumeCandidates = new ConcurrentHashMap();

    @Override
    public List<ResourceFilter> create(AbstractMethod am) {
        LinkedList<ResourceFilter> list = new LinkedList<ResourceFilter>();
        if (am.isAnnotationPresent(Broadcast.class)) {
            int delay = am.getAnnotation(Broadcast.class).delay();
            Filter f = am.getAnnotation(Broadcast.class).resumeOnBroadcast() ? new Filter(Action.RESUME_ON_BROADCAST, delay) : new Filter(Action.BROADCAST, delay);
            list.addLast(f);
            Class[] value = am.getAnnotation(Broadcast.class).value();
            if (value != null) {
                f.setFilter(value);
            }
            if (am.isAnnotationPresent(Cluster.class)) {
                for (Class c : value = am.getAnnotation(Cluster.class).value()) {
                    try {
                        ClusterBroadcastFilter cbf = (ClusterBroadcastFilter)c.newInstance();
                        cbf.setClusterName(am.getAnnotation(Cluster.class).name());
                        f.addCluster(cbf);
                    }
                    catch (Throwable t) {
                        this.logger.log(Level.WARNING, "Invalid ClusterBroadcastFilter", t);
                    }
                }
            }
        }
        if (am.isAnnotationPresent(Suspend.class)) {
            int value = am.getAnnotation(Suspend.class).period();
            Suspend.SCOPE scope = am.getAnnotation(Suspend.class).scope();
            list.addFirst(new Filter(Action.SUSPEND, value, scope));
        }
        if (am.isAnnotationPresent(Resume.class)) {
            int value = am.getAnnotation(Resume.class).value();
            list.addFirst(new Filter(Action.RESUME, value));
        }
        if (am.isAnnotationPresent(Schedule.class)) {
            int period = am.getAnnotation(Schedule.class).period();
            list.addFirst(new Filter(Action.SCHEDULE, period));
        }
        return list.size() > 0 ? list : null;
    }

    protected static String createCompatibleStringJunk() {
        StringBuilder s = new StringBuilder();
        s.append("<!-- --------------------------------------------------------------------------------------------------------------------------------------------------------------------- -->\n");
        s.append("<!-- Welcome to the Atmosphere Framework. To work with all the browsers when suspending connection, Atmosphere must output some data to makes WebKit based browser working.-->\n");
        for (int i = 0; i < 10; ++i) {
            s.append("<!-- --------------------------------------------------------------------------------------------------------------------------------------------------------------------- -->\n");
        }
        return s.toString();
    }

    private final class Adapter
    implements ContainerResponseWriter {
        private final ContainerResponseWriter crw;

        Adapter(ContainerResponseWriter crw) {
            this.crw = crw;
        }

        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse response) throws IOException {
            return this.crw.writeStatusAndHeaders(contentLength, response);
        }

        public void finish() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Filter
    implements ResourceFilter,
    ContainerResponseFilter {
        private ConcurrentLinkedQueue<Broadcaster> configuredBroadcaster = new ConcurrentLinkedQueue();
        private Action action = Action.NONE;
        private int value;
        private Suspend.SCOPE scope;
        private Class<BroadcastFilter>[] filters = null;
        private final ArrayList<ClusterBroadcastFilter> clusters = new ArrayList();

        protected Filter(Action action) {
            this.action = action;
        }

        protected Filter(Action action, int value) {
            this.action = action;
            this.value = value;
        }

        protected Filter(Action action, int value, Suspend.SCOPE scope) {
            this.action = action;
            this.value = value;
            this.scope = scope;
        }

        @Override
        public ContainerRequestFilter getRequestFilter() {
            return null;
        }

        @Override
        public ContainerResponseFilter getResponseFilter() {
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
            AtmosphereResource r = (AtmosphereResource)AtmosphereFilter.this.servletReq.getAttribute(ReflectorServletProcessor.ATMOSPHERE_RESOURCE);
            boolean sessionSupported = (Boolean)AtmosphereFilter.this.servletReq.getAttribute("org.atmosphere.cpr.AsynchronousProcessor.supportSession");
            if (this.action == Action.SUSPEND) {
                Object o = response.getEntity();
                response.setEntity(beginCompatibleData);
                try {
                    response.write();
                }
                catch (IOException ex) {
                    throw new WebApplicationException(ex);
                }
                finally {
                    response.setEntity(o);
                }
                if (!sessionSupported) {
                    String uuid = String.valueOf(UUID.randomUUID());
                    Response res = Response.fromResponse(response.getResponse()).location(AtmosphereFilter.this.uriInfo.getAbsolutePathBuilder().path(uuid).build("")).build();
                    response.setResponse(res);
                    AtmosphereFilter.this.resumeCandidates.put(uuid, r);
                }
                response.setContainerResponseWriter(new Adapter(response.getContainerResponseWriter()));
                Broadcaster bc = r.getBroadcaster();
                if (this.scope == Suspend.SCOPE.REQUEST) {
                    try {
                        bc = (Broadcaster)bc.getClass().newInstance();
                        r.setBroadcaster(bc);
                    }
                    catch (InstantiationException ex) {
                        AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalAccessException ex) {
                        AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                    }
                } else if (response.getEntity() instanceof Broadcastable) {
                    Broadcastable b = (Broadcastable)response.getEntity();
                    bc = b.b;
                    this.configureFilter(bc);
                    r.setBroadcaster(bc);
                    response.setEntity(b.message);
                }
                if (o != null) {
                    try {
                        response.write();
                    }
                    catch (IOException ex) {
                        throw new WebApplicationException(ex);
                    }
                }
                if (sessionSupported) {
                    AtmosphereFilter.this.servletReq.getSession().setAttribute(AtmosphereFilter.SUSPENDED_RESOURCE, r);
                    AtmosphereFilter.this.servletReq.getSession().setAttribute(AtmosphereFilter.CONTAINER_RESPONSE, response);
                }
                AtmosphereFilter.this.servletReq.setAttribute(AtmosphereFilter.SUSPENDED_RESOURCE, r);
                AtmosphereFilter.this.servletReq.setAttribute(AtmosphereFilter.CONTAINER_RESPONSE, response);
                r.suspend(this.value);
                return response;
            }
            if (this.action == Action.RESUME) {
                if (r == null && sessionSupported) {
                    r = (AtmosphereResource)AtmosphereFilter.this.servletReq.getSession().getAttribute(AtmosphereFilter.SUSPENDED_RESOURCE);
                } else {
                    String path = response.getContainerRequest().getPath();
                    r = (AtmosphereResource)AtmosphereFilter.this.resumeCandidates.remove(path.substring(path.lastIndexOf("/") + 1));
                }
                if (r == null) throw new WebApplicationException(new IllegalStateException("Unable to retrieve suspended Response. Either session-support is not enabled in atmosphere.xml or thepath used to resume is invalid."));
                this.resume(r);
                return response;
            } else if (this.action == Action.BROADCAST || this.action == Action.RESUME_ON_BROADCAST) {
                AtmosphereResource ar = (AtmosphereResource)AtmosphereFilter.this.servletReq.getAttribute(AtmosphereFilter.SUSPENDED_RESOURCE);
                if (ar != null) {
                    r = ar;
                }
                this.broadcast(response, r, this.value);
                if (this.action != Action.RESUME_ON_BROADCAST) return response;
                this.resumeAll(r);
                return response;
            } else {
                if (this.action != Action.SCHEDULE) return response;
                Object o = response.getEntity();
                r.getBroadcaster().scheduleFixedBroadcast(o, this.value, TimeUnit.SECONDS);
            }
            return response;
        }

        void configureFilter(Broadcaster bc) {
            if (bc == null) {
                throw new WebApplicationException(new IllegalStateException("Broadcaster cannot be null"));
            }
            BroadcasterConfig c = bc.getBroadcasterConfig();
            for (ClusterBroadcastFilter cbf : this.clusters) {
                cbf.setBroadcaster(bc);
                c.addFilter(cbf);
            }
            BroadcastFilter f = null;
            if (this.filters != null) {
                for (Class<BroadcastFilter> filter : this.filters) {
                    try {
                        f = filter.newInstance();
                    }
                    catch (Throwable t) {
                        AtmosphereFilter.this.logger.warning("Invalid @BroadcastFilter: " + filter);
                    }
                    c.addFilter(f);
                }
            }
        }

        private void setFilter(Class<BroadcastFilter>[] filters) {
            this.filters = filters;
        }

        void broadcast(ContainerResponse r, AtmosphereResource ar, int delay) {
            Object o = r.getEntity();
            Broadcaster b = ar.getBroadcaster();
            Object msg = o;
            if (o instanceof Broadcastable) {
                b = ((Broadcastable)o).b;
                msg = ((Broadcastable)o).message;
            }
            if (o != null) {
                this.addFilter(b);
                try {
                    if (delay == -1) {
                        Object t = b.broadcast(msg).get();
                        if (o instanceof Broadcastable) {
                            r.setEntity(t);
                        }
                    } else if (delay == 0) {
                        b.delayBroadcast(msg);
                    } else {
                        b.delayBroadcast(msg, delay, TimeUnit.SECONDS);
                    }
                }
                catch (InterruptedException ex) {
                    AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                }
            }
        }

        void addFilter(Broadcaster bc) {
            if (!this.configuredBroadcaster.contains(bc)) {
                this.configureFilter(bc);
                this.configuredBroadcaster.offer(bc);
            }
        }

        void resume(AtmosphereResource r) {
            r.resume();
        }

        void resumeAll(AtmosphereResource r) {
            Iterator<AtmosphereResource> i = r.getBroadcaster().getAtmosphereResources();
            while (i.hasNext()) {
                i.next().resume();
            }
        }

        void addCluster(ClusterBroadcastFilter f) {
            this.clusters.add(f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        SUSPEND,
        RESUME,
        BROADCAST,
        RESUME_ON_BROADCAST,
        NONE,
        SCHEDULE;

    }
}

