/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import com.sun.jersey.spi.StringReader;
import com.sun.jersey.spi.StringReaderProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.util.BroadcasterLookup;
import org.atmosphere.util.LoggerUtils;

public class AtmosphereProviders {

    public static class BroadcasterProvider
    implements StringReaderProvider {
        @Context
        HttpServletRequest req;

        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            if (type != Broadcaster.class) {
                return null;
            }
            return new StringReader(){

                public Object fromString(String topic) {
                    Broadcaster broadcaster = null;
                    try {
                        broadcaster = BroadcasterLookup.lookup(topic);
                    }
                    catch (BroadcasterLookup.OutOfScopeException ex) {
                        LoggerUtils.getLogger().log(Level.SEVERE, null, ex);
                        throw new WebApplicationException(ex);
                    }
                    AtmosphereResource r = null;
                    if (broadcaster == null) {
                        if (((Boolean)BroadcasterProvider.this.req.getAttribute("org.atmosphere.cpr.AsynchronousProcessor.supportSession")).booleanValue()) {
                            r = (AtmosphereResource)BroadcasterProvider.this.req.getSession().getAttribute("org.atmosphere.suspendedResource");
                        }
                        if (r == null) {
                            r = (AtmosphereResource)BroadcasterProvider.this.req.getAttribute(ReflectorServletProcessor.ATMOSPHERE_RESOURCE);
                        }
                        broadcaster = r.getBroadcaster();
                        broadcaster.setName(topic);
                    }
                    return broadcaster;
                }
            };
        }
    }
}

