/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import com.sun.jersey.spi.container.ContainerResponse;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JerseyBroadcaster
implements Broadcaster {
    private final ConcurrentLinkedQueue<ContainerResponse> containerResponses = new ConcurrentLinkedQueue();
    protected final ConcurrentLinkedQueue<AtmosphereResource> events = new ConcurrentLinkedQueue();
    private BroadcasterConfig bc;
    private final BlockingQueue<Entry> messages = new LinkedBlockingQueue<Entry>();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Broadcaster.SCOPE scope = Broadcaster.SCOPE.APPLICATION;
    private String name = DefaultBroadcaster.class.getSimpleName();
    private final ConcurrentLinkedQueue<Entry> delayedBroadcast = new ConcurrentLinkedQueue();

    public JerseyBroadcaster() {
        this.bc = new BroadcasterConfig();
    }

    @Override
    public void destroy() {
        this.bc.destroy();
    }

    @Override
    public Iterator<AtmosphereResource> getAtmosphereResources() {
        return this.events.iterator();
    }

    @Override
    public void setScope(Broadcaster.SCOPE scope) {
        this.scope = scope;
    }

    @Override
    public Broadcaster.SCOPE getScope() {
        return this.scope;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    final void start() {
        if (!this.started.getAndSet(true)) {
            this.bc.getExecutorService().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    Entry msg = null;
                    try {
                        msg = (Entry)JerseyBroadcaster.this.messages.take();
                        JerseyBroadcaster.this.bc.getExecutorService().submit(this);
                        if (!JerseyBroadcaster.this.delayedBroadcast.isEmpty()) {
                            Iterator i = JerseyBroadcaster.this.delayedBroadcast.iterator();
                            while (i.hasNext()) {
                                Entry e = (Entry)i.next();
                                try {
                                    Iterator i$ = JerseyBroadcaster.this.containerResponses.iterator();
                                    while (i$.hasNext()) {
                                        ContainerResponse r;
                                        ContainerResponse containerResponse = r = (ContainerResponse)i$.next();
                                        synchronized (containerResponse) {
                                            r.reset();
                                            r.setEntity(e.message);
                                            JerseyBroadcaster.this.broadcast(r);
                                        }
                                    }
                                }
                                finally {
                                    e.f.done();
                                    i.remove();
                                }
                            }
                        }
                        if (msg.eventsToPush != null) return;
                        Iterator i$ = JerseyBroadcaster.this.containerResponses.iterator();
                        while (i$.hasNext()) {
                            ContainerResponse r;
                            ContainerResponse containerResponse = r = (ContainerResponse)i$.next();
                            synchronized (containerResponse) {
                                r.reset();
                                r.setEntity(msg.message);
                                JerseyBroadcaster.this.broadcast(r);
                            }
                        }
                        return;
                    }
                    catch (InterruptedException ex) {
                        LoggerUtils.getLogger().log(Level.SEVERE, null, ex);
                        return;
                    }
                    finally {
                        if (msg != null) {
                            msg.f.done();
                        }
                    }
                }
            });
        }
    }

    private final void broadcast(ContainerResponse r) {
        try {
            r.write();
        }
        catch (IOException ex) {
            LoggerUtils.getLogger().log(Level.WARNING, "", ex);
        }
        catch (IllegalStateException ex) {
            LoggerUtils.getLogger().log(Level.WARNING, "", ex);
            this.containerResponses.remove(r);
        }
    }

    public BroadcasterFuture<Object> broadcast(Object msg) {
        this.start();
        msg = this.bc.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.messages.offer(new Entry(msg, null, f));
        return f;
    }

    public BroadcasterFuture<Object> broadcast(Object msg, AtmosphereResource r) {
        this.start();
        msg = this.bc.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.messages.offer(new Entry(msg, r, f));
        return f;
    }

    public BroadcasterFuture<Object> broadcast(Object msg, Set<AtmosphereResource> subset) {
        this.start();
        msg = this.bc.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.messages.offer(new Entry(msg, subset, f));
        return f;
    }

    @Override
    public AtmosphereResource addAtmosphereResource(AtmosphereResource r) {
        if (r.getRequest() instanceof HttpServletRequest) {
            this.containerResponses.add((ContainerResponse)((HttpServletRequest)r.getRequest()).getAttribute("cr"));
        }
        this.events.offer(r);
        return r;
    }

    @Override
    public AtmosphereResource removeAtmosphereResource(AtmosphereResource r) {
        if (r.getRequest() instanceof HttpServletRequest) {
            this.containerResponses.remove((ContainerResponse)((HttpServletRequest)r.getRequest()).getAttribute("cr"));
        }
        this.events.remove(r);
        return r;
    }

    @Override
    public void setBroadcasterConfig(BroadcasterConfig bc) {
        this.bc = bc;
    }

    @Override
    public BroadcasterConfig getBroadcasterConfig() {
        return this.bc;
    }

    @Override
    public Future<Object> delayBroadcast(final Object o, long delay, TimeUnit t) {
        if (t == null) {
            BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(o);
            this.delayedBroadcast.offer(new Entry(o, null, f));
            return f;
        }
        return this.bc.getScheduledExecutorService().schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JerseyBroadcaster.this.broadcast(o);
                return o;
            }
        }, delay, t);
    }

    @Override
    public Future<?> scheduleFixedBroadcast(final Object o, long period, TimeUnit t) {
        if (period == 0L || t == null) {
            return null;
        }
        return this.bc.getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

            public void run() {
                JerseyBroadcaster.this.broadcast(o);
            }
        }, 0L, period, t);
    }

    @Override
    public Future<Object> delayBroadcast(Object o) {
        return this.delayBroadcast(o, 0L, null);
    }

    private final class Entry {
        Object message;
        Object eventsToPush;
        BroadcasterFuture f;

        Entry(Object message, Object eventsToPush, BroadcasterFuture f) {
            this.message = message;
            this.eventsToPush = eventsToPush;
            this.f = f;
        }
    }
}

