/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet;

import com.sun.grizzly.http.servlet.CookieWrapper;
import com.sun.grizzly.http.servlet.HttpSessionImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.http.servlet.ServletInputStreamImpl;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlySession;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.http.Cookie;
import com.sun.grizzly.util.res.StringManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HttpServletRequestImpl
implements HttpServletRequest {
    private ServletInputStream inputStream = null;
    private HttpSessionImpl httpSession = null;
    private ServletContextImpl contextImpl;
    private String servletPath = "/";
    private Logger logger = LoggerUtils.getLogger();
    protected static final StringManager sm = StringManager.getManager("com.sun.grizzly.tcp.http11");
    protected GrizzlyRequest request = null;

    public HttpServletRequestImpl(GrizzlyRequest request) throws IOException {
        this.request = request;
        this.inputStream = new ServletInputStreamImpl(request.createInputStream());
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void clear() {
        this.request = null;
    }

    public Object getAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetAttributePrivilegedAction());
        }
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (String)AccessController.doPrivileged(new GetCharacterEncodingPrivilegedAction());
        }
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        this.request.setCharacterEncoding(env);
    }

    public int getContentLength() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getContentLength();
    }

    public String getContentType() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new ServletInputStreamImpl(this.request.createInputStream());
        }
        return this.inputStream;
    }

    void recycle() {
        if (System.getSecurityManager() != null) {
            this.inputStream = null;
        }
    }

    public String getParameter(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (String)AccessController.doPrivileged(new GetParameterPrivilegedAction(name));
        }
        return this.request.getParameter(name);
    }

    public Enumeration getParameterNames() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetParameterNamesPrivilegedAction());
        }
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        String[] ret = null;
        if (System.getSecurityManager() != null) {
            ret = (String[])AccessController.doPrivileged(new GetParameterValuePrivilegedAction(name));
            if (ret != null) {
                ret = (String[])ret.clone();
            }
        } else {
            ret = this.request.getParameterValues(name);
        }
        return ret;
    }

    public Map getParameterMap() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Map)AccessController.doPrivileged(new GetParameterMapPrivilegedAction());
        }
        return this.request.getParameterMap();
    }

    public String getProtocol() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getProtocol();
    }

    public String getScheme() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getScheme();
    }

    public String getServerName() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getServerName();
    }

    public int getServerPort() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getReader();
    }

    public String getRemoteAddr() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRemoteHost();
    }

    public void setAttribute(String name, Object value) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        Object oldValue = this.request.getAttribute(name);
        this.request.setAttribute(name, value);
        List<EventListener> listeners = this.contextImpl.getListeners();
        if (listeners.size() == 0) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        for (int i = 0; i < listeners.size(); ++i) {
            if (!(listeners.get(i) instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners.get(i);
            try {
                if (event == null) {
                    event = oldValue != null ? new ServletRequestAttributeEvent(this.contextImpl, this, name, oldValue) : new ServletRequestAttributeEvent(this.contextImpl, this, name, value);
                }
                if (oldValue != null) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "", t);
            }
        }
    }

    public void removeAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        Object value = this.request.getAttribute(name);
        this.request.removeAttribute(name);
        List<EventListener> listeners = this.contextImpl.getListeners();
        if (listeners.size() == 0) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        for (int i = 0; i < listeners.size(); ++i) {
            if (!(listeners.get(i) instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners.get(i);
            try {
                if (event == null) {
                    event = new ServletRequestAttributeEvent(this.contextImpl, this, name, value);
                }
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "", t);
            }
        }
    }

    public Locale getLocale() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Locale)AccessController.doPrivileged(new GetLocalePrivilegedAction());
        }
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetLocalesPrivilegedAction());
        }
        return this.request.getLocales();
    }

    public boolean isSecure() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getRealPath(String path) {
        return this.contextImpl.getRealPath(path);
    }

    public String getAuthType() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getAuthType();
    }

    public Cookie[] getGrizzlyCookies() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        Cookie[] ret = null;
        if (System.getSecurityManager() != null) {
            ret = (Cookie[])AccessController.doPrivileged(new GetCookiesPrivilegedAction());
            if (ret != null) {
                ret = (Cookie[])ret.clone();
            }
        } else {
            ret = this.request.getCookies();
        }
        return ret;
    }

    public long getDateHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getDateHeader(name);
    }

    public String getHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetHeadersPrivilegedAction(name));
        }
        return this.request.getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetHeaderNamesPrivilegedAction());
        }
        return this.request.getHeaderNames();
    }

    public int getIntHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getIntHeader(name);
    }

    public String getMethod() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getMethod();
    }

    public String getPathInfo() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        String path = this.request.getRequestURI();
        StringBuilder pathToRemove = new StringBuilder();
        pathToRemove.append(this.contextImpl.getContextPath());
        pathToRemove.append(this.getServletPath());
        String s = pathToRemove.toString();
        if (path.startsWith(s)) {
            String pathInfo = path.substring(s.length());
            return "".equals(pathInfo) ? null : pathInfo;
        }
        throw new IllegalStateException("Request path not in servlet context.");
    }

    public String getPathTranslated() {
        if (this.getPathInfo() == null) {
            return null;
        }
        return this.contextImpl.getRealPath(this.getPathInfo());
    }

    public String getContextPath() {
        return this.contextImpl.getContextPath();
    }

    public String getQueryString() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        throw new IllegalStateException("Not yet implemented");
    }

    public Principal getUserPrincipal() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRequestURL();
    }

    public String getServletPath() {
        return this.servletPath;
    }

    protected void initSession() {
        GrizzlySession session = this.request.getSession(false);
        if (session != null) {
            this.httpSession = new HttpSessionImpl(this.contextImpl);
            this.httpSession.notifyNew();
            this.httpSession.setSession(session);
            this.httpSession.access();
        }
    }

    public HttpSession getSession(boolean create) {
        GrizzlySession session;
        if (this.httpSession == null && create) {
            this.httpSession = new HttpSessionImpl(this.contextImpl);
        }
        if (this.httpSession != null && (session = this.request.getSession(create)) != null) {
            this.httpSession.setSession(session);
            this.httpSession.access();
        }
        return this.httpSession;
    }

    public HttpSession getSession() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public javax.servlet.http.Cookie[] getCookies() {
        Cookie[] internalCookies = this.request.getCookies();
        if (internalCookies == null) {
            return null;
        }
        javax.servlet.http.Cookie[] cookies = new javax.servlet.http.Cookie[internalCookies.length];
        for (int i = 0; i < internalCookies.length; ++i) {
            Cookie cook = internalCookies[i];
            if (cook instanceof CookieWrapper) {
                cookies[i] = ((CookieWrapper)internalCookies[i]).getWrappedCookie();
                continue;
            }
            cookies[i] = new javax.servlet.http.Cookie(cook.getName(), cook.getValue());
            cookies[i].setComment(cook.getComment());
            if (cook.getDomain() != null) {
                cookies[i].setDomain(cook.getDomain());
            }
            cookies[i].setMaxAge(cook.getMaxAge());
            cookies[i].setPath(cook.getPath());
            cookies[i].setSecure(cook.getSecure());
            cookies[i].setVersion(cook.getVersion());
        }
        return cookies;
    }

    public int getRemotePort() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRemotePort();
    }

    public String getLocalName() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getLocalName();
    }

    public String getLocalAddr() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getLocalAddr();
    }

    public int getLocalPort() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getLocalPort();
    }

    protected ServletContextImpl getContextImpl() {
        return this.contextImpl;
    }

    protected void setContextImpl(ServletContextImpl contextImpl) {
        this.contextImpl = contextImpl;
    }

    protected void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    private final class GetSessionPrivilegedAction
    implements PrivilegedAction {
        private boolean create;

        public GetSessionPrivilegedAction(boolean create) {
            this.create = create;
        }

        public Object run() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private final class GetLocalesPrivilegedAction
    implements PrivilegedAction {
        private GetLocalesPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getLocales();
        }
    }

    private final class GetLocalePrivilegedAction
    implements PrivilegedAction {
        private GetLocalePrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getLocale();
        }
    }

    private final class GetHeaderNamesPrivilegedAction
    implements PrivilegedAction {
        private GetHeaderNamesPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getHeaderNames();
        }
    }

    private final class GetHeadersPrivilegedAction
    implements PrivilegedAction {
        private String name;

        public GetHeadersPrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getHeaders(this.name);
        }
    }

    private final class GetCharacterEncodingPrivilegedAction
    implements PrivilegedAction {
        private GetCharacterEncodingPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getCharacterEncoding();
        }
    }

    private final class GetCookiesPrivilegedAction
    implements PrivilegedAction {
        private GetCookiesPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getCookies();
        }
    }

    private final class GetParameterValuePrivilegedAction
    implements PrivilegedAction {
        public String name;

        public GetParameterValuePrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getParameterValues(this.name);
        }
    }

    private final class GetParameterNamesPrivilegedAction
    implements PrivilegedAction {
        private GetParameterNamesPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getParameterNames();
        }
    }

    private final class GetParameterPrivilegedAction
    implements PrivilegedAction {
        public String name;

        public GetParameterPrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getParameter(this.name);
        }
    }

    private final class GetRequestDispatcherPrivilegedAction
    implements PrivilegedAction {
        private String path;

        public GetRequestDispatcherPrivilegedAction(String path) {
            this.path = path;
        }

        public Object run() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private final class GetParameterMapPrivilegedAction
    implements PrivilegedAction {
        private GetParameterMapPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getParameterMap();
        }
    }

    private final class GetAttributePrivilegedAction
    implements PrivilegedAction {
        private GetAttributePrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getAttributeNames();
        }
    }
}

