/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Grizzly {
    private static final Pattern versionPattern = Pattern.compile("((\\d+)\\.(\\d+)\\.(\\d+)){1}(?:-(.+))?");
    private static final String dotedVersion;
    private static final int major;
    private static final int minor;
    private static final int micro;
    private static final String version;

    public static void main(String[] args) {
        System.out.println(Grizzly.getDotedVersion());
    }

    public static String getRawVersion() {
        return version;
    }

    public static String getDotedVersion() {
        return dotedVersion;
    }

    public static int getMajorVersion() {
        return major;
    }

    public static int getMinorVersion() {
        return minor;
    }

    public static int getMicroVersion() {
        return micro;
    }

    public static boolean equalVersion(int major, int minor) {
        return minor == Grizzly.minor && major == Grizzly.major;
    }

    static {
        Properties prop = new Properties();
        try {
            prop.load(Grizzly.class.getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        version = prop.getProperty("grizzly.version");
        Matcher matcher = versionPattern.matcher(version);
        if (matcher.matches()) {
            dotedVersion = matcher.group(1);
            major = Integer.parseInt(matcher.group(2));
            minor = Integer.parseInt(matcher.group(3));
            micro = Integer.parseInt(matcher.group(4));
        } else {
            dotedVersion = "no.version";
            major = -1;
            minor = -1;
            micro = -1;
        }
    }
}

