/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;
import org.atmosphere.container.BlockingIOCometSupport;
import org.atmosphere.container.GoogleAppEngineCometSupport;
import org.atmosphere.container.JBossWebCometSupport;
import org.atmosphere.container.TomcatCometSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.cpr.CometSupportResolver;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.DefaultCometSupportResolver;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.util.AtmosphereConfigReader;
import org.atmosphere.util.BroadcasterLookup;
import org.atmosphere.util.IntrospectionUtils;
import org.atmosphere.util.LoggerUtils;
import org.atmosphere.util.Version;
import org.atmosphere.util.gae.GAEDefaultBroadcaster;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;

public class AtmosphereServlet
extends AbstractAsyncServlet
implements CometProcessor,
HttpEventServlet {
    private boolean useNativeImplementation = false;
    private boolean useBlockingImplementation = false;
    private boolean useStreamForFlushingComments = false;
    public static final String JERSEY_BROADCASTER = "org.atmosphere.jersey.JerseyBroadcaster";
    public static final String JERSEY_CONTAINER = "com.sun.jersey.spi.container.servlet.ServletContainer";
    public static final String GAE_BROADCASTER = GAEDefaultBroadcaster.class.getName();
    public static final String PROPERTY_SERVLET_MAPPING = "org.atmosphere.jersey.servlet-mapping";
    public static final String PROPERTY_BLOCKING_COMETSUPPORT = "org.atmosphere.useBlocking";
    public static final String PROPERTY_NATIVE_COMETSUPPORT = "org.atmosphere.useNative";
    public static final String PROPERTY_USE_STREAM = "org.atmosphere.useStream";
    public static final String BROADCASTER_TYPE = "org.atmosphere.cpr.broadcasterType";
    public static final String PROPERTY_COMET_SUPPORT = "org.atmosphere.cpr.cometSupport";
    public static final String PRIMEFACES_SERVLET = "org.primefaces.comet.PrimeFacesCometServlet";
    public static final String DISABLE_ONSTATE_EVENT = "org.atmosphere.disableOnStateEvent";
    public static final Logger logger = LoggerUtils.getLogger();
    private ArrayList<String> possibleAtmosphereHandlersCandidate = new ArrayList();
    private static final String WEB_INF = "/WEB-INF/classes/";
    private HashMap<String, String> initParams = new HashMap();
    protected Map<String, AtmosphereHandlerWrapper> atmosphereHandlers = new HashMap<String, AtmosphereHandlerWrapper>();
    protected CometSupport cometSupport;
    protected AtmosphereConfig config;
    private boolean isFilter = false;
    private String broadcasterClassName = DefaultBroadcaster.class.getName();
    private AtomicBoolean isCometSupportConfigured = new AtomicBoolean(false);
    private boolean isCometSupportSpecified = false;

    public AtmosphereConfig newAtmosphereConfig(boolean supportSession) {
        AtmosphereConfig c = new AtmosphereConfig();
        c.supportSession = supportSession;
        return c;
    }

    public AtmosphereServlet() {
        if (System.getProperty(PROPERTY_NATIVE_COMETSUPPORT) != null) {
            this.useNativeImplementation = Boolean.parseBoolean(System.getProperty(PROPERTY_NATIVE_COMETSUPPORT));
            this.isCometSupportSpecified = true;
        }
        if (System.getProperty(PROPERTY_BLOCKING_COMETSUPPORT) != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(System.getProperty(PROPERTY_BLOCKING_COMETSUPPORT));
            this.isCometSupportSpecified = true;
        }
        if (System.getProperty(DISABLE_ONSTATE_EVENT) != null) {
            this.initParams.put(DISABLE_ONSTATE_EVENT, System.getProperty(DISABLE_ONSTATE_EVENT));
        }
    }

    public AtmosphereServlet(boolean isFilter) {
        this();
        this.isFilter = isFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAtmosphereHandler(String mapping, AtmosphereHandler h) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h);
        this.atmosphereHandlers.put(mapping, w);
        try {
            w.broadcaster = (Broadcaster)this.getClass().getClassLoader().loadClass(this.broadcasterClassName).newInstance();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Unable to load Broadcaster class: " + this.broadcasterClassName, t);
        }
        finally {
            if (w.broadcaster == null) {
                w.broadcaster = new DefaultBroadcaster();
            }
        }
    }

    public void addInitParameter(String name, String value) {
        this.initParams.put(name, value);
    }

    public void init(ServletConfig sc) throws ServletException {
        try {
            super.init(sc);
            this.config = new AtmosphereConfig();
            this.doInitParams(sc);
            this.detectGoogleAppEngine(sc);
            this.loadConfiguration(sc);
            this.autoDetectContainer();
            this.cometSupport.init(sc);
            this.initAtmosphereServletProcessor(sc);
            logger.log(Level.INFO, "Atmosphere Framework " + Version.getRawVersion() + " started.");
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "", t);
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t.getCause());
        }
    }

    protected void doInitParams(ServletConfig sc) {
        this.initParams.put(DISABLE_ONSTATE_EVENT, "false");
        String s = sc.getInitParameter(PROPERTY_NATIVE_COMETSUPPORT);
        if (s != null) {
            this.useNativeImplementation = Boolean.parseBoolean(s);
            if (this.useNativeImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter(PROPERTY_BLOCKING_COMETSUPPORT)) != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(s);
            if (this.useBlockingImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter(PROPERTY_USE_STREAM)) != null) {
            this.useStreamForFlushingComments = Boolean.parseBoolean(s);
        }
        if ((s = sc.getInitParameter(PROPERTY_COMET_SUPPORT)) != null) {
            this.cometSupport = new DefaultCometSupportResolver(this.config).newCometSupport(s);
            this.isCometSupportSpecified = true;
        }
    }

    protected void loadConfiguration(ServletConfig sc) throws ServletException {
        try {
            URL url = sc.getServletContext().getResource(WEB_INF);
            URLClassLoader urlC = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            this.loadAtmosphereDotXml(sc.getServletContext().getResourceAsStream("/META-INF/atmosphere.xml"), urlC);
            if (this.atmosphereHandlers.size() == 0) {
                logger.warning("Missing META-INF/atmosphere.xml. Will try to autodetect AtmosphereHandler");
                this.autoDetectAtmosphereHandlers(sc.getServletContext(), urlC);
                if (this.atmosphereHandlers.size() == 0) {
                    this.detectJerseyRuntime(sc);
                }
            }
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    protected boolean detectJerseyRuntime(ServletConfig sc) {
        try {
            Class.forName(PRIMEFACES_SERVLET);
            return false;
        }
        catch (Throwable t) {
            try {
                Class.forName(JERSEY_CONTAINER);
                this.useStreamForFlushingComments = true;
            }
            catch (Throwable t2) {
                return false;
            }
            logger.warning("Missing META-INF/atmosphere.xml but found the Jersey runtime. Starting Jersey");
            ReflectorServletProcessor rsp = new ReflectorServletProcessor();
            this.broadcasterClassName = JERSEY_BROADCASTER;
            rsp.setServletClassName(JERSEY_CONTAINER);
            this.config.supportSession = false;
            this.initParams.put(DISABLE_ONSTATE_EVENT, "true");
            String mapping = sc.getInitParameter(PROPERTY_SERVLET_MAPPING);
            if (mapping == null) {
                mapping = "/*";
            }
            this.addAtmosphereHandler(mapping, rsp);
            return true;
        }
    }

    boolean detectGoogleAppEngine(ServletConfig sc) {
        if (sc.getServletContext().getServerInfo().startsWith("Google")) {
            this.broadcasterClassName = GAE_BROADCASTER;
            this.cometSupport = new GoogleAppEngineCometSupport(this.config);
            return true;
        }
        return false;
    }

    void initAtmosphereServletProcessor(ServletConfig sc) throws ServletException {
        for (Map.Entry<String, AtmosphereHandlerWrapper> h : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandler a = h.getValue().atmosphereHandler;
            if (!(a instanceof AtmosphereServletProcessor)) continue;
            ((AtmosphereServletProcessor)a).init(sc);
        }
    }

    public void destroy() {
        if (this.cometSupport instanceof AsynchronousProcessor) {
            ((AsynchronousProcessor)this.cometSupport).shutdown();
        }
        for (Map.Entry<String, AtmosphereHandlerWrapper> h : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandler a = h.getValue().atmosphereHandler;
            if (!(a instanceof AtmosphereServletProcessor)) continue;
            ((AtmosphereServletProcessor)a).destroy();
        }
        BroadcasterLookup.destroy();
    }

    protected void loadAtmosphereDotXml(InputStream stream, URLClassLoader c) throws IOException, ServletException {
        if (stream == null) {
            return;
        }
        AtmosphereConfigReader reader = new AtmosphereConfigReader(stream);
        Map<String, String> atmosphereHandlerNames = reader.getAtmosphereHandlers();
        Set<Map.Entry<String, String>> entries = atmosphereHandlerNames.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            try {
                AtmosphereHandler<HttpServletRequest, HttpServletResponse> g = !entry.getValue().equals(ReflectorServletProcessor.class.getName()) ? (AtmosphereHandler)c.loadClass(entry.getValue()).newInstance() : new ReflectorServletProcessor();
                logger.info("Sucessfully loaded " + g + " mapped to context-path " + entry.getKey());
                AtmosphereHandlerWrapper wrapper = new AtmosphereHandlerWrapper(g);
                this.atmosphereHandlers.put(entry.getKey(), wrapper);
                boolean isJersey = false;
                for (AtmosphereConfigReader.Property p : reader.getProperty(entry.getKey())) {
                    if (p.value != null && p.value.indexOf("jersey") != -1) {
                        isJersey = true;
                        this.initParams.put(DISABLE_ONSTATE_EVENT, "true");
                        this.useStreamForFlushingComments = true;
                    }
                    IntrospectionUtils.setProperty(g, p.name, p.value);
                }
                boolean bl = this.config.supportSession = !isJersey;
                if (!reader.supportSession().equals("")) {
                    this.config.supportSession = Boolean.valueOf(reader.supportSession());
                }
                for (AtmosphereConfigReader.Property p : reader.getProperty(entry.getKey())) {
                    IntrospectionUtils.addProperty(g, p.name, p.value);
                }
                String broadcasterClass = reader.getBroadcasterClass(entry.getKey());
                if (broadcasterClass != null) {
                    wrapper.broadcaster = (Broadcaster)c.loadClass(broadcasterClass).newInstance();
                }
                if (!isJersey && wrapper.broadcaster == null) {
                    wrapper.broadcaster = (Broadcaster)c.loadClass(this.broadcasterClassName).newInstance();
                } else if (broadcasterClass == null) {
                    this.broadcasterClassName = JERSEY_BROADCASTER;
                    wrapper.broadcaster = (Broadcaster)c.loadClass(JERSEY_BROADCASTER).newInstance();
                }
                if (reader.getCometSupportClass() != null) {
                    this.cometSupport = (CometSupport)c.loadClass(reader.getCometSupportClass()).newInstance();
                }
                logger.info("Using " + wrapper.broadcaster.getClass().getName() + " with a Thread Pool size of : " + BroadcasterConfig.numOfProcessor);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Unable to load AtmosphereHandler class: " + entry.getValue(), t);
                throw new ServletException(t);
            }
        }
    }

    public void setCometSupport(CometSupport cometSupport) {
        this.cometSupport = cometSupport;
    }

    public CometSupport getCometSupport() {
        return this.cometSupport;
    }

    protected CometSupportResolver createCometSupportResolver() {
        return new DefaultCometSupportResolver(this.config);
    }

    protected void autoDetectContainer() {
        if (this.getCometSupport() == null) {
            this.setCometSupport(this.createCometSupportResolver().resolve(this.useNativeImplementation, this.useBlockingImplementation));
        }
        logger.info("Atmosphere is using for CometSupport: " + this.getCometSupport().getClass().getName() + " running under container " + this.cometSupport.getContainerName());
    }

    protected void autoDetectAtmosphereHandlers(ServletContext sc, URLClassLoader c) throws MalformedURLException, URISyntaxException {
        File f;
        String s = sc.getRealPath(WEB_INF);
        if (s == null) {
            URL u = sc.getResource(WEB_INF);
            if (u == null) {
                return;
            }
            s = u.getPath();
        }
        if ((f = new File(s)).isDirectory()) {
            this.getFiles(f);
            for (String className : this.possibleAtmosphereHandlersCandidate) {
                try {
                    className = className.replace('\\', '/');
                    className = className.substring(className.indexOf(WEB_INF) + WEB_INF.length(), className.lastIndexOf(".")).replace('/', '.');
                    AtmosphereHandler g = (AtmosphereHandler)c.loadClass(className).newInstance();
                    logger.info("Sucessfully loaded " + g + " mapped to context-path " + g.getClass().getSimpleName());
                    this.atmosphereHandlers.put("/" + g.getClass().getSimpleName(), new AtmosphereHandlerWrapper(g, (Broadcaster)c.loadClass(this.broadcasterClassName).newInstance()));
                }
                catch (Throwable t) {
                    logger.finest(className + " is not a AtmosphereHandler");
                }
            }
        }
        logger.info("Atmosphere using Broadcaster " + this.broadcasterClassName);
    }

    void getFiles(File f) {
        File[] files;
        for (File test : files = f.listFiles()) {
            if (test.isDirectory()) {
                this.getFiles(test);
                continue;
            }
            String clazz = test.getAbsolutePath();
            if (!clazz.endsWith(".class")) continue;
            this.possibleAtmosphereHandlersCandidate.add(clazz);
        }
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doCometSupport(req, res);
    }

    protected Action doCometSupport(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.setAttribute(BROADCASTER_TYPE, this.broadcasterClassName);
        req.setAttribute(PROPERTY_USE_STREAM, this.useStreamForFlushingComments);
        try {
            return this.cometSupport.service(req, res);
        }
        catch (IllegalStateException ex) {
            if (ex.getMessage() != null && ex.getMessage().startsWith("Tomcat failed")) {
                if (!this.isFilter) {
                    logger.warning(ex.getMessage());
                    logger.warning("Using the BlockingIOCometSupport.");
                }
            } else {
                logger.log(Level.SEVERE, "AtmosphereServlet exception", ex);
                throw ex;
            }
            this.cometSupport = new BlockingIOCometSupport(this.config);
            this.service(req, res);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(CometEvent cometEvent) throws IOException, ServletException {
        HttpServletRequest req = cometEvent.getHttpServletRequest();
        HttpServletResponse res = cometEvent.getHttpServletResponse();
        req.setAttribute("CometEvent", cometEvent);
        if (!this.isCometSupportSpecified && !this.isCometSupportConfigured.getAndSet(true)) {
            CometSupport cometSupport = this.cometSupport;
            synchronized (cometSupport) {
                if (!this.cometSupport.getClass().equals(TomcatCometSupport.class)) {
                    logger.warning("TomcatCometSupport is enabled, switching to it");
                    this.cometSupport = new TomcatCometSupport(this.config);
                }
            }
        }
        this.doCometSupport(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(HttpEvent httpEvent) throws IOException, ServletException {
        HttpServletRequest req = httpEvent.getHttpServletRequest();
        HttpServletResponse res = httpEvent.getHttpServletResponse();
        req.setAttribute("HttpEvent", httpEvent);
        if (!this.isCometSupportSpecified && !this.isCometSupportConfigured.getAndSet(true)) {
            CometSupport cometSupport = this.cometSupport;
            synchronized (cometSupport) {
                if (!this.cometSupport.getClass().equals(JBossWebCometSupport.class)) {
                    logger.warning("JBossWebCometSupport is enabled, switching to it");
                    this.cometSupport = new JBossWebCometSupport(this.config);
                }
            }
        }
        this.doCometSupport(req, res);
    }

    protected boolean doRequest(RequestResponseKey rrk) throws IOException, ServletException {
        try {
            rrk.getRequest().getSession().setAttribute("RequestResponseKey", rrk);
            Action action = this.doCometSupport(rrk.getRequest(), rrk.getResponse());
            if (action.type == Action.TYPE.SUSPEND) {
                if (action.timeout == -1L) {
                    rrk.setTimeout(Integer.MAX_VALUE);
                } else {
                    rrk.setTimeout((int)action.timeout);
                }
            }
            return action.type == Action.TYPE.SUSPEND;
        }
        catch (IllegalStateException ex) {
            logger.log(Level.SEVERE, "AtmosphereServlet.doRequest exception", ex);
            throw ex;
        }
    }

    protected void doResponse(RequestResponseKey rrk, Object context) throws IOException, ServletException {
        rrk.getResponse().flushBuffer();
    }

    protected void doTimeout(RequestResponseKey rrk) throws IOException, ServletException {
        ((AsynchronousProcessor)this.cometSupport).timedout(rrk.getRequest(), rrk.getResponse());
    }

    public String getDefaultBroadcasterClassName() {
        return this.broadcasterClassName;
    }

    public void setDefaultBroadcasterClassName(String broadcasterClassName) {
        this.broadcasterClassName = broadcasterClassName;
    }

    public boolean isUseStreamForFlushingComments() {
        return this.useStreamForFlushingComments;
    }

    public void setUseStreamForFlushingComments(boolean useStreamForFlushingComments) {
        this.useStreamForFlushingComments = useStreamForFlushingComments;
    }

    public static class Action {
        public long timeout = -1L;
        public TYPE type;

        public Action() {
            this.type = TYPE.NONE;
        }

        public Action(TYPE type) {
            this.type = type;
        }

        public Action(TYPE type, long timeout) {
            this.timeout = timeout;
            this.type = type;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TYPE {
            SUSPEND,
            RESUME,
            NONE,
            CANCEL;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AtmosphereConfig {
        protected boolean supportSession = true;
        protected AtmosphereHandler ah;
        private BroadcasterLookup bl = new BroadcasterLookup();

        protected Map<String, AtmosphereHandlerWrapper> handlers() {
            return AtmosphereServlet.this.atmosphereHandlers;
        }

        public ServletContext getServletContext() {
            return AtmosphereServlet.this.getServletContext();
        }

        public String getInitParameter(String name) {
            String s = (String)AtmosphereServlet.this.initParams.get(name);
            if (s != null) {
                return s;
            }
            return AtmosphereServlet.this.getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return AtmosphereServlet.this.getInitParameterNames();
        }

        public ServletConfig getServletConfig() {
            return AtmosphereServlet.this.getServletConfig();
        }

        public String getWebServerName() {
            return AtmosphereServlet.this.cometSupport.getContainerName();
        }

        public AtmosphereHandler getAtmosphereHandler() {
            return this.ah;
        }

        public BroadcasterLookup getBroadcasterLookup() {
            return this.bl;
        }
    }

    public static class AtmosphereHandlerWrapper {
        public final AtmosphereHandler atmosphereHandler;
        public Broadcaster broadcaster;

        public AtmosphereHandlerWrapper(AtmosphereHandler g) {
            this.atmosphereHandler = g;
        }

        public AtmosphereHandlerWrapper(AtmosphereHandler g, Broadcaster b) {
            this.atmosphereHandler = g;
            this.broadcaster = b;
        }
    }
}

