/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey.util;

import com.sun.jersey.spi.container.ContainerResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.jersey.AtmosphereFilter;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JerseyBroadcasterUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void broadcast(AtmosphereResource r, AtmosphereResourceEvent e) {
        HttpServletRequest res = (HttpServletRequest)r.getRequest();
        try {
            try {
                ContainerResponse cr = (ContainerResponse)res.getAttribute("cr");
                if (e.getMessage() instanceof Response) {
                    cr.setResponse((Response)e.getMessage());
                    cr.write();
                } else {
                    cr.reset();
                    cr.setEntity(e.getMessage());
                    cr.write();
                    cr.getOutputStream().flush();
                }
                JerseyBroadcasterUtil.notifyListener(r, e);
            }
            catch (Throwable t) {
                JerseyBroadcasterUtil.onException(t, r);
                Object var5_6 = null;
                Boolean resumeOnBroadcast = (Boolean)res.getAttribute("org.atmosphere.resumeOnBroadcast");
                if (resumeOnBroadcast == null) return;
                if (resumeOnBroadcast == false) return;
                String uuid = (String)res.getAttribute("org.atmosphere.jersey.uuid");
                if (uuid != null && res.getAttribute("org.atmosphere.jersey.resumeCandidates") != null) {
                    ((ConcurrentHashMap)res.getAttribute("org.atmosphere.jersey.resumeCandidates")).remove(uuid);
                }
                JerseyBroadcasterUtil.notifyListener(r, new AtmosphereResourceEventImpl((AtmosphereResourceImpl)r, false, true));
                r.resume();
                JerseyBroadcasterUtil.removeListener(r, (ArrayList)res.getAttribute(AtmosphereFilter.LISTENERS));
                return;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            Boolean resumeOnBroadcast = (Boolean)res.getAttribute("org.atmosphere.resumeOnBroadcast");
            if (resumeOnBroadcast == null) throw throwable;
            if (resumeOnBroadcast == false) throw throwable;
            String uuid = (String)res.getAttribute("org.atmosphere.jersey.uuid");
            if (uuid != null && res.getAttribute("org.atmosphere.jersey.resumeCandidates") != null) {
                ((ConcurrentHashMap)res.getAttribute("org.atmosphere.jersey.resumeCandidates")).remove(uuid);
            }
            JerseyBroadcasterUtil.notifyListener(r, new AtmosphereResourceEventImpl((AtmosphereResourceImpl)r, false, true));
            r.resume();
            JerseyBroadcasterUtil.removeListener(r, (ArrayList)res.getAttribute(AtmosphereFilter.LISTENERS));
            throw throwable;
        }
        Boolean resumeOnBroadcast = (Boolean)res.getAttribute("org.atmosphere.resumeOnBroadcast");
        if (resumeOnBroadcast == null) return;
        if (resumeOnBroadcast == false) return;
        String uuid = (String)res.getAttribute("org.atmosphere.jersey.uuid");
        if (uuid != null && res.getAttribute("org.atmosphere.jersey.resumeCandidates") != null) {
            ((ConcurrentHashMap)res.getAttribute("org.atmosphere.jersey.resumeCandidates")).remove(uuid);
        }
        JerseyBroadcasterUtil.notifyListener(r, new AtmosphereResourceEventImpl((AtmosphereResourceImpl)r, false, true));
        r.resume();
        JerseyBroadcasterUtil.removeListener(r, (ArrayList)res.getAttribute(AtmosphereFilter.LISTENERS));
    }

    static final void notifyListener(AtmosphereResource<HttpServletRequest, HttpServletResponse> r, AtmosphereResourceEvent e) {
        AtmosphereHandler s = r.getAtmosphereConfig().getAtmosphereHandler();
        if (s instanceof ReflectorServletProcessor) {
            ((ReflectorServletProcessor)s).notifyListeners(e);
        }
    }

    static final void removeListener(AtmosphereResource<HttpServletRequest, HttpServletResponse> r, ArrayList<AtmosphereResourceEventListener> l) {
        AtmosphereHandler s = r.getAtmosphereConfig().getAtmosphereHandler();
        if (l != null) {
            for (AtmosphereResourceEventListener a : l) {
                ((ReflectorServletProcessor)s).removeEventListener(a);
            }
        }
    }

    static final void onException(Throwable t, AtmosphereResource r) {
        if (LoggerUtils.getLogger().isLoggable(Level.FINE)) {
            LoggerUtils.getLogger().log(Level.FINE, "", t);
        }
        if (t instanceof IOException && r instanceof AtmosphereResourceImpl) {
            JerseyBroadcasterUtil.notifyListener(r, new AtmosphereResourceEventImpl((AtmosphereResourceImpl)r, true, false));
            JerseyBroadcasterUtil.removeListener(r, (ArrayList)((AtmosphereResourceImpl)r).getRequest().getAttribute(AtmosphereFilter.LISTENERS));
        }
        r.getBroadcaster().removeAtmosphereResource(r);
    }
}

