/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.CallbackHandlerContextTask;
import com.sun.grizzly.CallbackHandlerDescriptor;
import com.sun.grizzly.CallbackHandlerSelectionKeyAttachment;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorInstanceHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.LinuxSpinningWorkaround;
import com.sun.grizzly.NIOContext;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.Role;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectionKeyOP;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.SelectorHandlerRunner;
import com.sun.grizzly.TCPConnectorHandler;
import com.sun.grizzly.async.AsyncQueueReader;
import com.sun.grizzly.async.AsyncQueueWriter;
import com.sun.grizzly.async.TCPAsyncQueueReader;
import com.sun.grizzly.async.TCPAsyncQueueWriter;
import com.sun.grizzly.util.Cloner;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.LinkedTransferQueue;
import com.sun.grizzly.util.SelectionKeyAttachment;
import com.sun.grizzly.util.State;
import com.sun.grizzly.util.StateHolder;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPSelectorHandler
implements SelectorHandler,
LinuxSpinningWorkaround {
    private int maxAcceptRetries = 5;
    protected ConnectorInstanceHandler connectorInstanceHandler;
    protected final LinkedTransferQueue<SelectionKeyOP> opToRegister = new LinkedTransferQueue();
    private final LinkedTransferQueue<SelectionKey> readOpToRegister = new LinkedTransferQueue();
    private final LinkedTransferQueue<SelectionKey> writeOpToRegister = new LinkedTransferQueue();
    private final LinkedTransferQueue<SelectionKey> readWriteOpToRegister = new LinkedTransferQueue();
    private List pendingIO = new ArrayList();
    private int pendingIOlimitPerThread = 100;
    private boolean finishIOUsingCurrentThread = true;
    protected boolean tcpNoDelay = true;
    protected boolean reuseAddress = true;
    protected int linger = -1;
    protected int socketTimeout = -1;
    protected Logger logger;
    protected int serverTimeout = 0;
    protected InetAddress inet;
    protected int port = 18888;
    protected ServerSocket serverSocket;
    protected ServerSocketChannel serverSocketChannel;
    protected Selector selector;
    protected long selectTimeout = 1000L;
    protected int ssBackLog = 4096;
    protected Role role = Role.CLIENT_SERVER;
    protected SelectionKeyHandler selectionKeyHandler;
    protected ProtocolChainInstanceHandler instanceHandler;
    protected ExecutorService threadPool;
    protected AsyncQueueWriter asyncQueueWriter;
    protected AsyncQueueReader asyncQueueReader;
    protected Map<String, Object> attributes;
    protected StateHolder<State> stateHolder = new StateHolder(true);
    protected final AtomicBoolean isShutDown = new AtomicBoolean(false);
    private long lastSpinTimestamp;
    private int emptySpinCounter;
    private final WeakHashMap<Selector, Long> spinnedSelectorsHistory;
    private final Object spinSync;
    protected int sendBufferSize = -1;
    protected int receiveBufferSize = -1;

    public TCPSelectorHandler() {
        this(Role.CLIENT_SERVER);
    }

    public TCPSelectorHandler(boolean isClient) {
        this(TCPSelectorHandler.boolean2Role(isClient));
    }

    public TCPSelectorHandler(Role role) {
        this.role = role;
        this.logger = Controller.logger();
        if (Controller.isLinux) {
            this.spinnedSelectorsHistory = new WeakHashMap();
            this.spinSync = new Object();
        } else {
            this.spinnedSelectorsHistory = null;
            this.spinSync = null;
        }
    }

    @Override
    public void copyTo(Copyable copy) {
        TCPSelectorHandler copyHandler = (TCPSelectorHandler)copy;
        copyHandler.selector = this.selector;
        if (this.selectionKeyHandler != null) {
            copyHandler.setSelectionKeyHandler(Cloner.clone(this.selectionKeyHandler));
        }
        copyHandler.instanceHandler = this.instanceHandler;
        copyHandler.attributes = this.attributes;
        copyHandler.selectTimeout = this.selectTimeout;
        copyHandler.serverTimeout = this.serverTimeout;
        copyHandler.inet = this.inet;
        copyHandler.port = this.port;
        copyHandler.ssBackLog = this.ssBackLog;
        copyHandler.tcpNoDelay = this.tcpNoDelay;
        copyHandler.linger = this.linger;
        copyHandler.socketTimeout = this.socketTimeout;
        copyHandler.logger = this.logger;
        copyHandler.reuseAddress = this.reuseAddress;
        copyHandler.connectorInstanceHandler = this.connectorInstanceHandler;
        copyHandler.stateHolder = this.stateHolder;
        copyHandler.finishIOUsingCurrentThread = this.finishIOUsingCurrentThread;
        copyHandler.pendingIOlimitPerThread = this.pendingIOlimitPerThread;
    }

    @Override
    public Set<SelectionKey> keys() {
        if (this.selector != null) {
            return this.selector.keys();
        }
        throw new IllegalStateException("Selector is not created!");
    }

    @Override
    public boolean isOpen() {
        if (this.selector != null) {
            return this.selector.isOpen();
        }
        return false;
    }

    @Override
    public void preSelect(Context ctx) throws IOException {
        if (this.asyncQueueReader == null) {
            this.asyncQueueReader = new TCPAsyncQueueReader(this);
        }
        if (this.asyncQueueWriter == null) {
            this.asyncQueueWriter = new TCPAsyncQueueWriter(this);
        }
        if (this.selector == null) {
            this.initSelector(ctx);
        } else {
            this.processPendingOperations(ctx);
        }
    }

    private final void initSelector(Context ctx) throws IOException {
        try {
            this.isShutDown.set(false);
            this.connectorInstanceHandler = new ConnectorInstanceHandler.ConcurrentQueueDelegateCIH<ConnectorHandler>(this.getConnectorInstanceHandlerDelegate());
            this.selector = Selector.open();
            if (this.role != Role.CLIENT) {
                block10: {
                    this.serverSocketChannel = ServerSocketChannel.open();
                    this.serverSocket = this.serverSocketChannel.socket();
                    if (this.receiveBufferSize > 0) {
                        try {
                            this.serverSocket.setReceiveBufferSize(this.receiveBufferSize);
                        }
                        catch (SocketException se) {
                            if (this.logger.isLoggable(Level.FINE)) {
                                this.logger.log(Level.FINE, "setReceiveBufferSize exception ", se);
                            }
                        }
                        catch (IllegalArgumentException iae) {
                            if (!this.logger.isLoggable(Level.FINE)) break block10;
                            this.logger.log(Level.FINE, "setReceiveBufferSize exception ", iae);
                        }
                    }
                }
                this.serverSocket.setReuseAddress(this.reuseAddress);
                if (this.inet == null) {
                    this.serverSocket.bind(new InetSocketAddress(this.port), this.ssBackLog);
                } else {
                    this.serverSocket.bind(new InetSocketAddress(this.inet, this.port), this.ssBackLog);
                }
                this.serverSocketChannel.configureBlocking(false);
                this.serverSocketChannel.register(this.selector, 16);
                this.serverSocket.setSoTimeout(this.serverTimeout);
                this.port = this.serverSocket.getLocalPort();
            }
            ctx.getController().notifyReady();
        }
        catch (SocketException ex) {
            throw new BindException(ex.getMessage() + ": " + this.port + "=" + this);
        }
    }

    protected void processPendingOperations(Context ctx) throws IOException {
        SelectionKey key;
        SelectionKeyOP operation;
        while ((operation = this.opToRegister.poll()) != null) {
            int op = operation.getOp();
            if ((op & 8) != 0) {
                this.onConnectOp(ctx, (SelectionKeyOP.ConnectSelectionKeyOP)operation);
                continue;
            }
            SelectableChannel channel = operation.getChannel();
            if (!channel.isOpen()) continue;
            this.selectionKeyHandler.register(channel, op);
        }
        while ((key = this.readWriteOpToRegister.poll()) != null) {
            if (Controller.isLinux) {
                key = this.checkIfSpinnedKey(key);
            }
            this.selectionKeyHandler.register(key, 5);
        }
        while ((key = this.writeOpToRegister.poll()) != null) {
            if (Controller.isLinux) {
                key = this.checkIfSpinnedKey(key);
            }
            this.selectionKeyHandler.register(key, 4);
        }
        while ((key = this.readOpToRegister.poll()) != null) {
            if (Controller.isLinux) {
                key = this.checkIfSpinnedKey(key);
            }
            this.selectionKeyHandler.register(key, 1);
        }
    }

    private SelectionKey checkIfSpinnedKey(SelectionKey key) {
        if (!key.isValid() && key.channel().isOpen() && this.spinnedSelectorsHistory.containsKey(key.selector())) {
            SelectionKey newKey = key.channel().keyFor(this.selector);
            newKey.attach(key.attachment());
            return newKey;
        }
        return key;
    }

    protected void onConnectOp(Context ctx, SelectionKeyOP.ConnectSelectionKeyOP selectionKeyOp) throws IOException {
        boolean isConnected;
        SocketChannel socketChannel = (SocketChannel)selectionKeyOp.getChannel();
        SocketAddress remoteAddress = selectionKeyOp.getRemoteAddress();
        CallbackHandler callbackHandler = selectionKeyOp.getCallbackHandler();
        CallbackHandlerSelectionKeyAttachment attachment = new CallbackHandlerSelectionKeyAttachment(callbackHandler);
        SelectionKey key = socketChannel.register(this.selector, 0, attachment);
        attachment.associateKey(key);
        try {
            isConnected = socketChannel.connect(remoteAddress);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Exception occured when tried to connect socket", e);
            }
            isConnected = true;
        }
        if (isConnected) {
            this.onConnectInterest(key, ctx);
        } else {
            key.interestOps(8);
        }
    }

    @Override
    public Set<SelectionKey> select(Context ctx) throws IOException {
        this.selector.select(this.selectTimeout);
        return this.selector.selectedKeys();
    }

    @Override
    public void postSelect(Context ctx) {
        this.selectionKeyHandler.expire(this.keys().iterator());
        if (this.pendingIO.size() > 0) {
            List tasks = this.pendingIO;
            this.pendingIO = new ArrayList();
            int size = tasks.size();
            int x = 0;
            while (x < size) {
                ctx.getController().executeUsingKernelExecutor(this.doExecutePendiongIO(tasks, x, Math.min(x += this.pendingIOlimitPerThread, size)));
            }
        }
    }

    private Runnable doExecutePendiongIO(final List tasks, final int start, final int end) {
        Runnable r = new Runnable(){

            public void run() {
                for (int i = start; i < end; ++i) {
                    Object obj = tasks.get(i);
                    try {
                        if (obj instanceof SelectionKey) {
                            TCPSelectorHandler.this.selectionKeyHandler.close((SelectionKey)obj);
                            continue;
                        }
                        ((Runnable)obj).run();
                        continue;
                    }
                    catch (Throwable t) {
                        TCPSelectorHandler.this.logger.log(Level.FINEST, "doExecutePendiongIO failed.", t);
                    }
                }
            }
        };
        return r;
    }

    @Override
    public void addPendingIO(Runnable runnable) {
        if (this.finishIOUsingCurrentThread) {
            runnable.run();
        } else {
            this.pendingIO.add(runnable);
        }
    }

    @Override
    public void addPendingKeyCancel(SelectionKey key) {
        if (this.finishIOUsingCurrentThread) {
            this.selectionKeyHandler.cancel(key);
        } else {
            this.pendingIO.add(key);
        }
    }

    @Override
    public void register(SelectionKey key, int ops) {
        if (key == null) {
            throw new NullPointerException("SelectionKey parameter is null");
        }
        switch (ops) {
            case 1: {
                this.readOpToRegister.offer(key);
                break;
            }
            case 4: {
                this.writeOpToRegister.offer(key);
                break;
            }
            case 5: {
                this.readWriteOpToRegister.offer(key);
                break;
            }
            default: {
                this.opToRegister.offer(new SelectionKeyOP(key, ops));
            }
        }
        this.wakeUp();
    }

    @Override
    public void register(SelectableChannel channel, int ops) {
        if (channel == null) {
            throw new NullPointerException("SelectableChannel parameter is null");
        }
        this.opToRegister.offer(new SelectionKeyOP(null, ops, channel));
        this.wakeUp();
    }

    private void wakeUp() {
        try {
            this.selector.wakeup();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler) throws IOException {
        SelectableChannel selectableChannel = this.getSelectableChannel(remoteAddress, localAddress);
        SelectionKeyOP.ConnectSelectionKeyOP keyOP = new SelectionKeyOP.ConnectSelectionKeyOP();
        keyOP.setOp(8);
        keyOP.setChannel(selectableChannel);
        keyOP.setRemoteAddress(remoteAddress);
        keyOP.setCallbackHandler(callbackHandler);
        this.opToRegister.offer(keyOP);
        this.wakeUp();
    }

    protected SelectableChannel getSelectableChannel(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        Socket newSocket;
        SocketChannel newSocketChannel;
        block12: {
            block11: {
                newSocketChannel = SocketChannel.open();
                newSocket = newSocketChannel.socket();
                if (this.receiveBufferSize > 0) {
                    try {
                        newSocket.setReceiveBufferSize(this.receiveBufferSize);
                    }
                    catch (SocketException se) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.log(Level.FINE, "setReceiveBufferSize exception ", se);
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        if (!this.logger.isLoggable(Level.FINE)) break block11;
                        this.logger.log(Level.FINE, "setReceiveBufferSize exception ", iae);
                    }
                }
            }
            if (this.sendBufferSize > 0) {
                try {
                    newSocket.setSendBufferSize(this.sendBufferSize);
                }
                catch (SocketException se) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "setSendBufferSize exception ", se);
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (!this.logger.isLoggable(Level.FINE)) break block12;
                    this.logger.log(Level.FINE, "setSendBufferSize exception ", iae);
                }
            }
        }
        newSocket.setReuseAddress(this.reuseAddress);
        if (localAddress != null) {
            newSocket.bind(localAddress);
        }
        newSocketChannel.configureBlocking(false);
        return newSocketChannel;
    }

    @Override
    public void pause() {
        this.stateHolder.setState(State.PAUSED);
    }

    @Override
    public void resume() {
        if (!State.PAUSED.equals((Object)this.stateHolder.getState(false))) {
            throw new IllegalStateException("SelectorHandler is not in PAUSED state, but: " + (Object)((Object)this.stateHolder.getState(false)));
        }
        this.stateHolder.setState(State.STARTED);
    }

    @Override
    public StateHolder<State> getStateHolder() {
        return this.stateHolder;
    }

    @Override
    public void shutdown() {
        if (this.isShutDown.getAndSet(true)) {
            return;
        }
        this.stateHolder.setState(State.STOPPED);
        if (this.selector != null) {
            try {
                boolean isContinue = true;
                while (isContinue) {
                    try {
                        for (SelectionKey selectionKey : this.selector.keys()) {
                            this.selectionKeyHandler.close(selectionKey);
                        }
                        isContinue = false;
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {}
                }
            }
            catch (ClosedSelectorException e) {
                // empty catch block
            }
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "serverSocket.close", ex);
        }
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
                this.serverSocketChannel = null;
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "serverSocketChannel.close", ex);
        }
        try {
            if (this.selector != null) {
                this.selector.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "selector.close", ex);
        }
        if (this.asyncQueueReader != null) {
            this.asyncQueueReader.close();
            this.asyncQueueReader = null;
        }
        if (this.asyncQueueWriter != null) {
            this.asyncQueueWriter.close();
            this.asyncQueueWriter = null;
        }
        this.readOpToRegister.clear();
        this.writeOpToRegister.clear();
        this.opToRegister.clear();
        this.attributes = null;
    }

    @Override
    public SelectableChannel acceptWithoutRegistration(SelectionKey key) throws IOException {
        int retryNum = 0;
        while (true) {
            boolean isAccepted;
            try {
                isAccepted = true;
                return ((ServerSocketChannel)key.channel()).accept();
            }
            catch (IOException ex) {
                if (!key.isValid()) {
                    throw ex;
                }
                isAccepted = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex1) {
                    throw new IOException(ex1.getMessage());
                }
                this.logger.log(Level.WARNING, "Exception accepting channel", ex);
                if (!isAccepted && retryNum++ < this.maxAcceptRetries) continue;
                throw new IOException("Accept retries exceeded");
            }
            break;
        }
    }

    @Override
    public boolean onAcceptInterest(SelectionKey key, Context ctx) throws IOException {
        SelectableChannel channel = this.acceptWithoutRegistration(key);
        if (channel != null) {
            this.configureChannel(channel);
            SelectionKey readKey = channel.register(this.selector, 1);
            readKey.attach(System.currentTimeMillis());
        }
        return false;
    }

    @Override
    public boolean onReadInterest(SelectionKey key, Context ctx) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
        if (this.asyncQueueReader.isReady(key)) {
            this.invokeAsyncQueueReader(this.pollContext(ctx, key, Context.OpType.OP_READ));
            return false;
        }
        Object attach = SelectionKeyAttachment.getAttachment(key);
        if (attach instanceof CallbackHandler) {
            NIOContext context = this.pollContext(ctx, key, Context.OpType.OP_READ);
            this.invokeCallbackHandler((CallbackHandler)attach, context);
            return false;
        }
        return true;
    }

    @Override
    public boolean onWriteInterest(SelectionKey key, Context ctx) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        if (this.asyncQueueWriter.isReady(key)) {
            this.invokeAsyncQueueWriter(this.pollContext(ctx, key, Context.OpType.OP_WRITE));
            return false;
        }
        Object attach = SelectionKeyAttachment.getAttachment(key);
        if (attach instanceof CallbackHandler) {
            NIOContext context = this.pollContext(ctx, key, Context.OpType.OP_WRITE);
            this.invokeCallbackHandler((CallbackHandler)attach, context);
            return false;
        }
        return true;
    }

    @Override
    public boolean onConnectInterest(SelectionKey key, Context ctx) throws IOException {
        block3: {
            try {
                key.interestOps(key.interestOps() & 0x10);
            }
            catch (CancelledKeyException e) {
                if (!this.logger.isLoggable(Level.FINE)) break block3;
                this.logger.log(Level.FINE, "CancelledKeyException occured when tried to change key interests", e);
            }
        }
        Object attach = SelectionKeyAttachment.getAttachment(key);
        if (attach instanceof CallbackHandler) {
            NIOContext context = this.pollContext(ctx, key, Context.OpType.OP_CONNECT);
            this.invokeCallbackHandler((CallbackHandler)attach, context);
        }
        return false;
    }

    protected void invokeCallbackHandler(CallbackHandler callbackHandler, NIOContext context) throws IOException {
        IOEvent.DefaultIOEvent<Context> ioEvent = new IOEvent.DefaultIOEvent<Context>(context);
        context.setIOEvent(ioEvent);
        context.setSelectorHandler(this);
        CallbackHandlerContextTask task = context.getCallbackHandlerContextTask(callbackHandler);
        boolean isRunInSeparateThread = true;
        if (callbackHandler instanceof CallbackHandlerDescriptor) {
            isRunInSeparateThread = ((CallbackHandlerDescriptor)((Object)callbackHandler)).isRunInSeparateThread(context.getCurrentOpType());
        }
        context.execute(task, isRunInSeparateThread);
    }

    protected void invokeAsyncQueueReader(NIOContext context) throws IOException {
        context.execute(context.getAsyncQueueReaderContextTask(this.asyncQueueReader));
    }

    protected void invokeAsyncQueueWriter(NIOContext context) throws IOException {
        context.execute(context.getAsyncQueueWriterContextTask(this.asyncQueueWriter));
    }

    @Override
    public ConnectorHandler acquireConnectorHandler() {
        if (this.selector == null || !this.selector.isOpen()) {
            throw new IllegalStateException("SelectorHandler not yet started");
        }
        Object connectorHandler = this.connectorInstanceHandler.acquire();
        connectorHandler.setController(Controller.getHandlerController(this));
        return connectorHandler;
    }

    @Override
    public void releaseConnectorHandler(ConnectorHandler connectorHandler) {
        this.connectorInstanceHandler.release(connectorHandler);
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.TCP;
    }

    @Override
    public void configureChannel(SelectableChannel channel) throws IOException {
        block26: {
            Socket socket;
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                socket = ((SocketChannel)channel).socket();
                                channel.configureBlocking(false);
                                if (!channel.isOpen()) {
                                    return;
                                }
                                try {
                                    if (this.socketTimeout >= 0) {
                                        socket.setSoTimeout(this.socketTimeout);
                                    }
                                }
                                catch (SocketException ex) {
                                    if (!this.logger.isLoggable(Level.FINE)) break block21;
                                    this.logger.log(Level.FINE, "setSoTimeout exception ", ex);
                                }
                            }
                            try {
                                if (this.linger >= 0) {
                                    socket.setSoLinger(true, this.linger);
                                }
                            }
                            catch (SocketException ex) {
                                if (!this.logger.isLoggable(Level.FINE)) break block22;
                                this.logger.log(Level.FINE, "setSoLinger exception ", ex);
                            }
                        }
                        try {
                            socket.setTcpNoDelay(this.tcpNoDelay);
                        }
                        catch (SocketException ex) {
                            if (!this.logger.isLoggable(Level.FINE)) break block23;
                            this.logger.log(Level.FINE, "setTcpNoDelay exception ", ex);
                        }
                    }
                    if (this.receiveBufferSize > 0) {
                        try {
                            socket.setReceiveBufferSize(this.receiveBufferSize);
                        }
                        catch (SocketException se) {
                            if (this.logger.isLoggable(Level.FINE)) {
                                this.logger.log(Level.FINE, "setReceiveBufferSize exception ", se);
                            }
                        }
                        catch (IllegalArgumentException iae) {
                            if (!this.logger.isLoggable(Level.FINE)) break block24;
                            this.logger.log(Level.FINE, "setReceiveBufferSize exception ", iae);
                        }
                    }
                }
                if (this.sendBufferSize > 0) {
                    try {
                        socket.setSendBufferSize(this.sendBufferSize);
                    }
                    catch (SocketException se) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.log(Level.FINE, "setSendBufferSize exception ", se);
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        if (!this.logger.isLoggable(Level.FINE)) break block25;
                        this.logger.log(Level.FINE, "setSendBufferSize exception ", iae);
                    }
                }
            }
            try {
                socket.setReuseAddress(this.reuseAddress);
            }
            catch (SocketException ex) {
                if (!this.logger.isLoggable(Level.FINE)) break block26;
                this.logger.log(Level.FINE, "setReuseAddress exception ", ex);
            }
        }
    }

    public int getPendingIOlimitPerThread() {
        return this.pendingIOlimitPerThread;
    }

    public void setPendingIOlimitPerThread(int pendingIOlimitPerThread) {
        this.pendingIOlimitPerThread = pendingIOlimitPerThread;
    }

    @Override
    public final Selector getSelector() {
        return this.selector;
    }

    @Override
    public final void setSelector(Selector selector) {
        this.selector = selector;
    }

    @Override
    public AsyncQueueReader getAsyncQueueReader() {
        return this.asyncQueueReader;
    }

    @Override
    public AsyncQueueWriter getAsyncQueueWriter() {
        return this.asyncQueueWriter;
    }

    public long getSelectTimeout() {
        return this.selectTimeout;
    }

    public void setSelectTimeout(long selectTimeout) {
        this.selectTimeout = selectTimeout;
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    public void setServerTimeout(int serverTimeout) {
        this.serverTimeout = serverTimeout;
    }

    public InetAddress getInet() {
        return this.inet;
    }

    public void setInet(InetAddress inet) {
        this.inet = inet;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public int getPortLowLevel() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return -1;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSsBackLog() {
        return this.ssBackLog;
    }

    public void setSsBackLog(int ssBackLog) {
        this.ssBackLog = ssBackLog;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    @Override
    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public Class<? extends SelectionKeyHandler> getPreferredSelectionKeyHandler() {
        return DefaultSelectionKeyHandler.class;
    }

    @Override
    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    @Override
    public void setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
        this.selectionKeyHandler.setSelectorHandler(this);
    }

    @Override
    public void setProtocolChainInstanceHandler(ProtocolChainInstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    @Override
    public ProtocolChainInstanceHandler getProtocolChainInstanceHandler() {
        return this.instanceHandler;
    }

    @Override
    public void closeChannel(SelectableChannel channel) {
        if (channel instanceof SocketChannel) {
            Socket socket = ((SocketChannel)channel).socket();
            try {
                if (!socket.isInputShutdown()) {
                    socket.shutdownInput();
                }
            }
            catch (IOException e) {
                this.logger.log(Level.FINEST, "Unexpected exception during channel inputShutdown", e);
            }
            try {
                if (!socket.isOutputShutdown()) {
                    socket.shutdownOutput();
                }
            }
            catch (IOException e) {
                this.logger.log(Level.FINEST, "Unexpected exception during channel outputShutdown", e);
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                this.logger.log(Level.FINEST, "Unexpected exception during socket close", e);
            }
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            this.logger.log(Level.FINEST, "Unexpected exception during channel close", e);
        }
        if (this.asyncQueueReader != null) {
            this.asyncQueueReader.onClose(channel);
        }
        if (this.asyncQueueWriter != null) {
            this.asyncQueueWriter.onClose(channel);
        }
    }

    protected NIOContext pollContext(Context serverContext, SelectionKey key, Context.OpType opType) {
        Controller c = serverContext.getController();
        ProtocolChain protocolChain = this.instanceHandler != null ? this.instanceHandler.poll() : c.getProtocolChainInstanceHandler().poll();
        NIOContext context = (NIOContext)c.pollContext();
        c.configureContext(key, opType, context, this);
        context.setProtocolChain(protocolChain);
        return context;
    }

    protected Callable<ConnectorHandler> getConnectorInstanceHandlerDelegate() {
        return new Callable<ConnectorHandler>(){

            @Override
            public ConnectorHandler call() throws Exception {
                return new TCPConnectorHandler();
            }
        };
    }

    @Override
    public Object removeAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    protected static Role boolean2Role(boolean isClient) {
        if (isClient) {
            return Role.CLIENT;
        }
        return Role.CLIENT_SERVER;
    }

    @Override
    public void resetSpinCounter() {
        this.emptySpinCounter = 0;
    }

    @Override
    public int getSpinRate() {
        if (this.emptySpinCounter++ == 0) {
            this.lastSpinTimestamp = System.nanoTime();
        } else if (this.emptySpinCounter == 1000) {
            long deltatime = System.nanoTime() - this.lastSpinTimestamp;
            int contspinspersec = (int)(1000000000000L / deltatime);
            this.emptySpinCounter = 0;
            return contspinspersec;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workaroundSelectorSpin() throws IOException {
        Object object = this.spinSync;
        synchronized (object) {
            this.spinnedSelectorsHistory.put(this.selector, System.currentTimeMillis());
            SelectorHandlerRunner.switchToNewSelector(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectionKey keyFor(SelectableChannel channel) {
        if (Controller.isLinux) {
            Object object = this.spinSync;
            synchronized (object) {
                return channel.keyFor(this.selector);
            }
        }
        return channel.keyFor(this.selector);
    }

    public void setSendBufferSize(int size) {
        this.sendBufferSize = size;
    }

    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    public boolean isFinishIOUsingCurrentThread() {
        return this.finishIOUsingCurrentThread;
    }

    public void setFinishIOUsingCurrentThread(boolean finishIOUsingCurrentThread) {
        this.finishIOUsingCurrentThread = finishIOUsingCurrentThread;
    }

    public void setMaxAcceptRetries(int maxAcceptRetries) {
        this.maxAcceptRetries = maxAcceptRetries;
    }
}

