/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.uri.rules;

import com.sun.jersey.api.Responses;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.core.header.QualitySourceMediaType;
import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.server.impl.model.method.ResourceMethod;
import com.sun.jersey.server.impl.template.ViewResourceMethod;
import com.sun.jersey.server.probes.UriRuleProbeProvider;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRuleContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpMethodRule
implements UriRule {
    private final Map<String, ResourceMethodListPair> map = new HashMap<String, ResourceMethodListPair>();
    private final String allow;
    private final boolean isSubResource;

    public HttpMethodRule(Map<String, List<ResourceMethod>> methods) {
        this(methods, false);
    }

    public HttpMethodRule(Map<String, List<ResourceMethod>> methods, boolean isSubResource) {
        for (Map.Entry<String, List<ResourceMethod>> e : methods.entrySet()) {
            this.map.put(e.getKey(), new ResourceMethodListPair(e.getValue()));
        }
        this.isSubResource = isSubResource;
        this.allow = this.getAllow(methods);
    }

    private String getAllow(Map<String, List<ResourceMethod>> methods) {
        StringBuilder s = new StringBuilder();
        for (String method : methods.keySet()) {
            if (s.length() > 0) {
                s.append(",");
            }
            s.append(method);
        }
        return s.toString();
    }

    @Override
    public boolean accept(CharSequence path, Object resource, UriRuleContext context) {
        ResourceMethodListPair methods;
        UriRuleProbeProvider.ruleAccept(HttpMethodRule.class.getSimpleName(), path, resource);
        if (path.length() > 0) {
            return false;
        }
        HttpRequestContext request = context.getRequest();
        HttpResponseContext response = context.getResponse();
        if (context.isTracingEnabled()) {
            String currentPath = context.getUriInfo().getMatchedURIs().get(0);
            if (this.isSubResource) {
                String prevPath = context.getUriInfo().getMatchedURIs().get(1);
                context.trace(String.format("accept sub-resource methods: \"%s\" : \"%s\", %s -> %s", prevPath, currentPath.substring(prevPath.length()), context.getRequest().getMethod(), ReflectionHelper.objectToString(resource)));
            } else {
                context.trace(String.format("accept resource methods: \"%s\", %s -> %s", currentPath, context.getRequest().getMethod(), ReflectionHelper.objectToString(resource)));
            }
        }
        if ((methods = this.map.get(request.getMethod())) == null) {
            response.setResponse(Responses.methodNotAllowed().header("Allow", this.allow).build());
            return false;
        }
        List<MediaType> accept = HttpMethodRule.getSpecificAcceptableMediaTypes(request.getAcceptableMediaTypes(), methods.priorityMediaTypes);
        Matcher m = new Matcher();
        MatchStatus s = m.match(methods, request.getMediaType(), accept);
        if (s == MatchStatus.MATCH) {
            ResourceMethod method = m.rmSelected;
            if (method instanceof ViewResourceMethod) {
                if (!m.mSelected.isWildcardType() && !m.mSelected.isWildcardSubtype()) {
                    response.getHttpHeaders().putSingle("Content-Type", m.mSelected);
                }
                return false;
            }
            if (this.isSubResource) {
                context.pushResource(resource);
                context.pushMatch(method.getTemplate(), method.getTemplate().getTemplateVariables());
            }
            if (context.isTracingEnabled()) {
                if (this.isSubResource) {
                    context.trace(String.format("matched sub-resource method: @Path(\"%s\") %s", method.getTemplate(), method.getDispatcher()));
                } else {
                    context.trace(String.format("matched resource method: %s", method.getDispatcher()));
                }
            }
            context.pushContainerResponseFilters(method.getResponseFilters());
            if (!method.getRequestFilters().isEmpty()) {
                ContainerRequest containerRequest = context.getContainerRequest();
                for (ContainerRequestFilter f : method.getRequestFilters()) {
                    containerRequest = f.filter(containerRequest);
                    context.setContainerRequest(containerRequest);
                }
            }
            method.getDispatcher().dispatch(resource, context);
            Object contentType = response.getHttpHeaders().getFirst("Content-Type");
            if (contentType == null && method.isProducesDeclared() && !m.mSelected.isWildcardType() && !m.mSelected.isWildcardSubtype()) {
                response.getHttpHeaders().putSingle("Content-Type", m.mSelected);
            }
            return true;
        }
        if (s == MatchStatus.NO_MATCH_FOR_CONSUME) {
            response.setResponse(Responses.unsupportedMediaType().build());
            return false;
        }
        if (s == MatchStatus.NO_MATCH_FOR_PRODUCE) {
            response.setResponse(Responses.notAcceptable().build());
            return false;
        }
        return true;
    }

    public static List<MediaType> getSpecificAcceptableMediaTypes(List<MediaType> acceptableMediaType, List<? extends MediaType> priorityMediaTypes) {
        if (priorityMediaTypes != null) {
            for (MediaType mediaType : priorityMediaTypes) {
                for (MediaType amt : acceptableMediaType) {
                    if (!amt.isCompatible(mediaType)) continue;
                    return Collections.singletonList(MediaTypes.mostSpecific(amt, mediaType));
                }
            }
        }
        return acceptableMediaType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Matcher
    extends LinkedList<ResourceMethod> {
        private MediaType mSelected = null;
        private ResourceMethod rmSelected = null;

        private Matcher() {
        }

        private MatchStatus match(ResourceMethodListPair methods, MediaType contentType, List<MediaType> acceptableMediaTypes) {
            Matcher selected = null;
            if (contentType != null) {
                for (ResourceMethod method : methods.normal) {
                    if (!method.consumes(contentType)) continue;
                    this.add(method);
                }
                if (this.isEmpty()) {
                    return MatchStatus.NO_MATCH_FOR_CONSUME;
                }
                selected = this;
            } else {
                selected = methods.wildPriority;
            }
            for (MediaType amt : acceptableMediaTypes) {
                for (ResourceMethod rm : selected) {
                    for (MediaType mediaType : rm.getProduces()) {
                        if (!mediaType.isCompatible(amt)) continue;
                        this.mSelected = MediaTypes.mostSpecific(mediaType, amt);
                        this.rmSelected = rm;
                        return MatchStatus.MATCH;
                    }
                }
            }
            return MatchStatus.NO_MATCH_FOR_PRODUCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MatchStatus {
        MATCH,
        NO_MATCH_FOR_CONSUME,
        NO_MATCH_FOR_PRODUCE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceMethodListPair {
        final List<ResourceMethod> normal;
        final List<ResourceMethod> wildPriority;
        final List<QualitySourceMediaType> priorityMediaTypes;

        ResourceMethodListPair(List<ResourceMethod> normal) {
            this.normal = normal;
            if (this.correctOrder(normal)) {
                this.wildPriority = normal;
            } else {
                this.wildPriority = new ArrayList<ResourceMethod>(normal.size());
                int i = 0;
                for (ResourceMethod method : normal) {
                    if (method.consumesWild()) {
                        this.wildPriority.add(i++, method);
                        continue;
                    }
                    this.wildPriority.add(method);
                }
            }
            LinkedList<QualitySourceMediaType> pmts = new LinkedList<QualitySourceMediaType>();
            for (ResourceMethod m : normal) {
                for (MediaType mediaType : m.getProduces()) {
                    QualitySourceMediaType qsmt = this.get(mediaType);
                    if (qsmt == null || qsmt.getQualitySource() <= 1000) continue;
                    pmts.add(qsmt);
                }
            }
            Collections.sort(pmts, MediaTypes.QUALITY_SOURCE_MEDIA_TYPE_COMPARATOR);
            this.priorityMediaTypes = pmts.isEmpty() ? null : pmts;
        }

        QualitySourceMediaType get(MediaType mt) {
            if (mt instanceof QualitySourceMediaType) {
                return (QualitySourceMediaType)mt;
            }
            if (mt.getParameters().containsKey("qs")) {
                return new QualitySourceMediaType(mt);
            }
            return null;
        }

        boolean correctOrder(List<ResourceMethod> normal) {
            boolean comsumesNonWild = false;
            for (ResourceMethod method : normal) {
                if (method.consumesWild()) {
                    if (!comsumesNonWild) continue;
                    return false;
                }
                comsumesNonWild = true;
            }
            return true;
        }
    }
}

