/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.atmosphere.annotation.Broadcast;
import org.atmosphere.annotation.Cluster;
import org.atmosphere.annotation.Resume;
import org.atmosphere.annotation.Schedule;
import org.atmosphere.annotation.Suspend;
import org.atmosphere.cpr.AtmosphereEventLifecycle;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.jersey.Broadcastable;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtmosphereFilter
implements ResourceFilterFactory {
    private Logger logger = LoggerUtils.getLogger();
    public static final String CONTAINER_RESPONSE = "cr";
    public static final String SUSPENDED_RESOURCE = "org.atmosphere.suspendedResource";
    public static final String RESUME_ON_BROADCAST = "org.atmosphere.resumeOnBroadcast";
    public static final String RESUME_UUID = "org.atmosphere.jersey.uuid";
    public static final String RESUME_CANDIDATES = "org.atmosphere.jersey.resumeCandidates";
    @Context
    private HttpServletRequest servletReq;
    @Context
    private UriInfo uriInfo;
    private final ConcurrentHashMap<String, AtmosphereResource> resumeCandidates = new ConcurrentHashMap();

    @Override
    public List<ResourceFilter> create(AbstractMethod am) {
        LinkedList<ResourceFilter> list = new LinkedList<ResourceFilter>();
        if (this.logger.isLoggable(Level.FINE)) {
            for (Annotation a : am.getAnnotations()) {
                this.logger.log(Level.FINE, "AtmosphereFilter processing annotation: " + a);
            }
        }
        if (am.isAnnotationPresent(Broadcast.class)) {
            int delay = am.getAnnotation(Broadcast.class).delay();
            Filter f = am.getAnnotation(Broadcast.class).resumeOnBroadcast() ? new Filter(Action.RESUME_ON_BROADCAST, delay) : new Filter(Action.BROADCAST, delay);
            list.addLast(f);
            Class[] value = am.getAnnotation(Broadcast.class).value();
            if (value != null) {
                f.setFilter(value);
            }
            if (am.isAnnotationPresent(Cluster.class)) {
                for (Class c : value = am.getAnnotation(Cluster.class).value()) {
                    try {
                        ClusterBroadcastFilter cbf = (ClusterBroadcastFilter)c.newInstance();
                        cbf.setClusterName(am.getAnnotation(Cluster.class).name());
                        f.addCluster(cbf);
                    }
                    catch (Throwable t) {
                        this.logger.log(Level.WARNING, "Invalid ClusterBroadcastFilter", t);
                    }
                }
            }
        }
        if (am.isAnnotationPresent(Suspend.class)) {
            int value = am.getAnnotation(Suspend.class).period();
            Suspend.SCOPE scope = am.getAnnotation(Suspend.class).scope();
            boolean outputComments = am.getAnnotation(Suspend.class).outputComments();
            Filter f = am.getAnnotation(Suspend.class).resumeOnBroadcast() ? new Filter(Action.SUSPEND_RESUME, value, scope, outputComments) : new Filter(Action.SUSPEND, value, scope, outputComments);
            if (am.isAnnotationPresent(Produces.class)) {
                Filter.access$502(f, am.getAnnotation(Produces.class).value());
            }
            f.setListeners(am.getAnnotation(Suspend.class).listeners());
            list.addFirst(f);
        }
        if (am.isAnnotationPresent(Resume.class)) {
            int value = am.getAnnotation(Resume.class).value();
            list.addFirst(new Filter(Action.RESUME, value));
        }
        if (am.isAnnotationPresent(Schedule.class)) {
            int period = am.getAnnotation(Schedule.class).period();
            int waitFor = am.getAnnotation(Schedule.class).waitFor();
            if (am.getAnnotation(Schedule.class).resumeOnBroadcast()) {
                list.addFirst(new Filter(Action.SCHEDULE_RESUME, period, waitFor));
            } else {
                list.addFirst(new Filter(Action.SCHEDULE, period, waitFor));
            }
        }
        return list.size() > 0 ? list : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Filter
    implements ResourceFilter,
    ContainerResponseFilter {
        private ConcurrentLinkedQueue<Broadcaster> configuredBroadcaster = new ConcurrentLinkedQueue();
        private final Action action;
        private int value;
        private int waitFor = 0;
        private Suspend.SCOPE scope;
        private Class<BroadcastFilter>[] filters = null;
        private Class<? extends AtmosphereResourceEventListener>[] listeners = null;
        private boolean outputComments = true;
        private String[] contentType = new String[]{"text/plain"};
        private final ArrayList<ClusterBroadcastFilter> clusters = new ArrayList();

        protected Filter(Action action) {
            this.action = action;
        }

        protected Filter(Action action, int value) {
            this.action = action;
            this.value = value;
        }

        protected Filter(Action action, int value, int waitFor) {
            this.action = action;
            this.value = value;
            this.waitFor = waitFor;
        }

        protected Filter(Action action, int value, Suspend.SCOPE scope) {
            this.action = action;
            this.value = value;
            this.scope = scope;
        }

        protected Filter(Action action, int value, Suspend.SCOPE scope, boolean outputComments) {
            this.action = action;
            this.value = value;
            this.scope = scope;
            this.outputComments = outputComments;
        }

        @Override
        public ContainerRequestFilter getRequestFilter() {
            return null;
        }

        @Override
        public ContainerResponseFilter getResponseFilter() {
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
            if (response.getMappedThrowable() != null) {
                if (response.getStatus() < 200 || response.getStatus() >= 400) return response;
                Response res = null;
                for (String s : this.contentType) {
                    res = Response.fromResponse(response.getResponse()).header("Content-Type", s).build();
                }
                if (res == null) return response;
                response.setResponse(res);
                return response;
            }
            AtmosphereResource r = (AtmosphereResource)AtmosphereFilter.this.servletReq.getAttribute(ReflectorServletProcessor.ATMOSPHERE_RESOURCE);
            boolean sessionSupported = (Boolean)AtmosphereFilter.this.servletReq.getAttribute("org.atmosphere.cpr.AsynchronousProcessor.supportSession");
            if (this.action == Action.SUSPEND || this.action == Action.SUSPEND_RESUME) {
                Object o = response.getEntity();
                if (!sessionSupported) {
                    String uuid = String.valueOf(UUID.randomUUID());
                    Response res = Response.fromResponse(response.getResponse()).location(AtmosphereFilter.this.uriInfo.getAbsolutePathBuilder().path(uuid).build("")).build();
                    response.setResponse(res);
                    AtmosphereFilter.this.resumeCandidates.put(uuid, r);
                    AtmosphereFilter.this.servletReq.setAttribute(AtmosphereFilter.RESUME_UUID, uuid);
                    AtmosphereFilter.this.servletReq.setAttribute(AtmosphereFilter.RESUME_CANDIDATES, AtmosphereFilter.this.resumeCandidates);
                }
                Broadcaster bc = r.getBroadcaster();
                if (this.scope == Suspend.SCOPE.REQUEST) {
                    try {
                        bc = (Broadcaster)bc.getClass().newInstance();
                        r.setBroadcaster(bc);
                    }
                    catch (InstantiationException ex) {
                        AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalAccessException ex) {
                        AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                    }
                } else if (response.getEntity() instanceof Broadcastable) {
                    Broadcastable b = (Broadcastable)response.getEntity();
                    bc = b.b;
                    this.configureFilter(bc);
                    r.setBroadcaster(bc);
                    response.setEntity(b.message);
                }
                if (response.getEntity() != null) {
                    try {
                        response.write();
                    }
                    catch (IOException ex) {
                        throw new WebApplicationException(ex);
                    }
                }
                if (sessionSupported) {
                    AtmosphereFilter.this.servletReq.getSession().setAttribute(AtmosphereFilter.SUSPENDED_RESOURCE, r);
                    AtmosphereFilter.this.servletReq.getSession().setAttribute(AtmosphereFilter.CONTAINER_RESPONSE, response);
                }
                AtmosphereFilter.this.servletReq.setAttribute(AtmosphereFilter.SUSPENDED_RESOURCE, r);
                AtmosphereFilter.this.servletReq.setAttribute(AtmosphereFilter.CONTAINER_RESPONSE, response);
                boolean resumeOnBroadcast = this.action == Action.SUSPEND_RESUME;
                r.suspend(this.value, this.outputComments && !resumeOnBroadcast);
                AtmosphereHandler a = (AtmosphereHandler)AtmosphereFilter.this.servletReq.getAttribute(ReflectorServletProcessor.ATMOSPHERE_HANDLER);
                for (Class<? extends AtmosphereResourceEventListener> e : this.listeners) {
                    try {
                        AtmosphereResourceEventListener el = e.newInstance();
                        if (!(r instanceof AtmosphereEventLifecycle)) continue;
                        ((AtmosphereEventLifecycle)((Object)r)).addEventListener(el);
                    }
                    catch (Throwable t) {
                        throw new WebApplicationException(new IllegalStateException("Invalid AtmosphereResourceEventListener"));
                    }
                }
                if (!resumeOnBroadcast) return response;
                this.configureResumeOnBroadcast(r.getBroadcaster());
                return response;
            }
            if (this.action == Action.RESUME) {
                if (r == null && sessionSupported) {
                    r = (AtmosphereResource)AtmosphereFilter.this.servletReq.getSession().getAttribute(AtmosphereFilter.SUSPENDED_RESOURCE);
                } else {
                    String path = response.getContainerRequest().getPath();
                    r = (AtmosphereResource)AtmosphereFilter.this.resumeCandidates.remove(path.substring(path.lastIndexOf("/") + 1));
                }
                if (r == null) throw new WebApplicationException(new IllegalStateException("Unable to retrieve suspended Response. Either session-support is not enabled in atmosphere.xml or thepath used to resume is invalid."));
                this.resume(r);
                return response;
            } else if (this.action == Action.BROADCAST || this.action == Action.RESUME_ON_BROADCAST) {
                AtmosphereResource ar = (AtmosphereResource)AtmosphereFilter.this.servletReq.getAttribute(AtmosphereFilter.SUSPENDED_RESOURCE);
                if (ar != null) {
                    r = ar;
                }
                this.broadcast(response, r, this.value);
                return response;
            } else {
                if (this.action != Action.SCHEDULE && this.action != Action.SCHEDULE_RESUME) return response;
                Object o = response.getEntity();
                Broadcaster b = r.getBroadcaster();
                if (response.getEntity() instanceof Broadcastable) {
                    b = ((Broadcastable)response.getEntity()).b;
                    o = ((Broadcastable)response.getEntity()).message;
                    response.setEntity(o);
                }
                if (this.action == Action.SCHEDULE_RESUME) {
                    this.configureResumeOnBroadcast(b);
                }
                b.scheduleFixedBroadcast(o, this.waitFor, this.value, TimeUnit.SECONDS);
            }
            return response;
        }

        void configureResumeOnBroadcast(Broadcaster b) {
            Iterator<AtmosphereResource> i = b.getAtmosphereResources();
            while (i.hasNext()) {
                HttpServletRequest r = (HttpServletRequest)i.next().getRequest();
                r.setAttribute(AtmosphereFilter.RESUME_ON_BROADCAST, new Boolean(true));
            }
        }

        void configureFilter(Broadcaster bc) {
            if (bc == null) {
                throw new WebApplicationException(new IllegalStateException("Broadcaster cannot be null"));
            }
            BroadcasterConfig c = bc.getBroadcasterConfig();
            for (ClusterBroadcastFilter cbf : this.clusters) {
                cbf.setBroadcaster(bc);
                c.addFilter(cbf);
            }
            BroadcastFilter f = null;
            if (this.filters != null) {
                for (Class<BroadcastFilter> filter : this.filters) {
                    try {
                        f = filter.newInstance();
                    }
                    catch (Throwable t) {
                        AtmosphereFilter.this.logger.warning("Invalid @BroadcastFilter: " + filter);
                    }
                    c.addFilter(f);
                }
            }
        }

        private void setFilter(Class<BroadcastFilter>[] filters) {
            this.filters = filters;
        }

        private void setListeners(Class<? extends AtmosphereResourceEventListener>[] listeners) {
            this.listeners = listeners;
        }

        void broadcast(ContainerResponse r, AtmosphereResource ar, int delay) {
            Object o = r.getEntity();
            Broadcaster b = ar.getBroadcaster();
            Object msg = o;
            if (o instanceof Broadcastable) {
                b = ((Broadcastable)o).b;
                msg = ((Broadcastable)o).message;
            }
            if (this.action == Action.RESUME_ON_BROADCAST) {
                this.configureResumeOnBroadcast(b);
            }
            if (o != null) {
                this.addFilter(b);
                try {
                    r.setEntity(msg);
                    if (msg == null) {
                        return;
                    }
                    if (delay == -1) {
                        Future<Object> f = b.broadcast(msg);
                        if (f == null) {
                            return;
                        }
                        Object t = f.get();
                        if (o instanceof Broadcastable) {
                            r.setEntity(t);
                        }
                    } else if (delay == 0) {
                        b.delayBroadcast(msg);
                    } else {
                        b.delayBroadcast(msg, delay, TimeUnit.SECONDS);
                    }
                }
                catch (InterruptedException ex) {
                    AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                }
            }
        }

        void addFilter(Broadcaster bc) {
            if (!this.configuredBroadcaster.contains(bc)) {
                this.configureFilter(bc);
                this.configuredBroadcaster.offer(bc);
            }
        }

        void resume(AtmosphereResource r) {
            AtmosphereHandler a = r.getAtmosphereConfig().getAtmosphereHandler();
            r.resume();
        }

        void addCluster(ClusterBroadcastFilter f) {
            this.clusters.add(f);
        }

        static /* synthetic */ String[] access$502(Filter x0, String[] x1) {
            x0.contentType = x1;
            return x1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        SUSPEND,
        RESUME,
        BROADCAST,
        SUSPEND_RESUME,
        SCHEDULE_RESUME,
        RESUME_ON_BROADCAST,
        NONE,
        SCHEDULE;

    }
}

