/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.util.BroadcasterLookup;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsynchronousProcessor
implements CometSupport<AtmosphereResourceImpl> {
    private static final AtmosphereServlet.Action timedoutAction = new AtmosphereServlet.Action();
    private static final AtmosphereServlet.Action cancelledAction = new AtmosphereServlet.Action();
    protected final Logger logger = LoggerUtils.getLogger();
    protected static final String RESOURCE_EVENT = "org.atmosphere.cpr.AtmosphereResourceImpl";
    public static final String SUPPORT_SESSION = "org.atmosphere.cpr.AsynchronousProcessor.supportSession";
    private final AtmosphereServlet.AtmosphereConfig config;
    protected final ConcurrentHashMap<HttpServletRequest, AtmosphereResource> aliveRequests = new ConcurrentHashMap();

    public AsynchronousProcessor(AtmosphereServlet.AtmosphereConfig config) {
        this.config = config;
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
    }

    protected boolean supportSession() {
        return this.config.supportSession;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo();
    }

    public AtmosphereServlet.Action suspended(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("(suspend) invoked:\n HttpServletRequest: " + req + "\n HttpServletResponse: " + res);
        }
        return this.action(req, res);
    }

    AtmosphereServlet.Action action(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.supportSession()) {
            HttpSession session = req.getSession(true);
            session.setMaxInactiveInterval(-1);
        }
        req.setAttribute(SUPPORT_SESSION, this.supportSession());
        AtmosphereServlet.AtmosphereHandlerWrapper g = this.map(req);
        AtmosphereResourceImpl re = new AtmosphereResourceImpl(this.config, g.broadcaster, req, res, this);
        g.atmosphereHandler.onRequest(re);
        if (re.event().isSuspended()) {
            this.aliveRequests.put(req, re);
        }
        return re.action();
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        this.aliveRequests.remove(actionEvent.getRequest());
    }

    AtmosphereServlet.AtmosphereHandlerWrapper map(HttpServletRequest req) throws ServletException {
        AtmosphereServlet.AtmosphereHandlerWrapper g;
        String path = req.getServletPath();
        if (path == null || path.equals("")) {
            path = "/";
        }
        if ((g = this.config.handlers().get(path)) == null) {
            path = !path.endsWith("/") ? path + "/*" : path + "*";
            g = this.config.handlers().get(path);
            if (g == null && (g = this.config.handlers().get("/*")) == null) {
                path = req.getServletPath() + req.getPathInfo();
                g = this.config.handlers().get(path);
                if (g == null) {
                    path = !path.endsWith("/") ? path + "/*" : path + "*";
                    g = this.config.handlers().get(path);
                    if (g == null) {
                        this.logger.warning("No AtmosphereHandler maps request for " + path);
                        for (String m : this.config.handlers().keySet()) {
                            this.logger.warning("\tAtmosphereHandler registered: " + m);
                        }
                        throw new ServletException("No AtmosphereHandler maps request for " + path);
                    }
                }
            }
        }
        this.config.ah = g.atmosphereHandler;
        BroadcasterLookup.add(g.broadcaster, g.broadcaster.getID());
        return g;
    }

    public AtmosphereServlet.Action resumed(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("(resumed) invoked:\n HttpServletRequest: " + req + "\n HttpServletResponse: " + res);
        }
        return this.action(req, res);
    }

    public AtmosphereServlet.Action timedout(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereResourceImpl re = null;
        if (req == null || res == null) {
            this.logger.warning("Invalid Request/Response: " + req + "/" + res);
            return timedoutAction;
        }
        AtmosphereServlet.AtmosphereHandlerWrapper aw = this.map(req);
        re = (AtmosphereResourceImpl)this.aliveRequests.remove(req);
        if (re != null) {
            re.event().isResumedOnTimeout = true;
            if (re.getRequest().getAttribute(AtmosphereResourceImpl.RESUMED_ON_TIMEOUT) != null) {
                re.event().isResumedOnTimeout = (Boolean)re.getRequest().getAttribute(AtmosphereResourceImpl.RESUMED_ON_TIMEOUT);
            }
            re.notifyListeners();
            re.getBroadcaster().removeAtmosphereResource(re);
            if (!re.getResponse().equals(res)) {
                this.logger.warning("Invalid response: " + res);
            } else if (!re.getAtmosphereConfig().getInitParameter("org.atmosphere.disableOnStateEvent").equals(String.valueOf(true))) {
                aw.atmosphereHandler.onStateChange(re.event());
            }
        }
        return timedoutAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtmosphereServlet.Action cancelled(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereResourceImpl re = null;
        try {
            AtmosphereServlet.AtmosphereHandlerWrapper aw = this.map(req);
            re = (AtmosphereResourceImpl)this.aliveRequests.remove(req);
            if (re != null) {
                re.event().setCancelled(true);
                re.getBroadcaster().removeAtmosphereResource(re);
                if (!re.getResponse().equals(res)) {
                    this.logger.warning("Invalid response: " + res);
                } else if (!re.getAtmosphereConfig().getInitParameter("org.atmosphere.disableOnStateEvent").equals(String.valueOf(true))) {
                    aw.atmosphereHandler.onStateChange(re.event());
                }
                re.notifyListeners();
            }
        }
        catch (Throwable ex) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "", ex);
            }
        }
        finally {
            if (re != null) {
                re.isInScope(false);
            }
        }
        return cancelledAction;
    }

    void shutdown() {
        for (AtmosphereResource r : this.aliveRequests.values()) {
            try {
                r.resume();
            }
            catch (Throwable throwable) {}
        }
    }
}

