/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet.deployer.watchdog;

import com.sun.grizzly.http.servlet.deployer.GrizzlyWebServerDeployer;
import com.sun.grizzly.http.servlet.deployer.conf.DeployableConfiguration;
import com.sun.grizzly.http.servlet.deployer.filter.ExtensionFileNameFilter;
import com.sun.grizzly.http.servlet.deployer.watchdog.WatchedFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Watchdog
implements Runnable {
    private static Logger logger = Logger.getLogger(Watchdog.class.getName());
    protected GrizzlyWebServerDeployer deployer;

    public Watchdog(GrizzlyWebServerDeployer deployer) {
        this.deployer = deployer;
    }

    private void lookForNewFiles(String folder) throws Exception {
        File[] files;
        Map<String, WatchedFile> contextMap = this.deployer.getWatchedFileMap();
        for (WatchedFile watchedFile : contextMap.values()) {
            if (watchedFile == null) continue;
            watchedFile.resetFlag();
        }
        File file = new File(folder);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        for (File f : files = file.listFiles(new ExtensionFileNameFilter(Arrays.asList(".war")))) {
            String context = GrizzlyWebServerDeployer.getContext(f.getPath());
            if (contextMap.containsKey(context)) {
                contextMap.get(context).setFound(true);
                continue;
            }
            logger.info("Found a new file to deploy : " + f.getPath());
            this.deployer.deployApplication(new DeployableConfiguration(f.getPath()));
            contextMap.put(context, new WatchedFile(f.getPath()));
        }
        ArrayList<String> contextToRemoveList = new ArrayList<String>();
        for (String context : contextMap.keySet()) {
            WatchedFile watchedFile = contextMap.get(context);
            if (watchedFile == null || watchedFile.isFound()) continue;
            contextToRemoveList.add(context);
        }
        if (!contextToRemoveList.isEmpty()) {
            for (String context : contextToRemoveList) {
                logger.info("Application to undeploy : context= " + context);
                this.deployer.undeployApplication(context);
                contextMap.remove(context);
            }
        }
    }

    public void run() {
        if (this.deployer == null || this.deployer.getWatchDogFolder() == null) {
            return;
        }
        try {
            this.lookForNewFiles(this.deployer.getWatchDogFolder());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Watchdog problem", e);
        }
    }
}

