/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.BaseWebSocket;
import com.sun.grizzly.websockets.ClientHandShake;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketClientApplication;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class ClientNetworkHandler
implements NetworkHandler {
    private final SocketChannel channel;
    private final URL url;
    private final WebSocketClientApplication app;
    private WebSocket webSocket;
    private ClientHandShake clientHS;

    public ClientNetworkHandler(URL url, WebSocketClientApplication application) throws IOException {
        this.url = url;
        this.app = application;
        this.channel = SocketChannel.open();
        this.channel.configureBlocking(false);
        this.channel.connect(new InetSocketAddress(url.getHost(), url.getPort()));
        this.channel.socket().setSoTimeout(30000);
        this.app.register(this);
        this.app.getSelector().wakeup();
    }

    SocketChannel getChannel() {
        return this.channel;
    }

    public void send(DataFrame frame) throws IOException {
        this.write(frame.frame());
    }

    public SelectionKey getKey() {
        return this.channel.keyFor(this.app.getSelector());
    }

    public void process(SelectionKey key) throws IOException {
        if (key.isValid()) {
            if (key.isConnectable()) {
                this.disableOp(8);
                this.doConnect();
                this.enableOp(1);
            } else if (key.isReadable()) {
                this.unframe();
                if (this.webSocket.isConnected()) {
                    this.enableOp(1);
                }
            }
            key.selector().wakeup();
        }
    }

    protected void doConnect() throws IOException {
        this.channel.finishConnect();
        boolean isSecure = "wss".equals(this.url.getProtocol());
        StringBuilder origin = new StringBuilder();
        origin.append(isSecure ? "https://" : "http://");
        origin.append(this.url.getHost());
        if (!isSecure && this.url.getPort() != 80 || isSecure && this.url.getPort() != 443) {
            origin.append(":").append(this.url.getPort());
        }
        this.clientHS = new ClientHandShake(isSecure, origin.toString(), this.url.getHost(), String.valueOf(this.url.getPort()), this.url.getPath());
        this.write(this.clientHS.getBytes());
    }

    protected void write(byte[] bytes) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        buffer.flip();
        this.channel.write(buffer);
    }

    private void unframe() throws IOException {
        int count;
        do {
            ByteBuffer bytes = ByteBuffer.allocate(8192);
            count = this.channel.read(bytes);
            bytes.flip();
            if (count <= 0) continue;
            if (this.webSocket.isConnected()) {
                this.unframe(bytes);
                continue;
            }
            byte[] serverKey = this.findServerKey(bytes);
            try {
                this.clientHS.validateServerResponse(serverKey);
            }
            catch (HandshakeException e) {
                throw new IOException(e.getMessage());
            }
            this.webSocket.onConnect();
        } while (count > 0);
    }

    private byte[] findServerKey(ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining() && this.readLine(buffer).length > 0) {
        }
        return buffer.hasRemaining() ? this.readLine(buffer) : new byte[]{};
    }

    private byte[] readLine(ByteBuffer buffer) throws IOException {
        ByteChunk line = new ByteChunk(0);
        int last = 0;
        boolean done = false;
        while (!done && buffer.hasRemaining()) {
            byte next = buffer.get();
            if (next != 13 && next != 10) {
                line.append(next);
            } else {
                done = last == 13 || last == 10;
            }
            last = next;
        }
        byte[] result = new byte[line.getEnd()];
        System.arraycopy(line.getBuffer(), 0, result, 0, result.length);
        return result;
    }

    protected void unframe(ByteBuffer bytes) throws IOException {
        while (bytes.hasRemaining()) {
            DataFrame dataFrame = new DataFrame(bytes);
            if (dataFrame.getType() == null) continue;
            if (dataFrame.getType() == FrameType.CLOSING) {
                this.webSocket.close();
                continue;
            }
            this.webSocket.onMessage(dataFrame);
        }
    }

    private void enableOp(int op) {
        SelectionKey key = this.getKey();
        int ops = key.interestOps();
        int newOp = ops | op;
        if (newOp != ops) {
            key.interestOps(newOp);
        }
        key.selector().wakeup();
    }

    private void disableOp(int op) {
        SelectionKey key = this.getKey();
        int ops = key.interestOps();
        int newOp = ops & ~op;
        if (newOp != ops) {
            key.interestOps(newOp);
        }
    }

    public void shutdown() throws IOException {
        this.getKey().cancel();
        this.channel.close();
        this.app.remove(this.webSocket);
    }

    public void setWebSocket(BaseWebSocket webSocket) {
        this.webSocket = webSocket;
    }
}

