/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.Utils;
import com.sun.grizzly.websockets.FrameType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class DataFrame {
    private static final Logger logger = Logger.getLogger("websocket");
    private String payload;
    private byte[] bytes;
    private FrameType type = FrameType.values()[0];

    public DataFrame(ByteBuffer buffer) throws IOException {
        while (this.bytes == null && this.type != null) {
            if (this.type.accept(buffer)) {
                this.bytes = this.type.unframe(buffer);
                continue;
            }
            this.type = this.type.next();
        }
    }

    public DataFrame(FrameType frameType) {
        this.type = frameType;
    }

    public DataFrame(String data) {
        this.type = FrameType.TEXT;
        this.payload = data;
        try {
            this.bytes = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public FrameType getType() {
        return this.type;
    }

    public void setType(FrameType type) {
        this.type = type;
    }

    public String getTextPayload() {
        if (this.payload == null && this.bytes != null) {
            try {
                this.payload = new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.payload;
    }

    public void setTextPayload(String payload) {
        this.type = FrameType.TEXT;
        this.payload = payload;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = Utils.copy(bytes);
    }

    public byte[] getBinaryPayload() {
        return Utils.copy(this.bytes);
    }

    public byte[] frame() {
        return this.frame(this.type);
    }

    public byte[] frame(FrameType type) {
        return type.frame(this.bytes);
    }

    public String toString() {
        return this.payload;
    }
}

