/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.arp.AsyncExecutor;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.InputBuffer;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.util.ConnectionCloseHandler;
import com.sun.grizzly.util.SelectionKeyActionAttachment;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.websockets.BaseWebSocket;
import com.sun.grizzly.websockets.ClientHandShake;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.ServerHandShake;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketEngine;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerNetworkHandler
extends SelectionKeyActionAttachment
implements ConnectionCloseHandler,
NetworkHandler {
    private final AsyncExecutor asyncExecutor;
    private final Request request;
    private final Response response;
    private final InputBuffer inputBuffer;
    private final InternalOutputBuffer outputBuffer;
    private WebSocket socket;

    public ServerNetworkHandler(AsyncExecutor executor, Request req, Response resp) {
        this.asyncExecutor = executor;
        this.request = req;
        this.response = resp;
        this.inputBuffer = req.getInputBuffer();
        this.outputBuffer = (InternalOutputBuffer)resp.getOutputBuffer();
        ((BaseSelectionKeyHandler)this.asyncExecutor.getProcessorTask().getSelectorHandler().getSelectionKeyHandler()).setConnectionCloseHandler(this);
    }

    public void setWebSocket(BaseWebSocket webSocket) {
        this.socket = webSocket;
    }

    protected void handshake(ProcessorTask task) throws IOException, HandshakeException {
        boolean secure = "https".equalsIgnoreCase(this.request.scheme().toString()) || task.getSSLSupport() != null;
        ClientHandShake clientHS = new ClientHandShake(this.request, secure);
        ServerHandShake server = new ServerHandShake(clientHS.isSecure(), clientHS.getOrigin(), clientHS.getServerHostName(), clientHS.getPort(), clientHS.getResourcePath(), clientHS.getSubProtocol(), clientHS.getKey1(), clientHS.getKey2(), clientHS.getKey3());
        server.respond(this.response);
        this.socket.onConnect();
    }

    public void locallyClosed(SelectionKey key) {
        try {
            key.cancel();
            this.socket.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void remotlyClosed(SelectionKey key) {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean timedOut(SelectionKey Key2) {
        return false;
    }

    public void process(SelectionKey key) {
        if (key.isReadable()) {
            try {
                this.unframe();
            }
            catch (IOException e) {
                ProcessorTask task = this.asyncExecutor.getProcessorTask();
                task.setAptCancelKey(true);
                task.terminateProcess();
                WebSocketEngine.logger.log(Level.INFO, e.getMessage(), e);
            }
        }
    }

    private void unframe() throws IOException {
        ByteChunk chunk = new ByteChunk(8192);
        while (this.inputBuffer.doRead(chunk, this.request) > 0) {
            this.unframe(chunk.toByteBuffer());
        }
    }

    private void unframe(ByteBuffer bytes) throws IOException {
        while (bytes.hasRemaining()) {
            DataFrame dataFrame = new DataFrame(bytes);
            if (dataFrame.getType() == null) continue;
            if (dataFrame.getType() == FrameType.CLOSING) {
                this.socket.onClose();
                continue;
            }
            this.socket.onMessage(dataFrame);
        }
    }

    private void write(byte[] bytes) throws IOException {
        ByteChunk chunk = new ByteChunk(bytes.length);
        chunk.setBytes(bytes, 0, bytes.length);
        this.outputBuffer.doWrite(chunk, this.response);
        this.outputBuffer.flush();
    }

    public void postProcess(SelectionKey key) {
    }

    public void send(DataFrame frame) throws IOException {
        this.write(frame.frame());
    }

    public HttpServletRequest getRequest() throws IOException {
        GrizzlyRequest r = new GrizzlyRequest();
        r.setRequest(this.request);
        return new WSServletRequestImpl(r);
    }

    public HttpServletResponse getResponse() throws IOException {
        GrizzlyResponse r = new GrizzlyResponse();
        r.setResponse(this.response);
        return new HttpServletResponseImpl(r);
    }

    private static class WSServletRequestImpl
    extends HttpServletRequestImpl {
        public WSServletRequestImpl(GrizzlyRequest r) throws IOException {
            super(r);
            this.setContextImpl(new ServletContextImpl());
        }
    }
}

