/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.BaseWebSocket;
import com.sun.grizzly.websockets.ClientNetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketClientApplication;
import com.sun.grizzly.websockets.WebSocketListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketConnectTask
extends FutureTask<WebSocket> {
    private static final int DEFAULT_TIMEOUT = 30;

    public WebSocketConnectTask(final WebSocketClientApplication app, final String address, final WebSocketListener[] listeners) {
        super(new Callable<WebSocket>(){

            @Override
            public WebSocket call() throws Exception {
                URL url = new URL(address);
                ClientNetworkHandler handler = new ClientNetworkHandler(url, app);
                ArrayList<WebSocketListener> listenerList = new ArrayList<WebSocketListener>(Arrays.asList(listeners));
                listenerList.add(app);
                BaseWebSocket socket = (BaseWebSocket)app.createSocket(handler, listenerList.toArray(new WebSocketListener[listenerList.size()]));
                while (!socket.isConnected()) {
                    Thread.sleep(50L);
                }
                return socket;
            }
        });
    }

    @Override
    public WebSocket get() throws InterruptedException, ExecutionException {
        try {
            return (WebSocket)this.get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new InterruptedException(e.getMessage());
        }
    }
}

