/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.sun.grizzly.websockets.BaseServerWebSocket;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketEngine;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.WebSocketProcessor;
import org.atmosphere.util.LoggerUtils;
import org.atmosphere.websocket.WebSocketSupport;

public class GlassFishWebSocketSupport
extends GrizzlyCometSupport {
    private final GrizzlyApplication grizzlyApplication = new GrizzlyApplication();

    public GlassFishWebSocketSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String connection = req.getHeader("Connection");
        if (!"Upgrade".equalsIgnoreCase(connection)) {
            return super.service(req, res);
        }
        AtmosphereServlet.Action action = this.suspended(req, res);
        WebSocketEngine.getEngine().register(req.getRequestURI(), this.grizzlyApplication);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending" + res);
            }
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Resuming" + res);
        }
        return action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    public class GrizzlyWebSocketSupport
    implements WebSocketSupport {
        private final WebSocket webSocket;

        public GrizzlyWebSocketSupport(WebSocket webSocket) {
            this.webSocket = webSocket;
        }

        @Override
        public void writeError(int errorCode, String message) throws IOException {
        }

        @Override
        public void redirect(String location) throws IOException {
        }

        @Override
        public void write(byte frame, String data) throws IOException {
            this.webSocket.send(data);
        }

        @Override
        public void write(byte frame, byte[] data) throws IOException {
            this.webSocket.send(new String(data));
        }

        @Override
        public void write(byte frame, byte[] data, int offset, int length) throws IOException {
            this.webSocket.send(new String(data, offset, length));
        }

        @Override
        public void close() throws IOException {
            this.webSocket.close();
        }
    }

    public class GrizzlyApplication
    extends WebSocketApplication {
        private WebSocketProcessor webSocketProcessor;

        @Override
        public void onConnect(WebSocket w) {
            if (!BaseServerWebSocket.class.isAssignableFrom(w.getClass())) {
                throw new IllegalStateException();
            }
            BaseServerWebSocket webSocket = (BaseServerWebSocket)BaseServerWebSocket.class.cast(w);
            this.webSocketProcessor = new WebSocketProcessor(GlassFishWebSocketSupport.this.config.getServlet(), new GrizzlyWebSocketSupport(webSocket));
            try {
                this.webSocketProcessor.connect(webSocket.getRequest());
            }
            catch (IOException e) {
                LoggerUtils.getLogger().log(Level.WARNING, "", e);
            }
        }

        @Override
        public void onMessage(WebSocket webSocket, DataFrame dataFrame) {
            this.webSocketProcessor.broadcast((byte)0, dataFrame.getTextPayload());
        }

        @Override
        public void onClose(WebSocket webSocket) {
            this.webSocketProcessor.close();
        }
    }
}

