/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.Jetty7CometSupport;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.websocket.WebSocketSupport;

public class Jetty8WebSocketSupport
extends Jetty7CometSupport {
    public Jetty8WebSocketSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String connection = req.getHeader("Connection");
        if (connection == null || !connection.equalsIgnoreCase("Upgrade")) {
            return super.service(req, res);
        }
        AtmosphereServlet.Action action = this.suspended(req, res);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending " + res);
            }
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Resume " + res);
            }
            req.setAttribute(WebSocketSupport.WEBSOCKET_RESUME, "true");
        }
        return action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

